/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.marker;

import hunternif.mc.atlas.marker.DimensionMarkersData;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.network.PacketDispatcher;
import hunternif.mc.atlas.network.client.MarkersPacket;
import hunternif.mc.atlas.util.Log;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldSavedData;

public class MarkersData
extends WorldSavedData {
    private static final int VERSION = 3;
    private static final String TAG_VERSION = "aaVersion";
    private static final String TAG_DIMENSION_MAP_LIST = "dimMap";
    private static final String TAG_DIMENSION_ID = "dimID";
    private static final String TAG_MARKERS = "markers";
    private static final String TAG_MARKER_ID = "id";
    private static final String TAG_MARKER_TYPE = "markerType";
    private static final String TAG_MARKER_LABEL = "label";
    private static final String TAG_MARKER_X = "x";
    private static final String TAG_MARKER_Y = "y";
    private static final String TAG_MARKER_VISIBLE_AHEAD = "visAh";
    public static final int CHUNK_STEP = 8;
    private final Set<EntityPlayer> playersSentTo = new HashSet<EntityPlayer>();
    private final AtomicInteger largestID = new AtomicInteger(0);
    private final Map<Integer, Marker> idMap = new ConcurrentHashMap<Integer, Marker>(2, 0.75f, 2);
    private final Map<Integer, DimensionMarkersData> dimensionMap = new ConcurrentHashMap<Integer, DimensionMarkersData>(2, 0.75f, 2);

    protected int getNewID() {
        return this.largestID.incrementAndGet();
    }

    public MarkersData(String key) {
        super(key);
    }

    public void func_76184_a(NBTTagCompound compound) {
        int version = compound.func_74762_e(TAG_VERSION);
        if (version < 3) {
            Log.warn("Outdated atlas data format! Was %d but current is %d", version, 3);
            this.func_76185_a();
        }
        NBTTagList dimensionMapList = compound.func_150295_c(TAG_DIMENSION_MAP_LIST, 10);
        for (int d = 0; d < dimensionMapList.func_74745_c(); ++d) {
            NBTTagCompound tag = dimensionMapList.func_150305_b(d);
            int dimensionID = tag.func_74762_e(TAG_DIMENSION_ID);
            NBTTagList tagList = tag.func_150295_c(TAG_MARKERS, 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                int id;
                NBTTagCompound markerTag = tagList.func_150305_b(i);
                boolean visibleAhead = true;
                if (version < 2) {
                    Log.warn("Marker is visible ahead by default", new Object[0]);
                } else {
                    visibleAhead = markerTag.func_74767_n(TAG_MARKER_VISIBLE_AHEAD);
                }
                if (version < 3) {
                    id = this.getNewID();
                } else {
                    id = markerTag.func_74762_e(TAG_MARKER_ID);
                    if (this.getMarkerByID(id) != null) {
                        Log.warn("Loading marker with duplicate id %d. Getting new id", id);
                        id = this.getNewID();
                    }
                    this.func_76185_a();
                }
                if (this.largestID.intValue() < id) {
                    this.largestID.set(id);
                }
                Marker marker = new Marker(id, markerTag.func_74779_i(TAG_MARKER_TYPE), markerTag.func_74779_i(TAG_MARKER_LABEL), dimensionID, markerTag.func_74762_e(TAG_MARKER_X), markerTag.func_74762_e(TAG_MARKER_Y), visibleAhead);
                this.loadMarker(marker);
            }
        }
    }

    public void func_76187_b(NBTTagCompound compound) {
        Log.info("Saving local markers data to NBT", new Object[0]);
        compound.func_74768_a(TAG_VERSION, 3);
        NBTTagList dimensionMapList = new NBTTagList();
        for (Integer dimension : this.dimensionMap.keySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a(TAG_DIMENSION_ID, dimension.intValue());
            DimensionMarkersData data = this.getMarkersDataInDimension(dimension);
            NBTTagList tagList = new NBTTagList();
            for (Marker marker : data.getAllMarkers()) {
                Log.debug("Saving marker %s", marker.toString());
                NBTTagCompound markerTag = new NBTTagCompound();
                markerTag.func_74768_a(TAG_MARKER_ID, marker.getId());
                markerTag.func_74778_a(TAG_MARKER_TYPE, marker.getType());
                markerTag.func_74778_a(TAG_MARKER_LABEL, marker.getLabel());
                markerTag.func_74768_a(TAG_MARKER_X, marker.getX());
                markerTag.func_74768_a(TAG_MARKER_Y, marker.getZ());
                markerTag.func_74757_a(TAG_MARKER_VISIBLE_AHEAD, marker.isVisibleAhead());
                tagList.func_74742_a((NBTBase)markerTag);
            }
            tag.func_74782_a(TAG_MARKERS, (NBTBase)tagList);
            dimensionMapList.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a(TAG_DIMENSION_MAP_LIST, (NBTBase)dimensionMapList);
    }

    public Set<Integer> getVisitedDimensions() {
        return this.dimensionMap.keySet();
    }

    public Collection<Marker> getMarkersInDimension(int dimension) {
        return this.getMarkersDataInDimension(dimension).getAllMarkers();
    }

    public DimensionMarkersData getMarkersDataInDimension(int dimension) {
        DimensionMarkersData data = this.dimensionMap.get(dimension);
        if (data == null) {
            data = new DimensionMarkersData(this, dimension);
            this.dimensionMap.put(dimension, data);
        }
        return data;
    }

    public List<Marker> getMarkersAtChunk(int dimension, int x, int z) {
        return this.getMarkersDataInDimension(dimension).getMarkersAtChunk(x, z);
    }

    public Marker getMarkerByID(int id) {
        return this.idMap.get(id);
    }

    public Marker removeMarker(int id) {
        Marker marker = this.getMarkerByID(id);
        if (marker == null) {
            return null;
        }
        if (this.idMap.remove(id) != null) {
            this.getMarkersDataInDimension(marker.getDimension()).removeMarker(marker);
            this.func_76185_a();
        }
        return marker;
    }

    public Marker createAndSaveMarker(String type, String label, int dimension, int x, int z, boolean visibleAhead) {
        Marker marker = new Marker(this.getNewID(), type, label, dimension, x, z, visibleAhead);
        Log.info("Created new marker %s", marker.toString());
        this.idMap.put(marker.getId(), marker);
        this.getMarkersDataInDimension(marker.getDimension()).insertMarker(marker);
        this.func_76185_a();
        return marker;
    }

    public Marker loadMarker(Marker marker) {
        if (!this.idMap.containsKey(marker.getId())) {
            this.idMap.put(marker.getId(), marker);
            this.getMarkersDataInDimension(marker.getDimension()).insertMarker(marker);
        }
        return marker;
    }

    public boolean isSyncedOnPlayer(EntityPlayer player) {
        return this.playersSentTo.contains(player);
    }

    public void syncOnPlayer(int atlasID, EntityPlayer player) {
        for (Integer dimension : this.dimensionMap.keySet()) {
            MarkersPacket packet = this.newMarkersPacket(atlasID, dimension);
            DimensionMarkersData data = this.getMarkersDataInDimension(dimension);
            for (Marker marker : data.getAllMarkers()) {
                packet.putMarker(marker);
            }
            PacketDispatcher.sendTo(packet, (EntityPlayerMP)player);
        }
        Log.info("Sent markers data #%d to player %s", atlasID, player.func_70005_c_());
        this.playersSentTo.add(player);
    }

    protected MarkersPacket newMarkersPacket(int atlasID, int dimension) {
        return new MarkersPacket(atlasID, dimension, new Marker[0]);
    }

    public boolean isEmpty() {
        return this.idMap.isEmpty();
    }
}

