/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.client.gui;

import hunternif.mc.atlas.client.Textures;
import hunternif.mc.atlas.client.gui.core.GuiComponentButton;
import hunternif.mc.atlas.util.AtlasRenderHelper;
import net.minecraft.client.renderer.RenderHelper;
import org.lwjgl.opengl.GL11;

public class GuiArrowButton
extends GuiComponentButton {
    public static final int WIDTH = 12;
    public static final int HEIGHT = 12;
    private static final int IMAGE_WIDTH = 24;
    private static final int IMAGE_HEIGHT = 24;
    public ArrowDirection direction;

    public GuiArrowButton(ArrowDirection direction) {
        this.setSize(12, 12);
        this.direction = direction;
    }

    public static GuiArrowButton up() {
        return new GuiArrowButton(ArrowDirection.UP);
    }

    public static GuiArrowButton down() {
        return new GuiArrowButton(ArrowDirection.DOWN);
    }

    public static GuiArrowButton left() {
        return new GuiArrowButton(ArrowDirection.LEFT);
    }

    public static GuiArrowButton right() {
        return new GuiArrowButton(ArrowDirection.RIGHT);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTick) {
        RenderHelper.func_74518_a();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        int x = this.getGuiX();
        int y = this.getGuiY();
        if (this.isMouseOver) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            int distanceSq = (mouseX - x - this.getWidth() / 2) * (mouseX - x - this.getWidth() / 2) + (mouseY - y - this.getHeight() / 2) * (mouseY - y - this.getHeight() / 2);
            double alpha = distanceSq < 400 ? 0.5 : Math.pow(distanceSq, -0.28);
            GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)alpha);
        }
        int u = 0;
        int v = 0;
        switch (this.direction) {
            case LEFT: {
                u = 0;
                v = 0;
                break;
            }
            case RIGHT: {
                u = 0;
                v = 12;
                break;
            }
            case UP: {
                u = 12;
                v = 0;
                break;
            }
            case DOWN: {
                u = 12;
                v = 12;
            }
        }
        AtlasRenderHelper.drawTexturedRect(Textures.BTN_ARROWS, x, y, u, v, 12, 12, 24, 24);
        GL11.glDisable((int)3042);
    }

    public static enum ArrowDirection {
        UP("Up"),
        DOWN("Down"),
        LEFT("Left"),
        RIGHT("Right");

        public String description;

        private ArrowDirection(String text) {
            this.description = text;
        }
    }
}

