/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.core;

import hunternif.mc.atlas.core.ITileStorage;
import hunternif.mc.atlas.core.Tile;
import hunternif.mc.atlas.util.Log;
import hunternif.mc.atlas.util.Rect;
import net.minecraft.nbt.NBTTagCompound;

public class TileGroup
implements ITileStorage {
    public static final String TAG_POSITION = "p";
    public static final String TAG_TILES = "t";
    public static final int CHUNK_STEP = 16;
    Rect scope = new Rect(0, 0, 16, 16);
    Tile[][] tiles = new Tile[16][16];

    public TileGroup(int x, int y) {
        this.scope.minX = x;
        this.scope.minY = y;
        this.scope.maxX = this.scope.minX + 16 - 1;
        this.scope.maxY = this.scope.minY + 16 - 1;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.scope.minX = compound.func_74759_k(TAG_POSITION)[0];
        this.scope.minY = compound.func_74759_k(TAG_POSITION)[1];
        this.scope.maxX = this.scope.minX + 16 - 1;
        this.scope.maxY = this.scope.minY + 16 - 1;
        int[] tileArray = compound.func_74759_k(TAG_TILES);
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                this.tiles[x][y] = tileArray[x + y * 16] == -1 ? null : new Tile(tileArray[x + y * 16]);
            }
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        int[] tileArray = new int[256];
        int[] pos = new int[]{this.scope.minX, this.scope.minY};
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                tileArray[x + y * 16] = this.tiles[x][y] == null ? -1 : this.tiles[x][y].biomeID;
            }
        }
        compound.func_74783_a(TAG_POSITION, pos);
        compound.func_74783_a(TAG_TILES, tileArray);
        return compound;
    }

    @Override
    public void setTile(int x, int y, Tile tile) {
        if (x >= this.scope.minX && y >= this.scope.minY && x <= this.scope.maxX && y <= this.scope.maxY) {
            int rx = x - this.scope.minX;
            int ry = y - this.scope.minY;
            this.tiles[rx][ry] = tile;
        } else {
            Log.warn("TileGroup tried to set tile out of bounds:\n\tbounds:" + this.scope + "\n\ttarget: x:" + x + ", y:" + y, new Object[0]);
        }
    }

    @Override
    public Tile removeTile(int x, int y) {
        Tile tmp = this.getTile(x, y);
        this.setTile(x, y, null);
        return tmp;
    }

    @Override
    public Tile getTile(int x, int y) {
        if (x >= this.scope.minX && y >= this.scope.minY && x <= this.scope.maxX && y <= this.scope.maxY) {
            int rx = x - this.scope.minX;
            int ry = y - this.scope.minY;
            return this.tiles[rx][ry];
        }
        return null;
    }

    @Override
    public boolean hasTileAt(int x, int y) {
        return this.getTile(x, y) != null;
    }

    @Override
    public Rect getScope() {
        return this.scope;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TileGroup)) {
            return false;
        }
        TileGroup other = (TileGroup)obj;
        if (!this.scope.equals(other.scope)) {
            return false;
        }
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                int b;
                int a = this.tiles[x][y] == null ? -1 : this.tiles[x][y].biomeID;
                int n = b = other.tiles[x][y] == null ? -1 : other.tiles[x][y].biomeID;
                if (a == b) continue;
                return false;
            }
        }
        return true;
    }
}

