/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.network.client;

import hunternif.mc.atlas.client.BiomeTextureMap;
import hunternif.mc.atlas.client.TextureSet;
import hunternif.mc.atlas.ext.ExtTileIdMap;
import hunternif.mc.atlas.ext.ExtTileTextureMap;
import hunternif.mc.atlas.ext.TileIdRegisteredEvent;
import hunternif.mc.atlas.network.AbstractMessage;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileNameIDPacket
extends AbstractMessage.AbstractClientMessage<TileNameIDPacket> {
    private final Map<String, Integer> nameToIdMap;

    public TileNameIDPacket() {
        this.nameToIdMap = new HashMap<String, Integer>();
    }

    public TileNameIDPacket(Map<String, Integer> nameToIdMap) {
        this.nameToIdMap = nameToIdMap;
    }

    public TileNameIDPacket put(String name, int biomeID) {
        this.nameToIdMap.put(name, biomeID);
        return this;
    }

    @Override
    public void read(PacketBuffer buffer) throws IOException {
        int size = buffer.func_150792_a();
        for (int i = 0; i < size; ++i) {
            String name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
            int biomeID = -buffer.func_150792_a();
            this.nameToIdMap.put(name, biomeID);
        }
    }

    @Override
    public void write(PacketBuffer buffer) throws IOException {
        buffer.func_150787_b(this.nameToIdMap.size());
        for (Map.Entry<String, Integer> entry : this.nameToIdMap.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)entry.getKey());
            buffer.func_150787_b(-entry.getValue().intValue());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void process(EntityPlayer player, Side side) {
        for (Map.Entry<String, Integer> entry : this.nameToIdMap.entrySet()) {
            String tileName = entry.getKey();
            int id = entry.getValue();
            int oldID = ExtTileIdMap.instance().getPseudoBiomeID(tileName);
            if (oldID != -1 && oldID != id) {
                BiomeTextureMap.instance().setTexture(Biome.func_185357_a((int)oldID), null);
            }
            ExtTileIdMap.instance().setPseudoBiomeID(tileName, id);
            TextureSet texture = ExtTileTextureMap.instance().getTexture(tileName);
            BiomeTextureMap.instance().setTexture(id, texture);
        }
        MinecraftForge.EVENT_BUS.post((Event)new TileIdRegisteredEvent(this.nameToIdMap));
    }
}

