/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.world;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.config.BiomeConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityCachalotWhale;
import com.github.alexthe666.alexsmobs.world.AMWorldData;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;

public class BeachedCachalotWhaleSpawner {
    private final Random random = new Random();
    private final ServerWorld world;
    private int timer;
    private int delay;
    private int chance;

    public BeachedCachalotWhaleSpawner(ServerWorld p_i50177_1_) {
        this.world = p_i50177_1_;
        this.timer = 1200;
        AMWorldData worldinfo = AMWorldData.get((World)p_i50177_1_);
        this.delay = worldinfo.getBeachedCachalotSpawnDelay();
        this.chance = worldinfo.getBeachedCachalotSpawnChance();
        if (this.delay == 0 && this.chance == 0) {
            this.delay = AMConfig.beachedCachalotWhaleSpawnDelay;
            worldinfo.setBeachedCachalotSpawnDelay(this.delay);
            this.chance = 25;
            worldinfo.setBeachedCachalotSpawnChance(this.chance);
        }
    }

    public void tick() {
        if (AMConfig.beachedCachalotWhales && --this.timer <= 0) {
            this.timer = 1200;
            AMWorldData worldinfo = AMWorldData.get((World)this.world);
            this.delay -= 1200;
            if (this.delay < 0) {
                this.delay = 0;
            }
            worldinfo.setBeachedCachalotSpawnDelay(this.delay);
            if (this.delay <= 0 && this.world.func_72911_I() && this.world.func_72896_J()) {
                this.delay = AMConfig.beachedCachalotWhaleSpawnDelay;
                if (this.world.func_82736_K().func_223586_b(GameRules.field_223601_d)) {
                    int i = this.chance;
                    this.chance = MathHelper.func_76125_a((int)(this.chance + AMConfig.beachedCachalotWhaleSpawnChance), (int)5, (int)100);
                    worldinfo.setBeachedCachalotSpawnChance(this.chance);
                    if (this.random.nextInt(100) <= i && this.func_221245_b()) {
                        this.chance = AMConfig.beachedCachalotWhaleSpawnChance;
                    }
                }
            }
        }
    }

    private boolean func_221245_b() {
        ServerPlayerEntity playerentity = this.world.func_217472_l_();
        if (playerentity == null) {
            return true;
        }
        if (this.random.nextInt(5) != 0) {
            return false;
        }
        BlockPos blockpos = new BlockPos(playerentity.func_213303_ch());
        BlockPos blockpos2 = this.func_221244_a(blockpos, 84);
        if (blockpos2 != null && this.func_226559_a_(blockpos2) && blockpos2.func_177951_i((Vector3i)blockpos) > 225.0) {
            BlockPos upPos = new BlockPos(blockpos2.func_177958_n(), blockpos2.func_177956_o() + 2, blockpos2.func_177952_p());
            EntityCachalotWhale whale = (EntityCachalotWhale)AMEntityRegistry.CACHALOT_WHALE.func_200721_a((World)this.world);
            whale.func_70012_b((double)upPos.func_177958_n() + 0.5, (double)upPos.func_177956_o() + 0.5, (double)upPos.func_177952_p() + 0.5, this.random.nextFloat() * 360.0f - 180.0f, 0.0f);
            whale.func_213386_a((IServerWorld)this.world, this.world.func_175649_E(upPos), SpawnReason.SPAWNER, null, null);
            whale.setBeached(true);
            AMWorldData worldinfo = AMWorldData.get((World)this.world);
            worldinfo.setBeachedCachalotID(whale.func_110124_au());
            whale.func_213390_a(upPos, 16);
            whale.setDespawnBeach(true);
            this.world.func_217376_c((Entity)whale);
            return true;
        }
        return false;
    }

    @Nullable
    private BlockPos func_221244_a(BlockPos p_221244_1_, int p_221244_2_) {
        BlockPos blockpos = null;
        for (int i = 0; i < 10; ++i) {
            int k;
            int l;
            int j = p_221244_1_.func_177958_n() + this.random.nextInt(p_221244_2_ * 2) - p_221244_2_;
            BlockPos blockpos1 = new BlockPos(j, l = this.world.func_201676_a(Heightmap.Type.WORLD_SURFACE, j, k = p_221244_1_.func_177952_p() + this.random.nextInt(p_221244_2_ * 2) - p_221244_2_), k);
            Biome biome = this.world.func_226691_t_(blockpos1);
            if (!BiomeConfig.test(BiomeConfig.cachalot_whale_beached_spawns, biome) || !WorldEntitySpawner.func_209382_a((EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (IWorldReader)this.world, (BlockPos)blockpos1, (EntityType)EntityType.field_220351_aK)) continue;
            blockpos = blockpos1;
            break;
        }
        return blockpos;
    }

    private boolean func_226559_a_(BlockPos p_226559_1_) {
        BlockPos blockpos;
        Iterator var2 = BlockPos.func_218278_a((BlockPos)p_226559_1_, (BlockPos)p_226559_1_.func_177982_a(1, 2, 1)).iterator();
        do {
            if (var2.hasNext()) continue;
            return true;
        } while (this.world.func_180495_p(blockpos = (BlockPos)var2.next()).func_196951_e((IBlockReader)this.world, blockpos).func_197766_b() && this.world.func_204610_c(blockpos).func_206888_e());
        return false;
    }
}

