/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.item;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.citadel.server.item.CustomArmorMaterial;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;

public class ItemModArmor
extends ArmorItem {
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    private Multimap<Attribute, AttributeModifier> attributeMapCroc;
    private Multimap<Attribute, AttributeModifier> attributeMapMoose;

    public ItemModArmor(CustomArmorMaterial armorMaterial, EquipmentSlotType slot) {
        super((IArmorMaterial)armorMaterial, slot, new Item.Properties().func_200916_a(AlexsMobs.TAB));
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.field_200882_e == AMItemRegistry.CENTIPEDE_ARMOR_MATERIAL) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.alexsmobs.centipede_leggings.desc").func_240699_a_(TextFormatting.GRAY));
        }
        if (this.field_200882_e == AMItemRegistry.EMU_ARMOR_MATERIAL) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.alexsmobs.emu_leggings.desc").func_240699_a_(TextFormatting.GRAY));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (this.field_200882_e == AMItemRegistry.ROADRUNNER_ARMOR_MATERIAL) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.alexsmobs.roadrunner_boots.desc").func_240699_a_(TextFormatting.BLUE));
        }
        if (this.field_200882_e == AMItemRegistry.RACCOON_ARMOR_MATERIAL) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.alexsmobs.frontier_cap.desc").func_240699_a_(TextFormatting.BLUE));
        }
    }

    private void buildCrocAttributes(CustomArmorMaterial materialIn) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uuid = ARMOR_MODIFIERS[this.field_77881_a.func_188454_b()];
        builder.put((Object)Attributes.field_233826_i_, (Object)new AttributeModifier(uuid, "Armor modifier", (double)materialIn.func_200902_b(this.field_77881_a), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233827_j_, (Object)new AttributeModifier(uuid, "Armor toughness", (double)materialIn.func_200901_e(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)ForgeMod.SWIM_SPEED.get(), (Object)new AttributeModifier(uuid, "Swim speed", 1.0, AttributeModifier.Operation.ADDITION));
        if (this.field_234655_c_ > 0.0f) {
            builder.put((Object)Attributes.field_233820_c_, (Object)new AttributeModifier(uuid, "Armor knockback resistance", (double)this.field_234655_c_, AttributeModifier.Operation.ADDITION));
        }
        this.attributeMapCroc = builder.build();
    }

    private void buildMooseAttributes(CustomArmorMaterial materialIn) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uuid = ARMOR_MODIFIERS[this.field_77881_a.func_188454_b()];
        builder.put((Object)Attributes.field_233826_i_, (Object)new AttributeModifier(uuid, "Armor modifier", (double)materialIn.func_200902_b(this.field_77881_a), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233827_j_, (Object)new AttributeModifier(uuid, "Armor toughness", (double)materialIn.func_200901_e(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233824_g_, (Object)new AttributeModifier(uuid, "Knockback", 2.0, AttributeModifier.Operation.ADDITION));
        if (this.field_234655_c_ > 0.0f) {
            builder.put((Object)Attributes.field_233820_c_, (Object)new AttributeModifier(uuid, "Armor knockback resistance", (double)this.field_234655_c_, AttributeModifier.Operation.ADDITION));
        }
        this.attributeMapMoose = builder.build();
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        if (this.func_200880_d() == AMItemRegistry.CROCODILE_ARMOR_MATERIAL && equipmentSlot == this.field_77881_a) {
            if (this.attributeMapCroc == null) {
                this.buildCrocAttributes(AMItemRegistry.CROCODILE_ARMOR_MATERIAL);
            }
            return this.attributeMapCroc;
        }
        if (this.func_200880_d() == AMItemRegistry.MOOSE_ARMOR_MATERIAL && equipmentSlot == this.field_77881_a) {
            if (this.attributeMapMoose == null) {
                this.buildMooseAttributes(AMItemRegistry.MOOSE_ARMOR_MATERIAL);
            }
            return this.attributeMapMoose;
        }
        return super.func_111205_h(equipmentSlot);
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        if (this.field_200882_e == AMItemRegistry.CROCODILE_ARMOR_MATERIAL) {
            return "alexsmobs:textures/armor/crocodile_chestplate.png";
        }
        if (this.field_200882_e == AMItemRegistry.ROADRUNNER_ARMOR_MATERIAL) {
            return "alexsmobs:textures/armor/roadrunner_boots.png";
        }
        if (this.field_200882_e == AMItemRegistry.CENTIPEDE_ARMOR_MATERIAL) {
            return "alexsmobs:textures/armor/centipede_leggings.png";
        }
        if (this.field_200882_e == AMItemRegistry.MOOSE_ARMOR_MATERIAL) {
            return "alexsmobs:textures/armor/moose_headgear.png";
        }
        if (this.field_200882_e == AMItemRegistry.RACCOON_ARMOR_MATERIAL) {
            return "alexsmobs:textures/armor/frontier_cap.png";
        }
        if (this.field_200882_e == AMItemRegistry.SOMBRERO_ARMOR_MATERIAL) {
            return "alexsmobs:textures/armor/sombrero.png";
        }
        if (this.field_200882_e == AMItemRegistry.SPIKED_TURTLE_SHELL_ARMOR_MATERIAL) {
            return "alexsmobs:textures/armor/spiked_turtle_shell.png";
        }
        if (this.field_200882_e == AMItemRegistry.FEDORA_ARMOR_MATERIAL) {
            return "alexsmobs:textures/armor/fedora.png";
        }
        if (this.field_200882_e == AMItemRegistry.EMU_ARMOR_MATERIAL) {
            return "alexsmobs:textures/armor/emu_leggings.png";
        }
        return super.getArmorTexture(stack, entity, slot, type);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entity, ItemStack itemStack, EquipmentSlotType armorSlot, A _default) {
        if (this.field_200882_e == AMItemRegistry.ROADRUNNER_ARMOR_MATERIAL) {
            return (A)((BipedModel)AlexsMobs.PROXY.getArmorModel(0, entity));
        }
        if (this.field_200882_e == AMItemRegistry.MOOSE_ARMOR_MATERIAL) {
            return (A)((BipedModel)AlexsMobs.PROXY.getArmorModel(1, entity));
        }
        if (this.field_200882_e == AMItemRegistry.RACCOON_ARMOR_MATERIAL) {
            return (A)((BipedModel)AlexsMobs.PROXY.getArmorModel(2, entity));
        }
        if (this.field_200882_e == AMItemRegistry.SOMBRERO_ARMOR_MATERIAL) {
            return (A)((BipedModel)AlexsMobs.PROXY.getArmorModel(3, entity));
        }
        if (this.field_200882_e == AMItemRegistry.SPIKED_TURTLE_SHELL_ARMOR_MATERIAL) {
            return (A)((BipedModel)AlexsMobs.PROXY.getArmorModel(4, entity));
        }
        if (this.field_200882_e == AMItemRegistry.FEDORA_ARMOR_MATERIAL) {
            return (A)((BipedModel)AlexsMobs.PROXY.getArmorModel(5, entity));
        }
        return (A)super.getArmorModel(entity, itemStack, armorSlot, _default);
    }
}

