/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.EntityRaccoon;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.Items;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class RaccoonAIWash
extends Goal {
    private final EntityRaccoon raccoon;
    private BlockPos waterPos;
    private BlockPos targetPos;
    private int washTime = 0;
    private int executionChance = 30;
    private Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};

    public RaccoonAIWash(EntityRaccoon creature) {
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.raccoon = creature;
    }

    public boolean func_75250_a() {
        if (this.raccoon.func_184614_ca().func_190926_b()) {
            return false;
        }
        if (this.raccoon.lookForWaterBeforeEatingTimer > 0) {
            this.waterPos = this.generateTarget();
            if (this.waterPos != null) {
                this.targetPos = this.getLandPos(this.waterPos);
                return this.targetPos != null;
            }
        }
        return false;
    }

    public void func_75249_e() {
        this.raccoon.lookForWaterBeforeEatingTimer = 1800;
    }

    public void func_75251_c() {
        this.targetPos = null;
        this.waterPos = null;
        this.washTime = 0;
        this.raccoon.setWashPos(null);
        this.raccoon.setWashing(false);
        this.raccoon.lookForWaterBeforeEatingTimer = 100;
        this.raccoon.func_70661_as().func_75499_g();
    }

    public void func_75246_d() {
        if (this.targetPos != null && this.waterPos != null) {
            double dist = this.raccoon.func_195048_a(Vector3d.func_237489_a_((Vector3i)this.waterPos));
            if (dist > 2.0 && this.raccoon.isWashing()) {
                this.raccoon.setWashing(false);
            }
            if (dist <= 1.0) {
                float yaw;
                double d0 = (double)this.waterPos.func_177958_n() + 0.5 - this.raccoon.func_226277_ct_();
                double d2 = (double)this.waterPos.func_177952_p() + 0.5 - this.raccoon.func_226281_cx_();
                this.raccoon.field_70177_z = yaw = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.raccoon.field_70759_as = yaw;
                this.raccoon.field_70761_aq = yaw;
                this.raccoon.func_70661_as().func_75499_g();
                this.raccoon.setWashing(true);
                this.raccoon.setWashPos(this.waterPos);
                this.raccoon.lookForWaterBeforeEatingTimer = 0;
                if (this.washTime % 10 == 0) {
                    this.raccoon.func_184185_a(SoundEvents.field_187549_bG, 0.7f, 0.5f + this.raccoon.func_70681_au().nextFloat());
                }
                ++this.washTime;
                if (this.washTime > 100 || this.raccoon.func_184614_ca().func_77973_b() == Items.field_151102_aT && this.washTime > 20) {
                    this.func_75251_c();
                    if (this.raccoon.func_184614_ca().func_77973_b() != Items.field_151102_aT) {
                        this.raccoon.onEatItem();
                    }
                    this.raccoon.postWashItem(this.raccoon.func_184614_ca());
                    if (this.raccoon.func_184614_ca().hasContainerItem()) {
                        this.raccoon.func_199701_a_(this.raccoon.func_184614_ca().getContainerItem());
                    }
                    this.raccoon.func_184614_ca().func_190918_g(1);
                }
            } else {
                this.raccoon.func_70661_as().func_75492_a((double)this.waterPos.func_177958_n(), (double)this.waterPos.func_177956_o(), (double)this.waterPos.func_177952_p(), 1.2);
            }
        }
    }

    public boolean func_75253_b() {
        if (this.raccoon.func_184614_ca().func_190926_b()) {
            return false;
        }
        return this.targetPos != null && !this.raccoon.func_70090_H() && EntityRaccoon.isFood(this.raccoon.func_184614_ca());
    }

    public BlockPos generateTarget() {
        BlockPos blockpos = null;
        Random random = new Random();
        int range = 32;
        for (int i = 0; i < 15; ++i) {
            BlockPos blockpos1 = this.raccoon.func_233580_cy_().func_177982_a(random.nextInt(range) - range / 2, 3, random.nextInt(range) - range / 2);
            while (this.raccoon.field_70170_p.func_175623_d(blockpos1) && blockpos1.func_177956_o() > 1) {
                blockpos1 = blockpos1.func_177977_b();
            }
            if (!this.isConnectedToLand(blockpos1)) continue;
            blockpos = blockpos1;
        }
        return blockpos;
    }

    public boolean isConnectedToLand(BlockPos pos) {
        if (this.raccoon.field_70170_p.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a)) {
            for (Direction dir : this.HORIZONTALS) {
                BlockPos offsetPos = pos.func_177972_a(dir);
                if (!this.raccoon.field_70170_p.func_204610_c(offsetPos).func_206888_e() || !this.raccoon.field_70170_p.func_204610_c(offsetPos.func_177984_a()).func_206888_e()) continue;
                return true;
            }
        }
        return false;
    }

    public BlockPos getLandPos(BlockPos pos) {
        if (this.raccoon.field_70170_p.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a)) {
            for (Direction dir : this.HORIZONTALS) {
                BlockPos offsetPos = pos.func_177972_a(dir);
                if (!this.raccoon.field_70170_p.func_204610_c(offsetPos).func_206888_e() || !this.raccoon.field_70170_p.func_204610_c(offsetPos.func_177984_a()).func_206888_e()) continue;
                return offsetPos;
            }
        }
        return null;
    }
}

