/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.IFollower;
import java.util.EnumSet;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public class FlyingAIFollowOwner
extends Goal {
    private final TameableEntity tameable;
    private LivingEntity owner;
    private final IWorldReader world;
    private final double followSpeed;
    private final PathNavigator navigator;
    private int timeToRecalcPath;
    private final float maxDist;
    private final float minDist;
    private float oldWaterCost;
    private final boolean teleportToLeaves;
    private IFollower follower;

    public FlyingAIFollowOwner(TameableEntity tameable, double speed, float minDist, float maxDist, boolean teleportToLeaves) {
        this.tameable = tameable;
        this.world = tameable.field_70170_p;
        this.followSpeed = speed;
        this.navigator = tameable.func_70661_as();
        this.minDist = minDist;
        this.maxDist = maxDist;
        this.teleportToLeaves = teleportToLeaves;
        this.follower = (IFollower)tameable;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        LivingEntity livingentity = this.tameable.func_70902_q();
        if (livingentity == null) {
            return false;
        }
        if (livingentity.func_175149_v()) {
            return false;
        }
        if (this.tameable.func_233685_eM_()) {
            return false;
        }
        if (this.tameable.func_70068_e((Entity)livingentity) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        this.owner = livingentity;
        return this.follower.shouldFollow();
    }

    public boolean func_75253_b() {
        if (this.tameable.func_233685_eM_()) {
            return false;
        }
        return this.tameable.func_70068_e((Entity)this.owner) > (double)(this.maxDist * this.maxDist);
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.tameable.func_184643_a(PathNodeType.WATER);
        this.tameable.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.owner = null;
        this.navigator.func_75499_g();
        this.tameable.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        this.tameable.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.tameable.func_70646_bf());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.tameable.func_110167_bD() && !this.tameable.func_184218_aH()) {
                if (this.tameable.func_70068_e((Entity)this.owner) >= 144.0) {
                    this.tryToTeleportNearEntity();
                }
                this.follower.followEntity(this.tameable, this.owner, this.followSpeed);
            }
        }
    }

    private void tryToTeleportNearEntity() {
        BlockPos blockpos = this.owner.func_233580_cy_();
        for (int i = 0; i < 10; ++i) {
            int j = this.getRandomNumber(-3, 3);
            int k = this.getRandomNumber(-1, 1);
            int l = this.getRandomNumber(-3, 3);
            boolean flag = this.tryToTeleportToLocation(blockpos.func_177958_n() + j, blockpos.func_177956_o() + k, blockpos.func_177952_p() + l);
            if (!flag) continue;
            return;
        }
    }

    private boolean tryToTeleportToLocation(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.func_226277_ct_()) < 2.0 && Math.abs((double)z - this.owner.func_226281_cx_()) < 2.0) {
            return false;
        }
        if (!this.isTeleportFriendlyBlock(new BlockPos(x, y, z))) {
            return false;
        }
        this.tameable.func_70012_b((double)x + 0.5, (double)y, (double)z + 0.5, this.tameable.field_70177_z, this.tameable.field_70125_A);
        this.navigator.func_75499_g();
        return true;
    }

    private boolean isTeleportFriendlyBlock(BlockPos pos) {
        PathNodeType pathnodetype = WalkNodeProcessor.func_237231_a_((IBlockReader)this.world, (BlockPos.Mutable)pos.func_239590_i_());
        if (pathnodetype != PathNodeType.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.world.func_180495_p(pos.func_177977_b());
        if (!this.teleportToLeaves && blockstate.func_177230_c() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = pos.func_177973_b((Vector3i)this.tameable.func_233580_cy_());
        return this.world.func_226665_a__((Entity)this.tameable, this.tameable.func_174813_aQ().func_186670_a(blockpos));
    }

    private int getRandomNumber(int min, int max) {
        return this.tameable.func_70681_au().nextInt(max - min + 1) + min;
    }
}

