/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.entity.ai.DirectPathNavigator;
import com.github.alexthe666.alexsmobs.entity.ai.SeagullAIRevealTreasure;
import com.github.alexthe666.alexsmobs.entity.ai.SeagullAIStealFromPlayers;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapDecoration;

public class EntitySeagull
extends AnimalEntity
implements ITargetsDroppedItems {
    private static final DataParameter<Boolean> FLYING = EntityDataManager.func_187226_a(EntitySeagull.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> FLIGHT_LOOK_YAW = EntityDataManager.func_187226_a(EntitySeagull.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> ATTACK_TICK = EntityDataManager.func_187226_a(EntitySeagull.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(EntitySeagull.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Optional<BlockPos>> TREASURE_POS = EntityDataManager.func_187226_a(EntitySeagull.class, (IDataSerializer)DataSerializers.field_187201_k);
    public float prevFlyProgress;
    public float flyProgress;
    public float prevFlapAmount;
    public float flapAmount;
    public boolean aiItemFlag = false;
    public float attackProgress;
    public float prevAttackProgress;
    public float sitProgress;
    public float prevSitProgress;
    public int stealCooldown = this.field_70146_Z.nextInt(2500);
    private boolean isLandNavigator;
    private int timeFlying;
    private BlockPos orbitPos = null;
    private double orbitDist = 5.0;
    private boolean orbitClockwise = false;
    private boolean fallFlag = false;
    private int flightLookCooldown = 0;
    private float targetFlightLookYaw;
    private int heldItemTime = 0;
    public int treasureSitTime;
    public UUID feederUUID = null;

    protected EntitySeagull(EntityType type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.DANGER_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.WATER_BORDER, 16.0f);
        this.func_184644_a(PathNodeType.COCOA, -1.0f);
        this.func_184644_a(PathNodeType.FENCE, -1.0f);
        this.switchNavigator(false);
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.SEAGULL_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.SEAGULL_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.SEAGULL_HURT;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Flying", this.isFlying());
        compound.func_74757_a("Sitting", this.isSitting());
        compound.func_74768_a("StealCooldown", this.stealCooldown);
        compound.func_74768_a("TreasureSitTime", this.treasureSitTime);
        if (this.feederUUID != null) {
            compound.func_186854_a("FeederUUID", this.feederUUID);
        }
        if (this.getTreasurePos() != null) {
            compound.func_74768_a("TresX", this.getTreasurePos().func_177958_n());
            compound.func_74768_a("TresY", this.getTreasurePos().func_177956_o());
            compound.func_74768_a("TresZ", this.getTreasurePos().func_177952_p());
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setFlying(compound.func_74767_n("Flying"));
        this.setSitting(compound.func_74767_n("Sitting"));
        this.stealCooldown = compound.func_74762_e("StealCooldown");
        this.treasureSitTime = compound.func_74762_e("TreasureSitTime");
        if (compound.func_186855_b("FeederUUID")) {
            this.feederUUID = compound.func_186857_a("FeederUUID");
        }
        if (compound.func_74764_b("TresX") && compound.func_74764_b("TresY") && compound.func_74764_b("TresZ")) {
            this.setTreasurePos(new BlockPos(compound.func_74762_e("TresX"), compound.func_74762_e("TresY"), compound.func_74762_e("TresZ")));
        }
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 8.0).func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233821_d_, (double)0.2f);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new SeagullAIRevealTreasure(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new SeagullAIStealFromPlayers(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.0, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196086_aW, AMItemRegistry.LOBSTER_TAIL, AMItemRegistry.COOKED_LOBSTER_TAIL}), false){

            public boolean func_75250_a() {
                return !EntitySeagull.this.aiItemFlag && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(5, (Goal)new AIWanderIdle());
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, CreatureEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(9, (Goal)new AIScatter());
        this.field_70715_bh.func_75776_a(1, (Goal)new AITargetItems((CreatureEntity)this, false, false, 15, 16));
    }

    public boolean func_70877_b(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item == Items.field_196086_aW;
    }

    public static boolean canSeagullSpawn(EntityType<? extends AnimalEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        return worldIn.func_226659_b_(pos, 0) > 8 && worldIn.func_204610_c(pos.func_177977_b()).func_206888_e();
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.seagullSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.field_70765_h = new MovementController((MobEntity)this);
            this.field_70699_by = new GroundPathNavigator((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = true;
        } else {
            this.field_70765_h = new MoveHelper(this);
            this.field_70699_by = new DirectPathNavigator((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = false;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
        this.field_70180_af.func_187214_a(ATTACK_TICK, (Object)0);
        this.field_70180_af.func_187214_a(TREASURE_POS, Optional.empty());
        this.field_70180_af.func_187214_a(FLIGHT_LOOK_YAW, (Object)Float.valueOf(0.0f));
    }

    public boolean isFlying() {
        return (Boolean)this.field_70180_af.func_187225_a(FLYING);
    }

    public void setFlying(boolean flying) {
        if (flying && this.func_70631_g_()) {
            flying = false;
        }
        this.field_70180_af.func_187227_b(FLYING, (Object)flying);
    }

    public boolean isSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    public void setSitting(boolean sitting) {
        this.field_70180_af.func_187227_b(SITTING, (Object)sitting);
    }

    public float getFlightLookYaw() {
        return ((Float)this.field_70180_af.func_187225_a(FLIGHT_LOOK_YAW)).floatValue();
    }

    public void setFlightLookYaw(float yaw) {
        this.field_70180_af.func_187227_b(FLIGHT_LOOK_YAW, (Object)Float.valueOf(yaw));
    }

    public BlockPos getTreasurePos() {
        return ((Optional)this.field_70180_af.func_187225_a(TREASURE_POS)).orElse(null);
    }

    public void setTreasurePos(BlockPos pos) {
        this.field_70180_af.func_187227_b(TREASURE_POS, Optional.ofNullable(pos));
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        boolean prev = super.func_70097_a(source, amount);
        if (prev) {
            this.setSitting(false);
            if (!this.func_184614_ca().func_190926_b()) {
                this.func_199701_a_(this.func_184614_ca());
                this.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                this.stealCooldown = 1500 + this.field_70146_Z.nextInt(1500);
            }
            this.feederUUID = null;
            this.treasureSitTime = 0;
        }
        return prev;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevFlyProgress = this.flyProgress;
        this.prevFlapAmount = this.flapAmount;
        this.prevAttackProgress = this.attackProgress;
        this.prevSitProgress = this.sitProgress;
        float yMot = (float)(-((double)((float)this.func_213322_ci().field_72448_b) * 57.2957763671875));
        float absYaw = Math.abs(this.field_70177_z - this.field_70126_B);
        if (this.isFlying() && this.flyProgress < 5.0f) {
            this.flyProgress += 1.0f;
        }
        if (!this.isFlying() && this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (this.isSitting() && this.sitProgress < 5.0f) {
            this.sitProgress += 1.0f;
        }
        if (!this.isSitting() && this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        this.flapAmount = absYaw > 8.0f ? Math.min(1.0f, this.flapAmount + 0.1f) : (yMot < 0.0f ? Math.min(-yMot * 0.2f, 1.0f) : (this.flapAmount > 0.0f ? (this.flapAmount -= Math.min(this.flapAmount, 0.05f)) : 0.0f));
        if ((Integer)this.field_70180_af.func_187225_a(ATTACK_TICK) > 0) {
            this.field_70180_af.func_187227_b(ATTACK_TICK, (Object)((Integer)this.field_70180_af.func_187225_a(ATTACK_TICK) - 1));
            if (this.attackProgress < 5.0f) {
                this.attackProgress += 1.0f;
            }
        } else if (this.attackProgress > 0.0f) {
            this.attackProgress -= 1.0f;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.isFlying()) {
                float lookYawDist = Math.abs(this.getFlightLookYaw() - this.targetFlightLookYaw);
                if (this.flightLookCooldown > 0) {
                    --this.flightLookCooldown;
                }
                if (this.flightLookCooldown == 0 && this.field_70146_Z.nextInt(4) == 0 && lookYawDist < 0.5f) {
                    this.targetFlightLookYaw = MathHelper.func_76131_a((float)(this.field_70146_Z.nextFloat() * 120.0f - 60.0f), (float)-60.0f, (float)60.0f);
                    this.flightLookCooldown = 3 + this.field_70146_Z.nextInt(15);
                }
                if (this.getFlightLookYaw() < this.targetFlightLookYaw && lookYawDist > 0.5f) {
                    this.setFlightLookYaw(this.getFlightLookYaw() + Math.min(lookYawDist, 4.0f));
                }
                if (this.getFlightLookYaw() > this.targetFlightLookYaw && lookYawDist > 0.5f) {
                    this.setFlightLookYaw(this.getFlightLookYaw() - Math.min(lookYawDist, 4.0f));
                }
                if (this.field_70122_E && !this.func_203005_aq() && this.timeFlying > 30) {
                    this.setFlying(false);
                }
                ++this.timeFlying;
                this.func_189654_d(true);
                if (this.func_184218_aH() || this.func_70880_s()) {
                    this.setFlying(false);
                }
            } else {
                this.fallFlag = false;
                this.timeFlying = 0;
                this.func_189654_d(false);
            }
            if (this.isFlying() && this.isLandNavigator) {
                this.switchNavigator(false);
            }
            if (!this.isFlying() && !this.isLandNavigator) {
                this.switchNavigator(true);
            }
        }
        if (!this.func_184614_ca().func_190926_b()) {
            ++this.heldItemTime;
            if (this.heldItemTime > 200 && this.canTargetItem(this.func_184614_ca())) {
                this.heldItemTime = 0;
                this.func_70691_i(4.0f);
                this.func_184185_a(SoundEvents.field_187537_bA, this.func_70599_aP(), this.func_70647_i());
                if (this.func_184614_ca().hasContainerItem()) {
                    this.func_199701_a_(this.func_184614_ca().getContainerItem());
                }
                this.eatItemEffect(this.func_184614_ca());
                this.func_184614_ca().func_190918_g(1);
            }
        } else {
            this.heldItemTime = 0;
        }
        if (this.stealCooldown > 0) {
            --this.stealCooldown;
        }
        if (this.treasureSitTime > 0) {
            --this.treasureSitTime;
        }
        if (this.isSitting() && this.func_203005_aq()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)0.02f, 0.0));
        }
    }

    public void eatItem() {
        this.heldItemTime = 200;
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return stack.func_77973_b().func_219971_r() && !this.isSitting();
    }

    private void eatItemEffect(ItemStack heldItemMainhand) {
        for (int i = 0; i < 2 + this.field_70146_Z.nextInt(2); ++i) {
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            float radius = this.func_213311_cf() * 0.65f;
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            ItemParticleData data = new ItemParticleData(ParticleTypes.field_197591_B, heldItemMainhand);
            if (heldItemMainhand.func_77973_b() instanceof BlockItem) {
                data = new BlockParticleData(ParticleTypes.field_197611_d, ((BlockItem)heldItemMainhand.func_77973_b()).func_179223_d().func_176223_P());
            }
            this.field_70170_p.func_195594_a((IParticleData)data, this.func_226277_ct_() + extraX, this.func_226278_cu_() + (double)(this.func_213302_cg() * 0.6f), this.func_226281_cx_() + extraZ, d0, d1, d2);
        }
    }

    public void setDataFromTreasureMap(PlayerEntity player) {
        boolean flag = false;
        for (ItemStack map : player.func_184214_aD()) {
            if (map.func_77973_b() != Items.field_151098_aY && map.func_77973_b() != Items.field_151148_bJ || !map.func_77942_o() || !map.func_77978_p().func_150297_b("Decorations", 9)) continue;
            ListNBT listnbt = map.func_77978_p().func_150295_c("Decorations", 10);
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundNBT nbt = listnbt.func_150305_b(i);
                byte type = nbt.func_74771_c("type");
                if (type != MapDecoration.Type.RED_X.func_191163_a() && type != MapDecoration.Type.TARGET_X.func_191163_a()) continue;
                int x = nbt.func_74762_e("x");
                int z = nbt.func_74762_e("z");
                if (!(this.func_70092_e(x, this.func_226278_cu_(), z) <= 400.0)) continue;
                flag = true;
                this.setTreasurePos(new BlockPos(x, 0, z));
            }
        }
        if (flag) {
            this.feederUUID = player.func_110124_au();
            this.treasureSitTime = 300;
            this.stealCooldown = 1500 + this.field_70146_Z.nextInt(1500);
        }
    }

    public void func_213352_e(Vector3d vec3d) {
        if (this.isSitting()) {
            if (this.func_70661_as().func_75505_d() != null) {
                this.func_70661_as().func_75499_g();
            }
            vec3d = Vector3d.field_186680_a;
        }
        super.func_213352_e(vec3d);
    }

    public boolean isWingull() {
        String s = TextFormatting.func_110646_a((String)this.func_200200_C_().getString());
        return s != null && s.toLowerCase().equals("wingull");
    }

    @Override
    public void onGetItem(ItemEntity e) {
        PlayerEntity player;
        ItemStack duplicate = e.func_92059_d().func_77946_l();
        duplicate.func_190920_e(1);
        if (!this.func_184586_b(Hand.MAIN_HAND).func_190926_b() && !this.field_70170_p.field_72995_K) {
            this.func_70099_a(this.func_184586_b(Hand.MAIN_HAND), 0.0f);
        }
        this.stealCooldown += 600 + this.field_70146_Z.nextInt(1200);
        if (e.func_200214_m() != null && (e.func_92059_d().func_77973_b() == AMItemRegistry.LOBSTER_TAIL || e.func_92059_d().func_77973_b() == AMItemRegistry.COOKED_LOBSTER_TAIL) && (player = this.field_70170_p.func_217371_b(e.func_200214_m())) != null) {
            this.setDataFromTreasureMap(player);
            this.feederUUID = e.func_200214_m();
        }
        this.setFlying(true);
        this.func_184611_a(Hand.MAIN_HAND, duplicate);
    }

    public Vector3d getBlockInViewAway(Vector3d fleePos, float radiusAdd) {
        float radius = 5.0f + radiusAdd + (float)this.func_70681_au().nextInt(5);
        float neg = this.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.field_70761_aq;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.func_70681_au().nextFloat() * neg;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        BlockPos radialPos = new BlockPos(fleePos.func_82615_a() + extraX, 0.0, fleePos.func_82616_c() + extraZ);
        BlockPos ground = this.getSeagullGround(radialPos);
        int distFromGround = (int)this.func_226278_cu_() - ground.func_177956_o();
        int flightHeight = 8 + this.func_70681_au().nextInt(4);
        BlockPos newPos = ground.func_177981_b(distFromGround > 3 ? flightHeight : this.func_70681_au().nextInt(4) + 8);
        if (!this.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)newPos)) && this.func_195048_a(Vector3d.func_237489_a_((Vector3i)newPos)) > 1.0) {
            return Vector3d.func_237489_a_((Vector3i)newPos);
        }
        return null;
    }

    public BlockPos getSeagullGround(BlockPos in) {
        BlockPos position = new BlockPos((double)in.func_177958_n(), this.func_226278_cu_(), (double)in.func_177952_p());
        while (position.func_177956_o() < 256 && !this.field_70170_p.func_204610_c(position).func_206888_e()) {
            position = position.func_177984_a();
        }
        while (position.func_177956_o() > 2 && this.field_70170_p.func_175623_d(position)) {
            position = position.func_177977_b();
        }
        return position;
    }

    public Vector3d getBlockGrounding(Vector3d fleePos) {
        float radius = 10 + this.func_70681_au().nextInt(15);
        float neg = this.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.field_70761_aq;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.func_70681_au().nextFloat() * neg;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        BlockPos radialPos = new BlockPos(fleePos.func_82615_a() + extraX, this.func_226278_cu_(), fleePos.func_82616_c() + extraZ);
        BlockPos ground = this.getSeagullGround(radialPos);
        if (ground.func_177956_o() == 0) {
            return this.func_213303_ch();
        }
        ground = this.func_233580_cy_();
        while (ground.func_177956_o() > 2 && this.field_70170_p.func_175623_d(ground)) {
            ground = ground.func_177977_b();
        }
        if (!this.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)ground.func_177984_a()))) {
            return Vector3d.func_237489_a_((Vector3i)ground);
        }
        return null;
    }

    public boolean isTargetBlocked(Vector3d target) {
        Vector3d Vector3d2 = new Vector3d(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
        return this.field_70170_p.func_217299_a(new RayTraceContext(Vector3d2, target, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this)).func_216346_c() != RayTraceResult.Type.MISS;
    }

    private Vector3d getOrbitVec(Vector3d vector3d, float gatheringCircleDist) {
        Vector3d pos;
        float angle = (float)Math.PI / 180 * (float)this.orbitDist * (float)(this.orbitClockwise ? -this.field_70173_aa : this.field_70173_aa);
        double extraX = gatheringCircleDist * MathHelper.func_76126_a((float)angle);
        double extraZ = gatheringCircleDist * MathHelper.func_76134_b((float)angle);
        if (this.orbitPos != null && this.field_70170_p.func_175623_d(new BlockPos(pos = new Vector3d((double)this.orbitPos.func_177958_n() + extraX, (double)(this.orbitPos.func_177956_o() + this.field_70146_Z.nextInt(2)), (double)this.orbitPos.func_177952_p() + extraZ)))) {
            return pos;
        }
        return null;
    }

    private boolean isOverWaterOrVoid() {
        BlockPos position = this.func_233580_cy_();
        while (position.func_177956_o() > 0 && this.field_70170_p.func_175623_d(position)) {
            position = position.func_177977_b();
        }
        return !this.field_70170_p.func_204610_c(position).func_206888_e() || position.func_177956_o() <= 0;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        ActionResultType type = super.func_230254_b_(player, hand);
        if (!this.func_184614_ca().func_190926_b() && type != ActionResultType.SUCCESS) {
            this.func_199701_a_(this.func_184614_ca().func_77946_l());
            this.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
            this.stealCooldown = 1500 + this.field_70146_Z.nextInt(1500);
            return ActionResultType.SUCCESS;
        }
        return type;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return (AgeableEntity)AMEntityRegistry.SEAGULL.func_200721_a((World)serverWorld);
    }

    public void peck() {
        this.field_70180_af.func_187227_b(ATTACK_TICK, (Object)7);
    }

    private class AITargetItems
    extends CreatureAITargetItems {
        public AITargetItems(CreatureEntity creature, boolean checkSight, boolean onlyNearby, int tickThreshold, int radius) {
            super(creature, checkSight, onlyNearby, tickThreshold, radius);
            this.executionChance = 1;
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            ((EntitySeagull)this.field_75299_d).aiItemFlag = false;
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a() && !((EntitySeagull)this.field_75299_d).isSitting() && (this.field_75299_d.func_70638_az() == null || !this.field_75299_d.func_70638_az().func_70089_S());
        }

        @Override
        public boolean func_75253_b() {
            return super.func_75253_b() && !((EntitySeagull)this.field_75299_d).isSitting() && (this.field_75299_d.func_70638_az() == null || !this.field_75299_d.func_70638_az().func_70089_S());
        }

        @Override
        protected void moveTo() {
            EntitySeagull crow = (EntitySeagull)this.field_75299_d;
            if (this.targetEntity != null) {
                crow.aiItemFlag = true;
                if (this.field_75299_d.func_70032_d((Entity)this.targetEntity) < 2.0f) {
                    crow.func_70605_aq().func_75642_a(this.targetEntity.func_226277_ct_(), this.targetEntity.func_226278_cu_(), this.targetEntity.func_226281_cx_(), 1.5);
                    crow.peck();
                }
                if (this.field_75299_d.func_70032_d((Entity)this.targetEntity) > 8.0f || crow.isFlying()) {
                    crow.setFlying(true);
                    float f = (float)(crow.func_226277_ct_() - this.targetEntity.func_226277_ct_());
                    float f1 = 1.8f;
                    float f2 = (float)(crow.func_226281_cx_() - this.targetEntity.func_226281_cx_());
                    float xzDist = MathHelper.func_76129_c((float)(f * f + f2 * f2));
                    if (!crow.func_70685_l((Entity)this.targetEntity)) {
                        crow.func_70605_aq().func_75642_a(this.targetEntity.func_226277_ct_(), 1.0 + crow.func_226278_cu_(), this.targetEntity.func_226281_cx_(), 1.5);
                    } else {
                        if (xzDist < 5.0f) {
                            f1 = 0.0f;
                        }
                        crow.func_70605_aq().func_75642_a(this.targetEntity.func_226277_ct_(), (double)f1 + this.targetEntity.func_226278_cu_(), this.targetEntity.func_226281_cx_(), 1.5);
                    }
                } else {
                    this.field_75299_d.func_70661_as().func_75492_a(this.targetEntity.func_226277_ct_(), this.targetEntity.func_226278_cu_(), this.targetEntity.func_226281_cx_(), 1.5);
                }
            }
        }

        @Override
        public void func_75246_d() {
            super.func_75246_d();
            this.moveTo();
        }
    }

    class MoveHelper
    extends MovementController {
        private final EntitySeagull parentEntity;

        public MoveHelper(EntitySeagull bird) {
            super((MobEntity)bird);
            this.parentEntity = bird;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                Vector3d vector3d = new Vector3d(this.field_75646_b - this.parentEntity.func_226277_ct_(), this.field_75647_c - this.parentEntity.func_226278_cu_(), this.field_75644_d - this.parentEntity.func_226281_cx_());
                double d5 = vector3d.func_72433_c();
                if (d5 < 0.3) {
                    this.field_188491_h = MovementController.Action.WAIT;
                    this.parentEntity.func_213317_d(this.parentEntity.func_213322_ci().func_186678_a(0.5));
                } else {
                    double d1 = this.field_75647_c - this.parentEntity.func_226278_cu_();
                    float yScale = d1 > 0.0 || EntitySeagull.this.fallFlag ? 1.0f : 0.7f;
                    this.parentEntity.func_213317_d(this.parentEntity.func_213322_ci().func_178787_e(vector3d.func_186678_a(this.field_75645_e * 0.03 / d5)));
                    Vector3d vector3d1 = this.parentEntity.func_213322_ci();
                    this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)vector3d1.field_72450_a, (double)vector3d1.field_72449_c)) * 57.295776f;
                }
            }
        }
    }

    private class AIWanderIdle
    extends Goal {
        protected final EntitySeagull eagle;
        protected double x;
        protected double y;
        protected double z;
        private boolean flightTarget = false;
        private int orbitResetCooldown = 0;
        private int maxOrbitTime = 360;
        private int orbitTime = 0;

        public AIWanderIdle() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
            this.eagle = EntitySeagull.this;
        }

        public boolean func_75250_a() {
            if (this.orbitResetCooldown < 0) {
                ++this.orbitResetCooldown;
            }
            if (this.eagle.func_70638_az() != null && this.eagle.func_70638_az().func_70089_S() && !this.eagle.func_184207_aI() || this.eagle.isSitting() || this.eagle.func_184218_aH()) {
                return false;
            }
            if (this.eagle.func_70681_au().nextInt(20) != 0 && !this.eagle.isFlying() || this.eagle.aiItemFlag) {
                return false;
            }
            if (this.eagle.func_70631_g_()) {
                this.flightTarget = false;
            } else if (this.eagle.func_203005_aq()) {
                this.flightTarget = true;
            } else if (this.eagle.func_233570_aj_()) {
                this.flightTarget = EntitySeagull.this.field_70146_Z.nextInt(10) == 0;
            } else {
                if (this.orbitResetCooldown == 0 && EntitySeagull.this.field_70146_Z.nextInt(6) == 0) {
                    this.orbitResetCooldown = 100 + EntitySeagull.this.field_70146_Z.nextInt(300);
                    this.eagle.orbitPos = this.eagle.func_233580_cy_();
                    this.eagle.orbitDist = 4 + EntitySeagull.this.field_70146_Z.nextInt(5);
                    this.eagle.orbitClockwise = EntitySeagull.this.field_70146_Z.nextBoolean();
                    this.orbitTime = 0;
                    this.maxOrbitTime = (int)(180.0f + 360.0f * EntitySeagull.this.field_70146_Z.nextFloat());
                }
                this.flightTarget = EntitySeagull.this.field_70146_Z.nextInt(5) != 0 && this.eagle.timeFlying < 400;
            }
            Vector3d lvt_1_1_ = this.getPosition();
            if (lvt_1_1_ == null) {
                return false;
            }
            this.x = lvt_1_1_.field_72450_a;
            this.y = lvt_1_1_.field_72448_b;
            this.z = lvt_1_1_.field_72449_c;
            return true;
        }

        public void func_75246_d() {
            if (this.orbitResetCooldown > 0) {
                --this.orbitResetCooldown;
            }
            if (this.orbitResetCooldown < 0) {
                ++this.orbitResetCooldown;
            }
            if (this.orbitResetCooldown > 0 && this.eagle.orbitPos != null) {
                if (this.orbitTime < this.maxOrbitTime && !this.eagle.func_203005_aq()) {
                    ++this.orbitTime;
                } else {
                    this.orbitTime = 0;
                    this.eagle.orbitPos = null;
                    this.orbitResetCooldown = -400 - EntitySeagull.this.field_70146_Z.nextInt(400);
                }
            }
            if (this.eagle.field_70123_F && !this.eagle.field_70122_E) {
                this.func_75251_c();
            }
            if (this.flightTarget) {
                this.eagle.func_70605_aq().func_75642_a(this.x, this.y, this.z, 1.0);
            } else if (this.eagle.isFlying() && !this.eagle.field_70122_E) {
                if (!this.eagle.func_203005_aq()) {
                    // empty if block
                }
            } else {
                this.eagle.func_70661_as().func_75492_a(this.x, this.y, this.z, 1.0);
            }
            if (!this.flightTarget && EntitySeagull.this.isFlying()) {
                this.eagle.fallFlag = true;
                if (this.eagle.field_70122_E) {
                    this.eagle.setFlying(false);
                    this.orbitTime = 0;
                    this.eagle.orbitPos = null;
                    this.orbitResetCooldown = -400 - EntitySeagull.this.field_70146_Z.nextInt(400);
                }
            }
            if (EntitySeagull.this.isFlying() && (!EntitySeagull.this.field_70170_p.func_175623_d(this.eagle.func_226270_aj_()) || this.eagle.field_70122_E) && !this.eagle.func_203005_aq() && this.eagle.timeFlying > 30) {
                this.eagle.setFlying(false);
                this.orbitTime = 0;
                this.eagle.orbitPos = null;
                this.orbitResetCooldown = -400 - EntitySeagull.this.field_70146_Z.nextInt(400);
            }
        }

        @Nullable
        protected Vector3d getPosition() {
            Vector3d vector3d = this.eagle.func_213303_ch();
            if (this.orbitResetCooldown > 0 && this.eagle.orbitPos != null) {
                return this.eagle.getOrbitVec(vector3d, 4 + EntitySeagull.this.field_70146_Z.nextInt(4));
            }
            if (this.eagle.func_184207_aI() || this.eagle.isOverWaterOrVoid()) {
                this.flightTarget = true;
            }
            if (this.flightTarget) {
                if (this.eagle.timeFlying < 340 || this.eagle.func_184207_aI() || this.eagle.isOverWaterOrVoid()) {
                    return this.eagle.getBlockInViewAway(vector3d, 0.0f);
                }
                return this.eagle.getBlockGrounding(vector3d);
            }
            return RandomPositionGenerator.func_75463_a((CreatureEntity)this.eagle, (int)10, (int)7);
        }

        public boolean func_75253_b() {
            if (this.flightTarget) {
                return this.eagle.isFlying() && this.eagle.func_70092_e(this.x, this.y, this.z) > 4.0;
            }
            return !this.eagle.func_70661_as().func_75500_f() && !this.eagle.func_184207_aI();
        }

        public void func_75249_e() {
            if (this.flightTarget) {
                this.eagle.setFlying(true);
                this.eagle.func_70605_aq().func_75642_a(this.x, this.y, this.z, 1.0);
            } else {
                this.eagle.func_70661_as().func_75492_a(this.x, this.y, this.z, 1.0);
            }
        }

        public void func_75251_c() {
            this.eagle.func_70661_as().func_75499_g();
            super.func_75251_c();
        }
    }

    private class AIScatter
    extends Goal {
        protected final Sorter theNearestAttackableTargetSorter;
        protected final Predicate<? super Entity> targetEntitySelector;
        protected int executionChance = 8;
        protected boolean mustUpdate;
        private Entity targetEntity;
        private Vector3d flightTarget = null;
        private int cooldown = 0;
        private ITag tag;

        AIScatter() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
            this.tag = EntityTypeTags.func_219762_a().func_199910_a(AMTagRegistry.SCATTERS_CROWS);
            this.theNearestAttackableTargetSorter = new Sorter((Entity)EntitySeagull.this);
            this.targetEntitySelector = new Predicate<Entity>(){

                public boolean apply(@Nullable Entity e) {
                    return e.func_70089_S() && e.func_200600_R().func_220341_a(AIScatter.this.tag) || e instanceof PlayerEntity && !((PlayerEntity)e).func_184812_l_();
                }
            };
        }

        public boolean func_75250_a() {
            List list;
            if (EntitySeagull.this.func_184218_aH() || EntitySeagull.this.isSitting() || EntitySeagull.this.aiItemFlag || EntitySeagull.this.func_184207_aI()) {
                return false;
            }
            if (!this.mustUpdate) {
                long worldTime = EntitySeagull.this.field_70170_p.func_82737_E() % 10L;
                if (EntitySeagull.this.func_70654_ax() >= 100 && worldTime != 0L) {
                    return false;
                }
                if (EntitySeagull.this.func_70681_au().nextInt(this.executionChance) != 0 && worldTime != 0L) {
                    return false;
                }
            }
            if ((list = EntitySeagull.this.field_70170_p.func_175647_a(Entity.class, this.getTargetableArea(this.getTargetDistance()), this.targetEntitySelector)).isEmpty()) {
                return false;
            }
            Collections.sort(list, this.theNearestAttackableTargetSorter);
            this.targetEntity = (Entity)list.get(0);
            this.mustUpdate = false;
            return true;
        }

        public boolean func_75253_b() {
            return this.targetEntity != null;
        }

        public void func_75251_c() {
            this.flightTarget = null;
            this.targetEntity = null;
        }

        public void func_75246_d() {
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            if (this.flightTarget != null) {
                EntitySeagull.this.setFlying(true);
                EntitySeagull.this.func_70605_aq().func_75642_a(this.flightTarget.field_72450_a, this.flightTarget.field_72448_b, this.flightTarget.field_72449_c, 1.0);
                if (this.cooldown == 0 && EntitySeagull.this.isTargetBlocked(this.flightTarget)) {
                    this.cooldown = 30;
                    this.flightTarget = null;
                }
            }
            if (this.targetEntity != null) {
                Vector3d vec;
                if ((EntitySeagull.this.field_70122_E || this.flightTarget == null || this.flightTarget != null && EntitySeagull.this.func_195048_a(this.flightTarget) < 3.0) && (vec = EntitySeagull.this.getBlockInViewAway(this.targetEntity.func_213303_ch(), 0.0f)) != null && vec.func_82617_b() > EntitySeagull.this.func_226278_cu_()) {
                    this.flightTarget = vec;
                }
                if (EntitySeagull.this.func_70032_d(this.targetEntity) > 20.0f) {
                    this.func_75251_c();
                }
            }
        }

        protected double getTargetDistance() {
            return 4.0;
        }

        protected AxisAlignedBB getTargetableArea(double targetDistance) {
            Vector3d renderCenter = new Vector3d(EntitySeagull.this.func_226277_ct_(), EntitySeagull.this.func_226278_cu_() + 0.5, EntitySeagull.this.func_226281_cx_());
            AxisAlignedBB aabb = new AxisAlignedBB(-2.0, -2.0, -2.0, 2.0, 2.0, 2.0);
            return aabb.func_191194_a(renderCenter);
        }

        public class Sorter
        implements Comparator<Entity> {
            private final Entity theEntity;

            public Sorter(Entity theEntityIn) {
                this.theEntity = theEntityIn;
            }

            @Override
            public int compare(Entity p_compare_1_, Entity p_compare_2_) {
                double d1;
                double d0 = this.theEntity.func_70068_e(p_compare_1_);
                return d0 < (d1 = this.theEntity.func_70068_e(p_compare_2_)) ? -1 : (d0 > d1 ? 1 : 0);
            }
        }
    }
}

