/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityRattlesnake;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIWanderRanged;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityRoadrunner
extends AnimalEntity {
    public float oFlapSpeed;
    public float oFlap;
    public float wingRotDelta = 1.0f;
    public float wingRotation;
    public float destPos;
    public float prevAttackProgress;
    public float attackProgress;
    private static final DataParameter<Integer> ATTACK_TICK = EntityDataManager.func_187226_a(EntityRoadrunner.class, (IDataSerializer)DataSerializers.field_187192_b);
    public int timeUntilNextFeather = this.field_70146_Z.nextInt(24000) + 24000;

    protected EntityRoadrunner(EntityType type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.1, Ingredient.func_199805_a((ITag)ItemTags.func_199903_a().func_199910_a(AMTagRegistry.INSECT_ITEMS)), false));
        this.field_70714_bg.func_75776_a(5, (Goal)new AnimalAIWanderRanged((CreatureEntity)this, 50, 1.0, 25, 7));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, EntityRattlesnake.class, 55, true, true, null));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{EntityRattlesnake.class}).func_220794_a(new Class[0]));
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("FeatherTime")) {
            this.timeUntilNextFeather = compound.func_74762_e("FeatherTime");
        }
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.roadrunnerSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("FeatherTime", this.timeUntilNextFeather);
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.ROADRUNNER_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.ROADRUNNER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.ROADRUNNER_HURT;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACK_TICK, (Object)0);
    }

    public boolean func_70652_k(Entity entityIn) {
        this.field_70180_af.func_187227_b(ATTACK_TICK, (Object)5);
        return true;
    }

    public boolean func_180431_b(DamageSource source) {
        return source == DamageSource.field_76367_g || super.func_180431_b(source);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 8.0).func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233821_d_, (double)0.45f).func_233815_a_(Attributes.field_233819_b_, 10.0);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.oFlap = this.wingRotation;
        this.prevAttackProgress = this.attackProgress;
        this.oFlapSpeed = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E ? -1 : 4) * 0.3);
        this.destPos = MathHelper.func_76131_a((float)this.destPos, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && this.wingRotDelta < 1.0f) {
            this.wingRotDelta = 1.0f;
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && !this.func_70631_g_() && --this.timeUntilNextFeather <= 0) {
            this.func_199703_a((IItemProvider)AMItemRegistry.ROADRUNNER_FEATHER);
            this.timeUntilNextFeather = this.field_70146_Z.nextInt(24000) + 24000;
        }
        this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
        Vector3d vector3d = this.func_213322_ci();
        if (!this.field_70122_E && vector3d.field_72448_b < 0.0) {
            this.func_213317_d(vector3d.func_216372_d(1.0, 0.6, 1.0));
        }
        this.wingRotation += this.wingRotDelta * 2.0f;
        if ((Integer)this.field_70180_af.func_187225_a(ATTACK_TICK) > 0) {
            if ((Integer)this.field_70180_af.func_187225_a(ATTACK_TICK) == 2 && this.func_70638_az() != null && (double)this.func_70032_d((Entity)this.func_70638_az()) < 1.3) {
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 2.0f);
            }
            this.field_70180_af.func_187227_b(ATTACK_TICK, (Object)((Integer)this.field_70180_af.func_187225_a(ATTACK_TICK) - 1));
            if (this.attackProgress < 5.0f) {
                this.attackProgress += 1.0f;
            }
        } else if (this.attackProgress > 0.0f) {
            this.attackProgress -= 1.0f;
        }
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 1.0f);
    }

    public boolean func_70877_b(ItemStack stack) {
        Item item = stack.func_77973_b();
        return ItemTags.func_199903_a().func_199910_a(AMTagRegistry.INSECT_ITEMS).func_230235_a_((Object)stack.func_77973_b());
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return (AgeableEntity)AMEntityRegistry.ROADRUNNER.func_200721_a((World)p_241840_1_);
    }

    public static boolean canRoadrunnerSpawn(EntityType<? extends AnimalEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        boolean spawnBlock = BlockTags.func_199896_a().func_199910_a(AMTagRegistry.ROADRUNNER_SPAWNS).func_230235_a_((Object)worldIn.func_180495_p(pos.func_177977_b()).func_177230_c());
        return spawnBlock && worldIn.func_226659_b_(pos, 0) > 8;
    }
}

