/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIWanderRanged;
import com.github.alexthe666.alexsmobs.entity.ai.DirectPathNavigator;
import com.github.alexthe666.alexsmobs.entity.ai.MimiCubeAIRangedAttack;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShootableItem;
import net.minecraft.item.TridentItem;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityMimicube
extends MonsterEntity
implements IRangedAttackMob {
    private static final DataParameter<Integer> ATTACK_TICK = EntityDataManager.func_187226_a(EntityMimicube.class, (IDataSerializer)DataSerializers.field_187192_b);
    private final MimiCubeAIRangedAttack aiArrowAttack = new MimiCubeAIRangedAttack(this, 1.0, 10, 15.0f);
    private final MeleeAttackGoal aiAttackOnCollide = new MeleeAttackGoal((CreatureEntity)this, 1.2, false);
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    public float leftSwapProgress = 0.0f;
    public float prevLeftSwapProgress = 0.0f;
    public float rightSwapProgress = 0.0f;
    public float prevRightSwapProgress = 0.0f;
    public float helmetSwapProgress = 0.0f;
    public float prevHelmetSwapProgress = 0.0f;
    public float prevAttackProgress;
    public float attackProgress;
    private boolean wasOnGround;
    private int eatingTicks;

    protected EntityMimicube(EntityType type, World world) {
        super(type, world);
        this.field_70765_h = new MimicubeMoveHelper(this);
        this.field_70699_by = new DirectPathNavigator((MobEntity)this, world);
        this.setCombatTask();
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233821_d_, (double)0.45f);
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.mimicubeSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACK_TICK, (Object)0);
    }

    public boolean func_70652_k(Entity entityIn) {
        this.field_70180_af.func_187227_b(ATTACK_TICK, (Object)5);
        return true;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new AnimalAIWanderRanged((CreatureEntity)this, 60, 1.0, 10, 7));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, true));
    }

    public void setCombatTask() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a((Goal)this.aiAttackOnCollide);
            this.field_70714_bg.func_85156_a((Goal)this.aiArrowAttack);
            ItemStack itemstack = this.func_184614_ca();
            if (itemstack.func_77973_b() instanceof ShootableItem || itemstack.func_77973_b() instanceof TridentItem) {
                int i = 10;
                if (this.field_70170_p.func_175659_aa() != Difficulty.HARD) {
                    i = 30;
                }
                this.aiArrowAttack.setAttackCooldown(i);
                this.field_70714_bg.func_75776_a(4, (Goal)this.aiArrowAttack);
            } else {
                this.field_70714_bg.func_75776_a(4, (Goal)this.aiAttackOnCollide);
            }
        }
    }

    public void attackEntityWithRangedAttackTrident(LivingEntity target, float distanceFactor) {
        TridentEntity tridententity = new TridentEntity(this.field_70170_p, (LivingEntity)this, new ItemStack((IItemProvider)Items.field_203184_eO));
        double d0 = target.func_226277_ct_() - this.func_226277_ct_();
        double d1 = target.func_226283_e_(0.3333333333333333) - tridententity.func_226278_cu_();
        double d2 = target.func_226281_cx_() - this.func_226281_cx_();
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        tridententity.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_204780_be, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)tridententity);
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        if (this.func_184614_ca().func_77973_b() instanceof TridentItem) {
            this.attackEntityWithRangedAttackTrident(target, distanceFactor);
            return;
        }
        ItemStack itemstack = this.func_213356_f(this.func_184614_ca());
        AbstractArrowEntity abstractarrowentity = this.fireArrow(itemstack, distanceFactor);
        if (this.func_184614_ca().func_77973_b() instanceof BowItem) {
            abstractarrowentity = ((BowItem)this.func_184614_ca().func_77973_b()).customArrow(abstractarrowentity);
        }
        double d0 = target.func_226277_ct_() - this.func_226277_ct_();
        double d1 = target.func_226283_e_(0.3333333333333333) - abstractarrowentity.func_226278_cu_();
        double d2 = target.func_226281_cx_() - this.func_226281_cx_();
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        abstractarrowentity.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)abstractarrowentity);
    }

    protected AbstractArrowEntity fireArrow(ItemStack arrowStack, float distanceFactor) {
        return ProjectileHelper.func_221272_a((LivingEntity)this, (ItemStack)arrowStack, (float)distanceFactor);
    }

    public boolean func_230280_a_(ShootableItem p_230280_1_) {
        return p_230280_1_ == Items.field_151031_f;
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
        if (slotIn == EquipmentSlotType.HEAD && !stack.func_77969_a(this.func_184582_a(EquipmentSlotType.HEAD))) {
            this.helmetSwapProgress = 5.0f;
            this.field_70170_p.func_72960_a((Entity)this, (byte)45);
        }
        if (slotIn == EquipmentSlotType.MAINHAND && !stack.func_77969_a(this.func_184582_a(EquipmentSlotType.MAINHAND))) {
            this.rightSwapProgress = 5.0f;
            this.field_70170_p.func_72960_a((Entity)this, (byte)46);
        }
        if (slotIn == EquipmentSlotType.OFFHAND && !stack.func_77969_a(this.func_184582_a(EquipmentSlotType.OFFHAND))) {
            this.leftSwapProgress = 5.0f;
            this.field_70170_p.func_72960_a((Entity)this, (byte)47);
        }
        super.func_184201_a(slotIn, stack);
        if (!this.field_70170_p.field_72995_K) {
            this.setCombatTask();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 45) {
            this.helmetSwapProgress = 5.0f;
        }
        if (id == 46) {
            this.rightSwapProgress = 5.0f;
        }
        if (id == 47) {
            this.leftSwapProgress = 5.0f;
        }
    }

    public boolean func_184585_cz() {
        return this.func_184614_ca().isShield((LivingEntity)this) || this.func_184592_cb().isShield((LivingEntity)this);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity trueSource = source.func_76346_g();
        if (trueSource != null && trueSource instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)trueSource;
            if (!attacker.func_184582_a(EquipmentSlotType.HEAD).func_190926_b()) {
                this.func_184201_a(EquipmentSlotType.HEAD, this.mimicStack(attacker.func_184582_a(EquipmentSlotType.HEAD)));
            }
            if (!attacker.func_184582_a(EquipmentSlotType.OFFHAND).func_190926_b()) {
                this.func_184201_a(EquipmentSlotType.OFFHAND, this.mimicStack(attacker.func_184582_a(EquipmentSlotType.OFFHAND)));
            }
            if (!attacker.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b()) {
                this.func_184201_a(EquipmentSlotType.MAINHAND, this.mimicStack(attacker.func_184582_a(EquipmentSlotType.MAINHAND)));
            }
        }
        return super.func_70097_a(source, amount);
    }

    private ItemStack mimicStack(ItemStack stack) {
        ItemStack copy = stack.func_77946_l();
        if (copy.func_77984_f()) {
            copy.func_196085_b(copy.func_77958_k());
        }
        return copy;
    }

    public void func_70071_h_() {
        int i;
        super.func_70071_h_();
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        this.prevHelmetSwapProgress = this.helmetSwapProgress;
        this.prevRightSwapProgress = this.rightSwapProgress;
        this.prevLeftSwapProgress = this.leftSwapProgress;
        this.prevAttackProgress = this.attackProgress;
        if (this.rightSwapProgress > 0.0f) {
            this.rightSwapProgress -= 0.5f;
        }
        if (this.leftSwapProgress > 0.0f) {
            this.leftSwapProgress -= 0.5f;
        }
        if (this.helmetSwapProgress > 0.0f) {
            this.helmetSwapProgress -= 0.5f;
        }
        if (this.field_70122_E && !this.wasOnGround) {
            for (int j = 0; j < 8; ++j) {
                float f = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
                float f2 = MathHelper.func_76126_a((float)f) * 0.5f * f1;
                float f3 = MathHelper.func_76134_b((float)f) * 0.5f * f1;
                this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)AMItemRegistry.MIMICREAM)), this.func_226277_ct_() + (double)f2, this.func_226278_cu_(), this.func_226281_cx_() + (double)f3, 0.0, 0.0, 0.0);
            }
            this.func_184185_a(this.getSquishSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            this.squishAmount = -0.35f;
        } else if (!this.field_70122_E && this.wasOnGround) {
            this.squishAmount = 2.0f;
        }
        if (this.func_70090_H()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.05, 0.0));
        }
        if (this.func_184592_cb().func_77973_b().func_219971_r() && this.func_110143_aJ() < this.func_110138_aP()) {
            if (this.eatingTicks < 100) {
                for (i = 0; i < 3; ++i) {
                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, this.func_184586_b(Hand.OFF_HAND)), this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()) - (double)this.func_213311_cf() * 0.5, this.func_226278_cu_() + (double)(this.func_213302_cg() * 0.5f) + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg() * 0.5f), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()) - (double)this.func_213311_cf() * 0.5, d0, d1, d2);
                }
                if (this.eatingTicks % 6 == 0) {
                    this.func_184185_a(SoundEvents.field_187537_bA, this.func_70599_aP(), this.func_70647_i());
                }
                ++this.eatingTicks;
            }
            if (this.eatingTicks == 100) {
                this.func_184185_a(SoundEvents.field_187739_dZ, this.func_70599_aP(), this.func_70647_i());
                this.func_184592_cb().func_190918_g(1);
                this.func_70691_i(5.0f);
                this.eatingTicks = 0;
            }
        } else if (this.func_184614_ca().func_77973_b().func_219971_r() && this.func_110143_aJ() < this.func_110138_aP()) {
            if (this.eatingTicks < 100) {
                for (i = 0; i < 3; ++i) {
                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, this.func_184586_b(Hand.MAIN_HAND)), this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()) - (double)this.func_213311_cf() * 0.5, this.func_226278_cu_() + (double)(this.func_213302_cg() * 0.5f) + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg() * 0.5f), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()) - (double)this.func_213311_cf() * 0.5, d0, d1, d2);
                }
                this.func_184185_a(SoundEvents.field_187537_bA, this.func_70599_aP(), this.func_70647_i());
                if (this.eatingTicks % 6 == 0) {
                    this.func_184185_a(SoundEvents.field_187537_bA, this.func_70599_aP(), this.func_70647_i());
                }
                ++this.eatingTicks;
            }
            if (this.eatingTicks == 100) {
                this.func_184185_a(SoundEvents.field_187739_dZ, this.func_70599_aP(), this.func_70647_i());
                this.func_184614_ca().func_190918_g(1);
                this.func_70691_i(5.0f);
            }
        } else {
            this.eatingTicks = 0;
        }
        this.wasOnGround = this.field_70122_E;
        this.alterSquishAmount();
        LivingEntity livingentity = this.func_70638_az();
        if (livingentity != null && this.func_70068_e((Entity)livingentity) < 144.0) {
            this.field_70765_h.func_75642_a(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_(), this.field_70765_h.func_75638_b());
            this.wasOnGround = true;
        }
        if ((Integer)this.field_70180_af.func_187225_a(ATTACK_TICK) > 0) {
            if ((Integer)this.field_70180_af.func_187225_a(ATTACK_TICK) == 2 && this.func_70638_az() != null && (double)this.func_70032_d((Entity)this.func_70638_az()) < 2.3) {
                super.func_70652_k((Entity)this.func_70638_az());
            }
            this.field_70180_af.func_187227_b(ATTACK_TICK, (Object)((Integer)this.field_70180_af.func_187225_a(ATTACK_TICK) - 1));
            if (this.attackProgress < 3.0f) {
                this.attackProgress += 1.0f;
            }
        } else if (this.attackProgress > 0.0f) {
            this.attackProgress -= 1.0f;
        }
    }

    protected float func_205712_c(EquipmentSlotType slotIn) {
        return 0.0f;
    }

    private SoundEvent getSquishSound() {
        return AMSoundRegistry.MIMICUBE_JUMP;
    }

    private SoundEvent getJumpSound() {
        return AMSoundRegistry.MIMICUBE_JUMP;
    }

    protected void func_70664_aZ() {
        Vector3d vector3d = this.func_213322_ci();
        this.func_213293_j(vector3d.field_72450_a, this.func_175134_bD(), vector3d.field_72449_c);
        this.field_70160_al = true;
    }

    protected int getJumpDelay() {
        return this.field_70146_Z.nextInt(20) + 10;
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    public boolean shouldShoot() {
        return this.func_184614_ca().func_77973_b() instanceof ShootableItem || this.func_184614_ca().func_77973_b() instanceof TridentItem;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.MIMICUBE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.MIMICUBE_HURT;
    }

    private class MimicubeMoveHelper
    extends MovementController {
        private final EntityMimicube slime;
        private float yRot;
        private int jumpDelay;
        private boolean isAggressive;

        public MimicubeMoveHelper(EntityMimicube slimeIn) {
            super((MobEntity)slimeIn);
            this.slime = slimeIn;
            this.yRot = 180.0f * slimeIn.field_70177_z / (float)Math.PI;
        }

        public void setDirection(float yRotIn, boolean aggressive) {
            this.yRot = yRotIn;
            this.isAggressive = aggressive;
        }

        public void setSpeed(double speedIn) {
            this.field_75645_e = speedIn;
            this.field_188491_h = MovementController.Action.MOVE_TO;
        }

        public void func_75641_c() {
            if (this.field_75648_a.func_233570_aj_()) {
                this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_233637_b_(Attributes.field_233821_d_)));
                if (this.jumpDelay-- <= 0 && this.field_188491_h != MovementController.Action.WAIT) {
                    this.jumpDelay = this.slime.getJumpDelay();
                    if (this.field_75648_a.func_70638_az() != null) {
                        this.jumpDelay /= 3;
                    }
                    this.slime.func_70683_ar().func_75660_a();
                    this.slime.func_184185_a(this.slime.getJumpSound(), this.slime.func_70599_aP(), this.slime.func_70647_i());
                } else {
                    this.slime.field_70702_br = 0.0f;
                    this.slime.field_191988_bg = 0.0f;
                    this.field_75648_a.func_70659_e(0.0f);
                }
            }
            super.func_75641_c();
        }
    }
}

