/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIFleeAdult;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.entity.ai.KomodoDragonAIBreed;
import com.github.alexthe666.alexsmobs.entity.ai.TameableAIRide;
import com.github.alexthe666.alexsmobs.entity.ai.TameableAITempt;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityKomodoDragon
extends TameableEntity
implements ITargetsDroppedItems {
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151078_bh});
    public int slaughterCooldown = 0;
    public int timeUntilSpit = this.field_70146_Z.nextInt(12000) + 24000;
    private int riderAttackCooldown = 0;
    public static final Predicate<EntityKomodoDragon> HURT_OR_BABY = p_213616_0_ -> p_213616_0_.func_70631_g_() || p_213616_0_.func_110143_aJ() <= 0.7f * p_213616_0_.func_110138_aP();

    public static <T extends MobEntity> boolean canKomodoDragonSpawn(EntityType<? extends AnimalEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        boolean spawnBlock = BlockTags.func_199896_a().func_199910_a(AMTagRegistry.KOMODO_DRAGON_SPAWNS).func_230235_a_((Object)worldIn.func_180495_p(pos.func_177977_b()).func_177230_c());
        return spawnBlock && worldIn.func_226659_b_(pos, 0) > 8;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.komodoDragonSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 2.0, false));
        this.field_70714_bg.func_75776_a(2, (Goal)new TameableAIRide((CreatureEntity)this, 2.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new TameableAITempt((AnimalEntity)this, 1.1, TEMPTATION_ITEMS, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new AnimalAIFleeAdult((AnimalEntity)this, 1.25, 32.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new KomodoDragonAIBreed(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0, 50));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(4, new CreatureAITargetItems((CreatureEntity)this, false));
        this.field_70715_bh.func_75776_a(6, (Goal)new NearestAttackableTargetGoal((MobEntity)this, EntityKomodoDragon.class, 50, true, false, HURT_OR_BABY));
        this.field_70715_bh.func_75776_a(7, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 150, true, true, null));
        this.field_70715_bh.func_75776_a(8, new EntityAINearestTarget3D<LivingEntity>((MobEntity)this, LivingEntity.class, 180, false, true, AMEntityRegistry.buildPredicateFromTag(EntityTypeTags.func_219762_a().func_199910_a(AMTagRegistry.KOMODO_DRAGON_TARGETS))));
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        this.func_233687_w_(false);
        if (entity != null && this.func_70909_n() && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity)) {
            amount = (amount + 1.0f) / 3.0f;
        }
        return super.func_70097_a(source, amount);
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.KOMODO_DRAGON_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.KOMODO_DRAGON_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.KOMODO_DRAGON_HURT;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("SpitTime")) {
            this.timeUntilSpit = compound.func_74762_e("SpitTime");
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("SpitTime", this.timeUntilSpit);
    }

    public boolean func_70877_b(ItemStack stack) {
        Item item = stack.func_77973_b();
        return this.func_70909_n() && item == Items.field_151078_bh;
    }

    public void func_70071_h_() {
        PlayerEntity rider;
        super.func_70071_h_();
        if (this.slaughterCooldown > 0) {
            --this.slaughterCooldown;
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && !this.func_70631_g_() && --this.timeUntilSpit <= 0) {
            this.func_199703_a((IItemProvider)AMItemRegistry.KOMODO_SPIT);
            this.timeUntilSpit = this.field_70146_Z.nextInt(12000) + 24000;
        }
        if (this.riderAttackCooldown > 0) {
            --this.riderAttackCooldown;
        }
        if (this.func_184179_bs() != null && this.func_184179_bs() instanceof PlayerEntity && (rider = (PlayerEntity)this.func_184179_bs()).func_110144_aD() != null && this.func_70032_d((Entity)rider.func_110144_aD()) < this.func_213311_cf() + 3.0f && !this.func_184191_r((Entity)rider.func_110144_aD())) {
            UUID preyUUID = rider.func_110144_aD().func_110124_au();
            if (!this.func_110124_au().equals(preyUUID) && this.riderAttackCooldown == 0) {
                this.func_70652_k((Entity)rider.func_110144_aD());
                this.riderAttackCooldown = 20;
            }
        }
    }

    public boolean func_184191_r(Entity entityIn) {
        if (this.func_70909_n()) {
            LivingEntity livingentity = this.func_70902_q();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TameableEntity) {
                return ((TameableEntity)entityIn).func_152114_e(livingentity);
            }
            if (livingentity != null) {
                return livingentity.func_184191_r(entityIn);
            }
        }
        return super.func_184191_r(entityIn);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                int i = 5;
                if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL) {
                    i = 10;
                } else if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                    i = 20;
                }
                ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76436_u, i * 20, 0));
            }
            return true;
        }
        return false;
    }

    public boolean func_70687_e(EffectInstance potioneffectIn) {
        if (potioneffectIn.func_188419_a() == Effects.field_76436_u) {
            return false;
        }
        return super.func_70687_e(potioneffectIn);
    }

    @Nullable
    public Entity func_184179_bs() {
        for (Entity passenger : this.func_184188_bt()) {
            if (!(passenger instanceof PlayerEntity)) continue;
            PlayerEntity player = (PlayerEntity)passenger;
            return player;
        }
        return null;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float radius = 0.0f;
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            passenger.func_70107_b(this.func_226277_ct_() + extraX, this.func_226278_cu_() + this.func_70042_X() + passenger.func_70033_W(), this.func_226281_cx_() + extraZ);
        }
    }

    public double func_70042_X() {
        float f = Math.min(0.25f, this.field_70721_aZ);
        float f1 = this.field_184619_aG;
        return (double)this.func_213302_cg() - 0.2 + (double)(0.12f * MathHelper.func_76134_b((float)(f1 * 0.7f)) * 0.7f * f);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        ActionResultType type = super.func_230254_b_(player, hand);
        if (item == Items.field_151078_bh && !this.func_70909_n()) {
            int tameAmount;
            int size = itemstack.func_190916_E();
            if (size > (tameAmount = 58 + this.field_70146_Z.nextInt(16))) {
                this.func_193101_c(player);
            }
            itemstack.func_190918_g(size);
            return ActionResultType.SUCCESS;
        }
        if (type != ActionResultType.SUCCESS && this.func_70909_n() && this.func_152114_e((LivingEntity)player)) {
            if (this.func_70877_b(itemstack)) {
                this.func_204700_e(600);
                this.func_175505_a(player, itemstack);
                return ActionResultType.SUCCESS;
            }
            if (!(player.func_225608_bj_() || this.func_70877_b(itemstack) || this.func_70631_g_())) {
                player.func_184220_m((Entity)this);
                return ActionResultType.SUCCESS;
            }
        }
        return type;
    }

    protected EntityKomodoDragon(EntityType type, World worldIn) {
        super(type, worldIn);
    }

    protected float func_189749_co() {
        return 0.98f;
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        if (!this.func_70631_g_() || this.slaughterCooldown > 0) {
            super.func_70624_b(entitylivingbaseIn);
        }
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233826_i_, 0.0).func_233815_a_(Attributes.field_233823_f_, 4.0).func_233815_a_(Attributes.field_233821_d_, (double)0.23f);
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return (AgeableEntity)AMEntityRegistry.KOMODO_DRAGON.func_200721_a((World)p_241840_1_);
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151078_bh || stack.func_77973_b().func_219967_s() != null && stack.func_77973_b().func_219967_s().func_221467_c();
    }

    @Override
    public void onGetItem(ItemEntity e) {
        this.func_70691_i(10.0f);
    }
}

