/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.entity.ai.GrizzlyBearAIBeehive;
import com.github.alexthe666.alexsmobs.entity.ai.GrizzlyBearAIFleeBees;
import com.github.alexthe666.alexsmobs.entity.ai.TameableAIRide;
import com.github.alexthe666.alexsmobs.entity.ai.TameableAITempt;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;

public class EntityGrizzlyBear
extends TameableEntity
implements IAngerable,
IAnimatedEntity,
ITargetsDroppedItems {
    public static final Animation ANIMATION_MAUL = Animation.create((int)20);
    public static final Animation ANIMATION_SNIFF = Animation.create((int)12);
    public static final Animation ANIMATION_SWIPE_R = Animation.create((int)15);
    public static final Animation ANIMATION_SWIPE_L = Animation.create((int)20);
    private static final DataParameter<Boolean> STANDING = EntityDataManager.func_187226_a(EntityGrizzlyBear.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(EntityGrizzlyBear.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HONEYED = EntityDataManager.func_187226_a(EntityGrizzlyBear.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> EATING = EntityDataManager.func_187226_a(EntityGrizzlyBear.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SNOWY = EntityDataManager.func_187226_a(EntityGrizzlyBear.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final RangedInteger angerLogic = TickRangeConverter.func_233037_a_((int)20, (int)39);
    public float prevStandProgress;
    public float prevSitProgress;
    public float standProgress;
    public float sitProgress;
    public int maxStandTime = 75;
    public boolean forcedSit = false;
    private int animationTick;
    private Animation currentAnimation;
    private int standingTime = 0;
    private int sittingTime = 0;
    private int maxSitTime = 75;
    private int eatingTime = 0;
    private int angerTime;
    private UUID angerTarget;
    private int warningSoundTicks;
    private int honeyedTime;
    @Nullable
    private UUID salmonThrowerID = null;
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196087_aX, Items.field_226635_pU_, Items.field_226638_pX_});
    public int timeUntilNextFur = this.field_70146_Z.nextInt(24000) + 24000;
    protected static final EntitySize STANDING_SIZE = EntitySize.func_220314_b((float)1.8f, (float)2.85f);
    private boolean recalcSize = false;
    private int snowTimer = 0;
    private boolean permSnow = false;

    protected EntityGrizzlyBear(EntityType type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 50.0).func_233815_a_(Attributes.field_233823_f_, 8.0).func_233815_a_(Attributes.field_233820_c_, (double)0.6f).func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.isStanding() ? STANDING_SIZE.func_220313_a(this.func_213355_cm()) : super.func_213305_a(poseIn);
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.grizzlyBearSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        this.func_233687_w_(false);
        if (entity != null && this.func_70909_n() && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity)) {
            amount = (amount + 1.0f) / 3.0f;
        }
        return super.func_70097_a(source, amount);
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.GRIZZLY_BEAR_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.GRIZZLY_BEAR_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.GRIZZLY_BEAR_DIE;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float sitAdd = -0.065f * this.sitProgress;
            float standAdd = -0.07f * this.standProgress;
            float radius = standAdd + sitAdd;
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            passenger.func_70107_b(this.func_226277_ct_() + extraX, this.func_226278_cu_() + this.func_70042_X() + passenger.func_70033_W(), this.func_226281_cx_() + extraZ);
        }
    }

    public double func_70042_X() {
        float f = Math.min(0.25f, this.field_70721_aZ);
        float f1 = this.field_184619_aG;
        float sitAdd = 0.01f * this.sitProgress;
        float standAdd = 0.07f * this.standProgress;
        return (double)this.func_213302_cg() - 0.2 + (double)(0.12f * MathHelper.func_76134_b((float)(f1 * 0.7f)) * 0.7f * f) + (double)sitAdd + (double)standAdd;
    }

    protected float func_189749_co() {
        return this.func_184207_aI() ? 0.9f : 0.98f;
    }

    public void func_230258_H__() {
        this.func_230260_a__(angerLogic.func_233018_a_(this.field_70146_Z));
    }

    public int func_230256_F__() {
        return this.angerTime;
    }

    public void func_230260_a__(int time) {
        this.angerTime = time;
    }

    public UUID func_230257_G__() {
        return this.angerTarget;
    }

    public void func_230259_a_(@Nullable UUID target) {
        this.angerTarget = target;
    }

    public boolean func_180431_b(DamageSource source) {
        return source.field_76373_n != null && source.field_76373_n.equals("sting") || source == DamageSource.field_76368_d || super.func_180431_b(source);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new TameableAIRide((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new PanicGoal());
        this.field_70714_bg.func_75776_a(4, (Goal)new TameableAITempt((AnimalEntity)this, 1.1, TEMPTATION_ITEMS, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(4, (Goal)new GrizzlyBearAIBeehive(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new GrizzlyBearAIFleeBees(this, 14.0f, 1.0, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.75));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal());
        this.field_70715_bh.func_75776_a(4, new CreatureAITargetItems((CreatureEntity)this, false));
        this.field_70715_bh.func_75776_a(5, (Goal)new AttackPlayerGoal());
        this.field_70715_bh.func_75776_a(6, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, arg_0 -> ((EntityGrizzlyBear)this).func_233680_b_(arg_0)));
        this.field_70715_bh.func_75776_a(6, (Goal)new NearestAttackableTargetGoal((MobEntity)this, FoxEntity.class, 10, true, true, null));
        this.field_70715_bh.func_75776_a(6, (Goal)new NearestAttackableTargetGoal((MobEntity)this, WolfEntity.class, 10, true, true, null));
        this.field_70715_bh.func_75776_a(7, (Goal)new ResetAngerGoal((MobEntity)this, false));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Honeyed", this.isHoneyed());
        compound.func_74757_a("Snowy", this.isSnowy());
        compound.func_74757_a("Standing", this.isStanding());
        compound.func_74757_a("BearSitting", this.isSitting());
        compound.func_74757_a("ForcedToSit", this.forcedSit);
        compound.func_74757_a("SnowPerm", this.permSnow);
        compound.func_74768_a("FurTime", this.timeUntilNextFur);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setHoneyed(compound.func_74767_n("Honeyed"));
        this.setSnowy(compound.func_74767_n("Snowy"));
        this.setStanding(compound.func_74767_n("Standing"));
        this.func_233687_w_(compound.func_74767_n("BearSitting"));
        this.forcedSit = compound.func_74767_n("ForcedToSit");
        this.permSnow = compound.func_74767_n("SnowPerm");
        this.timeUntilNextFur = compound.func_74762_e("FurTime");
    }

    public boolean func_70877_b(ItemStack stack) {
        Item item = stack.func_77973_b();
        return this.func_70909_n() && item == Items.field_196087_aX;
    }

    @Nullable
    public Entity func_184179_bs() {
        for (Entity passenger : this.func_184188_bt()) {
            if (!(passenger instanceof PlayerEntity)) continue;
            PlayerEntity player = (PlayerEntity)passenger;
            return player;
        }
        return null;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        ActionResultType type = super.func_230254_b_(player, hand);
        if (item == Items.field_221768_ct && !this.isSnowy() && !this.field_70170_p.field_72995_K) {
            this.func_175505_a(player, itemstack);
            this.permSnow = true;
            this.setSnowy(true);
            this.func_184185_a(SoundEvents.field_187813_fI, this.func_70599_aP(), this.func_70647_i());
            return ActionResultType.SUCCESS;
        }
        if (item instanceof ShovelItem && this.isSnowy() && !this.field_70170_p.field_72995_K) {
            this.permSnow = false;
            if (!player.func_184812_l_()) {
                itemstack.func_96631_a(1, this.func_70681_au(), player instanceof ServerPlayerEntity ? (ServerPlayerEntity)player : null);
            }
            this.setSnowy(false);
            this.func_184185_a(SoundEvents.field_187807_fF, this.func_70599_aP(), this.func_70647_i());
            return ActionResultType.SUCCESS;
        }
        if (type != ActionResultType.SUCCESS && this.func_70909_n() && this.func_152114_e((LivingEntity)player) && !this.func_70877_b(itemstack)) {
            if (!player.func_225608_bj_() && !this.func_70631_g_()) {
                player.func_184220_m((Entity)this);
                return ActionResultType.SUCCESS;
            }
            if (this.isSitting()) {
                this.forcedSit = false;
                this.func_233687_w_(false);
                return ActionResultType.SUCCESS;
            }
            this.forcedSit = true;
            this.func_233687_w_(true);
            return ActionResultType.SUCCESS;
        }
        return type;
    }

    public void func_213352_e(Vector3d vec3d) {
        if (!this.shouldMove()) {
            if (this.func_70661_as().func_75505_d() != null) {
                this.func_70661_as().func_75499_g();
            }
            vec3d = Vector3d.field_186680_a;
        }
        super.func_213352_e(vec3d);
    }

    public void func_70071_h_() {
        PlayerEntity rider;
        super.func_70071_h_();
        if (this.func_70631_g_() && this.func_70047_e() > this.func_213302_cg()) {
            this.func_213323_x_();
        }
        this.prevStandProgress = this.standProgress;
        this.prevSitProgress = this.sitProgress;
        if (this.isSitting() && this.sitProgress < 10.0f) {
            this.sitProgress += 1.0f;
        }
        if (!this.isSitting() && this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        if (this.isStanding() && this.standProgress < 10.0f) {
            this.standProgress += 1.0f;
        }
        if (!this.isStanding() && this.standProgress > 0.0f) {
            this.standProgress -= 1.0f;
        }
        if (!this.func_184586_b(Hand.MAIN_HAND).func_190926_b() && this.canTargetItem(this.func_184586_b(Hand.MAIN_HAND))) {
            this.setEating(true);
            this.func_233687_w_(true);
            this.setStanding(false);
        }
        if (this.recalcSize) {
            this.recalcSize = false;
            this.func_213323_x_();
        }
        if (this.isEating() && !this.canTargetItem(this.func_184586_b(Hand.MAIN_HAND))) {
            this.setEating(false);
            this.eatingTime = 0;
            if (!this.forcedSit) {
                this.func_233687_w_(true);
            }
        }
        if (this.isEating()) {
            ++this.eatingTime;
            for (int i = 0; i < 3; ++i) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, this.func_184586_b(Hand.MAIN_HAND)), this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()) - (double)this.func_213311_cf() * 0.5, this.func_226278_cu_() + (double)(this.func_213302_cg() * 0.5f) + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg() * 0.5f), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()) - (double)this.func_213311_cf() * 0.5, d0, d1, d2);
            }
            if (this.eatingTime % 5 == 0) {
                this.func_184185_a(SoundEvents.field_187537_bA, this.func_70599_aP(), this.func_70647_i());
            }
            if (this.eatingTime > 100) {
                ItemStack stack = this.func_184586_b(Hand.MAIN_HAND);
                if (!stack.func_190926_b()) {
                    if (ItemTags.func_199903_a().func_199910_a(AMTagRegistry.GRIZZLY_HONEY).func_230235_a_((Object)stack.func_77973_b())) {
                        this.setHoneyed(true);
                        this.func_70691_i(10.0f);
                        this.honeyedTime = 700;
                    } else {
                        this.func_70691_i(4.0f);
                    }
                    if (stack.func_77973_b() == Items.field_196087_aX && !this.func_70909_n() && this.salmonThrowerID != null) {
                        if (this.func_70681_au().nextFloat() < 0.3f) {
                            this.func_70903_f(true);
                            this.func_184754_b(this.salmonThrowerID);
                            PlayerEntity player = this.field_70170_p.func_217371_b(this.salmonThrowerID);
                            if (player instanceof ServerPlayerEntity) {
                                CriteriaTriggers.field_193136_w.func_193178_a((ServerPlayerEntity)player, (AnimalEntity)this);
                            }
                            this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                        } else {
                            this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                        }
                    }
                    if (stack.hasContainerItem()) {
                        this.func_199701_a_(stack.getContainerItem());
                    }
                    stack.func_190918_g(1);
                }
                this.eatingTime = 0;
            }
        }
        if (this.isStanding() && ++this.standingTime > this.maxStandTime) {
            this.setStanding(false);
            this.standingTime = 0;
            this.maxStandTime = 75 + this.field_70146_Z.nextInt(50);
        }
        if (this.isSitting() && !this.forcedSit && ++this.sittingTime > this.maxSitTime) {
            this.func_233687_w_(false);
            this.sittingTime = 0;
            this.maxSitTime = 75 + this.field_70146_Z.nextInt(50);
        }
        if (!(this.field_70170_p.field_72995_K || this.getAnimation() != NO_ANIMATION || this.isStanding() || this.isSitting() || this.field_70146_Z.nextInt(1500) != 0)) {
            this.maxSitTime = 300 + this.field_70146_Z.nextInt(250);
            this.func_233687_w_(true);
        }
        if (!this.forcedSit && this.isSitting() && (this.func_70638_az() != null || this.isStanding()) && !this.isEating()) {
            this.func_233687_w_(false);
        }
        if (this.getAnimation() == NO_ANIMATION && this.field_70146_Z.nextInt(this.isStanding() ? 350 : 2500) == 0) {
            this.setAnimation(ANIMATION_SNIFF);
        }
        if (this.isSitting()) {
            this.func_70661_as().func_75499_g();
        }
        LivingEntity attackTarget = this.func_70638_az();
        if (this.func_184179_bs() != null && this.func_184179_bs() instanceof PlayerEntity && (rider = (PlayerEntity)this.func_184179_bs()).func_110144_aD() != null && this.func_70032_d((Entity)rider.func_110144_aD()) < this.func_213311_cf() + 3.0f && !this.func_184191_r((Entity)rider.func_110144_aD())) {
            UUID preyUUID = rider.func_110144_aD().func_110124_au();
            if (!this.func_110124_au().equals(preyUUID)) {
                attackTarget = rider.func_110144_aD();
                if (this.getAnimation() == NO_ANIMATION || this.getAnimation() == ANIMATION_SNIFF) {
                    this.setAnimation(this.field_70146_Z.nextBoolean() ? ANIMATION_MAUL : (this.field_70146_Z.nextBoolean() ? ANIMATION_SWIPE_L : ANIMATION_SWIPE_R));
                }
            }
        }
        if (attackTarget != null) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70031_b(true);
            }
            if (this.func_70032_d((Entity)attackTarget) < attackTarget.func_213311_cf() + this.func_213311_cf() + 2.0f) {
                if (this.getAnimation() == ANIMATION_MAUL && this.getAnimationTick() % 5 == 0 && this.getAnimationTick() > 3) {
                    this.func_70652_k((Entity)attackTarget);
                }
                if (this.getAnimation() == ANIMATION_SWIPE_L && this.getAnimationTick() == 7) {
                    this.func_70652_k((Entity)attackTarget);
                    float rot = this.field_70177_z + 90.0f;
                    attackTarget.func_233627_a_(0.5f, (double)MathHelper.func_76126_a((float)(rot * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(rot * ((float)Math.PI / 180)))));
                }
                if (this.getAnimation() == ANIMATION_SWIPE_R && this.getAnimationTick() == 7) {
                    this.func_70652_k((Entity)attackTarget);
                    float rot = this.field_70177_z - 90.0f;
                    attackTarget.func_233627_a_(0.5f, (double)MathHelper.func_76126_a((float)(rot * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(rot * ((float)Math.PI / 180)))));
                }
            }
        } else if (!this.field_70170_p.field_72995_K) {
            this.func_70031_b(false);
        }
        if (!this.field_70170_p.field_72995_K && this.isHoneyed() && --this.honeyedTime <= 0) {
            this.setHoneyed(false);
            this.honeyedTime = 0;
        }
        if (this.forcedSit && !this.func_184207_aI() && this.func_70909_n()) {
            this.func_233687_w_(true);
        }
        if (this.func_184207_aI() && this.isSitting()) {
            this.func_233687_w_(false);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.func_70909_n() && !this.func_70631_g_() && --this.timeUntilNextFur <= 0) {
            this.func_199703_a((IItemProvider)AMItemRegistry.BEAR_FUR);
            this.timeUntilNextFur = this.field_70146_Z.nextInt(24000) + 24000;
        }
        if (this.snowTimer > 0) {
            --this.snowTimer;
        }
        if (this.snowTimer == 0 && !this.field_70170_p.field_72995_K) {
            this.snowTimer = 200 + this.field_70146_Z.nextInt(400);
            if (this.isSnowy()) {
                if (!(this.permSnow || this.field_70170_p.field_72995_K && this.func_223314_ad() <= 0 && !this.func_203005_aq() && EntityGrizzlyBear.isSnowingAt(this.field_70170_p, this.func_233580_cy_().func_177984_a()))) {
                    this.setSnowy(false);
                }
            } else if (!this.field_70170_p.field_72995_K && EntityGrizzlyBear.isSnowingAt(this.field_70170_p, this.func_233580_cy_())) {
                this.setSnowy(true);
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public static boolean isSnowingAt(World world, BlockPos position) {
        if (!world.func_72896_J()) {
            return false;
        }
        if (!world.func_226660_f_(position)) {
            return false;
        }
        if (world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, position).func_177956_o() > position.func_177956_o()) {
            return false;
        }
        return world.func_226691_t_(position).func_201851_b() == Biome.RainType.SNOW;
    }

    public boolean func_184191_r(Entity entityIn) {
        if (this.func_70909_n()) {
            LivingEntity livingentity = this.func_70902_q();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TameableEntity) {
                return ((TameableEntity)entityIn).func_152114_e(livingentity);
            }
            if (livingentity != null) {
                return livingentity.func_184191_r(entityIn);
            }
        }
        return super.func_184191_r(entityIn);
    }

    public void func_233687_w_(boolean sit) {
        this.field_70180_af.func_187227_b(SITTING, (Object)sit);
    }

    public boolean isSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STANDING, (Object)false);
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
        this.field_70180_af.func_187214_a(HONEYED, (Object)false);
        this.field_70180_af.func_187214_a(SNOWY, (Object)false);
        this.field_70180_af.func_187214_a(EATING, (Object)false);
    }

    public boolean isEating() {
        return (Boolean)this.field_70180_af.func_187225_a(EATING);
    }

    public void setEating(boolean eating) {
        this.field_70180_af.func_187227_b(EATING, (Object)eating);
    }

    public boolean isHoneyed() {
        return (Boolean)this.field_70180_af.func_187225_a(HONEYED);
    }

    public void setHoneyed(boolean honeyed) {
        this.field_70180_af.func_187227_b(HONEYED, (Object)honeyed);
    }

    public boolean isSnowy() {
        return (Boolean)this.field_70180_af.func_187225_a(SNOWY);
    }

    public void setSnowy(boolean honeyed) {
        this.field_70180_af.func_187227_b(SNOWY, (Object)honeyed);
    }

    public boolean isStanding() {
        return (Boolean)this.field_70180_af.func_187225_a(STANDING);
    }

    public void setStanding(boolean standing) {
        this.field_70180_af.func_187227_b(STANDING, (Object)standing);
        this.recalcSize = true;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity p_241840_2_) {
        return (AgeableEntity)AMEntityRegistry.GRIZZLY_BEAR.func_200721_a((World)world);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
        if (animation == ANIMATION_MAUL) {
            this.maxStandTime = 21;
            this.setStanding(true);
        }
        if (animation == ANIMATION_SWIPE_R || animation == ANIMATION_SWIPE_L) {
            this.maxStandTime = 2 + this.field_70146_Z.nextInt(5);
            this.setStanding(true);
        }
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_MAUL, ANIMATION_SNIFF, ANIMATION_SWIPE_R, ANIMATION_SWIPE_L};
    }

    public boolean shouldMove() {
        return !this.isSitting();
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (spawnDataIn == null) {
            spawnDataIn = new AgeableEntity.AgeableData(1.0f);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    private void playWarningSound() {
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return ItemTags.func_199903_a().func_199910_a(AMTagRegistry.GRIZZLY_FOODSTUFFS).func_230235_a_((Object)stack.func_77973_b());
    }

    @Override
    public void onGetItem(ItemEntity targetEntity) {
        ItemStack duplicate = targetEntity.func_92059_d().func_77946_l();
        duplicate.func_190920_e(1);
        if (!this.func_184586_b(Hand.MAIN_HAND).func_190926_b() && !this.field_70170_p.field_72995_K) {
            this.func_70099_a(this.func_184586_b(Hand.MAIN_HAND), 0.0f);
        }
        this.func_184611_a(Hand.MAIN_HAND, duplicate);
        this.salmonThrowerID = targetEntity.func_92059_d().func_77973_b() == Items.field_196087_aX && this.isHoneyed() ? targetEntity.func_200214_m() : null;
    }

    public boolean isEatingHeldItem() {
        return false;
    }

    class PanicGoal
    extends net.minecraft.entity.ai.goal.PanicGoal {
        public PanicGoal() {
            super((CreatureEntity)EntityGrizzlyBear.this, 2.0);
        }

        public boolean func_75250_a() {
            return (EntityGrizzlyBear.this.func_70631_g_() || EntityGrizzlyBear.this.func_70027_ad()) && super.func_75250_a();
        }
    }

    class AttackPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public AttackPlayerGoal() {
            super((MobEntity)EntityGrizzlyBear.this, PlayerEntity.class, 3, true, true, null);
        }

        public boolean func_75250_a() {
            if (EntityGrizzlyBear.this.func_70631_g_() || EntityGrizzlyBear.this.isHoneyed()) {
                return false;
            }
            return super.func_75250_a();
        }

        protected double func_111175_f() {
            return 3.0;
        }
    }

    class MeleeAttackGoal
    extends net.minecraft.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((CreatureEntity)EntityGrizzlyBear.this, 1.25, true);
        }

        protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.func_179512_a(enemy);
            if (distToEnemySqr <= d0) {
                if (EntityGrizzlyBear.this.getAnimation() == IAnimatedEntity.NO_ANIMATION || EntityGrizzlyBear.this.getAnimation() == ANIMATION_SNIFF) {
                    EntityGrizzlyBear.this.setAnimation(EntityGrizzlyBear.this.field_70146_Z.nextBoolean() ? ANIMATION_MAUL : (EntityGrizzlyBear.this.field_70146_Z.nextBoolean() ? ANIMATION_SWIPE_L : ANIMATION_SWIPE_R));
                }
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.func_234040_h_()) {
                    this.func_234039_g_();
                }
                if (this.func_234041_j_() <= 10) {
                    EntityGrizzlyBear.this.playWarningSound();
                }
            } else {
                this.func_234039_g_();
            }
        }

        public void func_75251_c() {
            EntityGrizzlyBear.this.setStanding(false);
            super.func_75251_c();
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return 3.0f + attackTarget.func_213311_cf();
        }
    }

    class HurtByTargetGoal
    extends net.minecraft.entity.ai.goal.HurtByTargetGoal {
        public HurtByTargetGoal() {
            super((CreatureEntity)EntityGrizzlyBear.this, new Class[0]);
        }

        public void func_75249_e() {
            super.func_75249_e();
            if (EntityGrizzlyBear.this.func_70631_g_()) {
                this.func_190105_f();
                this.func_75251_c();
            }
        }

        protected void func_220793_a(MobEntity mobIn, LivingEntity targetIn) {
            if (mobIn instanceof EntityGrizzlyBear && !mobIn.func_70631_g_()) {
                super.func_220793_a(mobIn, targetIn);
            }
        }
    }
}

