/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.client.particle.AMParticleRegistry;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.effect.AMEffectRegistry;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityMimicOctopus;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAISwimBottom;
import com.github.alexthe666.alexsmobs.entity.ai.AquaticMoveController;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FindWaterGoal;
import net.minecraft.entity.ai.goal.FollowBoatGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.passive.fish.AbstractGroupFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityFrilledShark
extends WaterMobEntity
implements IAnimatedEntity {
    public static final Animation ANIMATION_ATTACK = Animation.create((int)17);
    private static final DataParameter<Boolean> DEPRESSURIZED = EntityDataManager.func_187226_a(EntityFrilledShark.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FROM_BUCKET = EntityDataManager.func_187226_a(EntityFrilledShark.class, (IDataSerializer)DataSerializers.field_187198_h);
    public float prevOnLandProgress;
    public float onLandProgress;
    private int animationTick;
    private Animation currentAnimation;

    protected EntityFrilledShark(EntityType type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new AquaticMoveController((CreatureEntity)this, 1.0f);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233826_i_, 0.0).func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233821_d_, (double)0.2f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DEPRESSURIZED, (Object)false);
        this.field_70180_af.func_187214_a(FROM_BUCKET, (Object)false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new FindWaterGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AIMelee());
        this.field_70714_bg.func_75776_a(3, (Goal)new AnimalAISwimBottom((CreatureEntity)this, 0.8f, 7));
        this.field_70714_bg.func_75776_a(4, (Goal)new RandomSwimmingGoal((CreatureEntity)this, (double)0.8f, 3));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowBoatGoal((CreatureEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new EntityAINearestTarget3D<SquidEntity>((MobEntity)this, SquidEntity.class, 40, false, true, null));
        this.field_70715_bh.func_75776_a(2, new EntityAINearestTarget3D<EntityMimicOctopus>((MobEntity)this, EntityMimicOctopus.class, 70, false, true, null));
        this.field_70715_bh.func_75776_a(3, new EntityAINearestTarget3D<AbstractGroupFishEntity>((MobEntity)this, AbstractGroupFishEntity.class, 100, false, true, null));
        this.field_70715_bh.func_75776_a(4, new EntityAINearestTarget3D<DrownedEntity>((MobEntity)this, DrownedEntity.class, 4, false, true, null));
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.frilledSharkSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    public static boolean canFrilledSharkSpawn(EntityType<EntityFrilledShark> entityType, IServerWorld iServerWorld, SpawnReason reason, BlockPos pos, Random random) {
        return reason == SpawnReason.SPAWNER || iServerWorld.func_180495_p(pos).func_185904_a() == Material.field_151586_h && iServerWorld.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151586_h;
    }

    private boolean isFromBucket() {
        return (Boolean)this.field_70180_af.func_187225_a(FROM_BUCKET);
    }

    public void setFromBucket(boolean p_203706_1_) {
        this.field_70180_af.func_187227_b(FROM_BUCKET, (Object)p_203706_1_);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("FromBucket", this.isFromBucket());
        compound.func_74757_a("Depressurized", this.isDepressurized());
    }

    public boolean func_213392_I() {
        return super.func_213392_I() || this.isFromBucket();
    }

    public boolean func_213397_c(double p_213397_1_) {
        return !this.isFromBucket() && !this.func_145818_k_();
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setFromBucket(compound.func_74767_n("FromBucket"));
        this.setDepressurized(compound.func_74767_n("Depressurized"));
    }

    private void doInitialPosing(IWorld world) {
        BlockPos down = this.func_233580_cy_();
        while (!world.func_204610_c(down).func_206888_e() && down.func_177956_o() > 1) {
            down = down.func_177977_b();
        }
        this.func_70107_b((float)down.func_177958_n() + 0.5f, down.func_177956_o() + 1, (float)down.func_177952_p() + 0.5f);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (reason == SpawnReason.NATURAL) {
            this.doInitialPosing((IWorld)worldIn);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        return worldIn.func_226668_i_((Entity)this);
    }

    public boolean isDepressurized() {
        return (Boolean)this.field_70180_af.func_187225_a(DEPRESSURIZED);
    }

    public void setDepressurized(boolean depressurized) {
        this.field_70180_af.func_187227_b(DEPRESSURIZED, (Object)depressurized);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new SwimmerPathNavigator((MobEntity)this, worldIn);
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_203816_ay;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_203813_aA;
    }

    protected ItemStack getFishBucket() {
        ItemStack stack = new ItemStack((IItemProvider)AMItemRegistry.FRILLED_SHARK_BUCKET);
        CompoundNBT platTag = new CompoundNBT();
        this.func_213281_b(platTag);
        stack.func_196082_o().func_218657_a("FrilledSharkData", (INBT)platTag);
        if (this.func_145818_k_()) {
            stack.func_200302_a(this.func_200201_e());
        }
        return stack;
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        if (itemstack.func_77973_b() == Items.field_151131_as && this.func_70089_S()) {
            this.func_184185_a(SoundEvents.field_203814_aa, 1.0f, 1.0f);
            itemstack.func_190918_g(1);
            ItemStack itemstack1 = this.getFishBucket();
            if (!this.field_70170_p.field_72995_K) {
                CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)p_230254_1_, itemstack1);
            }
            if (itemstack.func_190926_b()) {
                p_230254_1_.func_184611_a(p_230254_2_, itemstack1);
            } else if (!p_230254_1_.field_71071_by.func_70441_a(itemstack1)) {
                p_230254_1_.func_71019_a(itemstack1, false);
            }
            this.func_70106_y();
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(this.func_70689_ay(), travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_216372_d(0.9, 0.6, 0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(travelVector);
        }
    }

    public void func_233629_a_(LivingEntity p_233629_1_, boolean p_233629_2_) {
        double d2;
        double d1;
        p_233629_1_.field_184618_aE = p_233629_1_.field_70721_aZ;
        double d0 = p_233629_1_.func_226277_ct_() - p_233629_1_.field_70169_q;
        float f = MathHelper.func_76133_a((double)(d0 * d0 + (d1 = p_233629_1_.func_226278_cu_() - p_233629_1_.field_70167_r) * d1 + (d2 = p_233629_1_.func_226281_cx_() - p_233629_1_.field_70166_s) * d2)) * 8.0f;
        if (f > 1.0f) {
            f = 1.0f;
        }
        p_233629_1_.field_70721_aZ += (f - p_233629_1_.field_70721_aZ) * 0.4f;
        p_233629_1_.field_184619_aG += p_233629_1_.field_70721_aZ;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevOnLandProgress = this.onLandProgress;
        if (!this.func_70090_H() && this.onLandProgress < 5.0f) {
            this.onLandProgress += 1.0f;
        }
        if (this.func_70090_H() && this.onLandProgress > 0.0f) {
            this.onLandProgress -= 1.0f;
        }
        if (this.func_70090_H()) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.8, 1.0));
        }
        boolean clear = this.hasClearance();
        if (this.isDepressurized() && clear) {
            this.setDepressurized(false);
        }
        if (!this.isDepressurized() && !clear) {
            this.setDepressurized(true);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.getAnimation() == ANIMATION_ATTACK && this.getAnimationTick() == 12) {
            float f1 = this.field_70177_z * ((float)Math.PI / 180);
            this.func_213317_d(this.func_213322_ci().func_72441_c((double)(-MathHelper.func_76126_a((float)f1) * 0.06f), 0.0, (double)(MathHelper.func_76134_b((float)f1) * 0.06f)));
            if (this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111125_b())) {
                this.func_70638_az().func_195064_c(new EffectInstance(AMEffectRegistry.EXSANGUINATION, 60, 2));
                if (this.field_70146_Z.nextInt(15) == 0 && this.func_70638_az() instanceof SquidEntity) {
                    this.func_199703_a((IItemProvider)AMItemRegistry.SERRATED_SHARK_TOOTH);
                }
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof DrownedEntity) {
            amount *= 0.5f;
        }
        return super.func_70097_a(source, amount);
    }

    private boolean hasClearance() {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int l1 = 0; l1 < 10; ++l1) {
            BlockState blockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable.func_189532_c(this.func_226277_ct_(), this.func_226278_cu_() + (double)l1, this.func_226281_cx_()));
            if (blockstate.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a)) continue;
            return false;
        }
        return true;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public boolean isKaiju() {
        String s = TextFormatting.func_110646_a((String)this.func_200200_C_().getString());
        return s != null && (s.toLowerCase().contains("kamata kun") || s.toLowerCase().contains("kamata-kun"));
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_ATTACK};
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_ATTACK);
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 68) {
            double d2 = this.field_70146_Z.nextGaussian() * 0.1;
            double d0 = this.field_70146_Z.nextGaussian() * 0.1;
            double d1 = this.field_70146_Z.nextGaussian() * 0.1;
            float radius = this.func_213311_cf() * 0.8f;
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            double x = this.func_226277_ct_() + extraX + d0;
            double y = this.func_226278_cu_() + (double)(this.func_213302_cg() * 0.15f) + d1;
            double z = this.func_226281_cx_() + extraZ + d2;
            this.field_70170_p.func_195594_a((IParticleData)AMParticleRegistry.TEETH_GLINT, x, y, z, this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c);
        } else {
            super.func_70103_a(id);
        }
    }

    private class AIMelee
    extends Goal {
        public AIMelee() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return EntityFrilledShark.this.func_70638_az() != null && EntityFrilledShark.this.func_70638_az().func_70089_S();
        }

        public void func_75246_d() {
            LivingEntity target = EntityFrilledShark.this.func_70638_az();
            double speed = 1.0;
            boolean move = true;
            if (EntityFrilledShark.this.func_70032_d((Entity)target) < 10.0f) {
                if ((double)EntityFrilledShark.this.func_70032_d((Entity)target) < 1.9) {
                    EntityFrilledShark.this.func_70652_k((Entity)target);
                    speed = 0.8f;
                } else {
                    speed = 0.6f;
                    EntityFrilledShark.this.func_70625_a((Entity)target, 70.0f, 70.0f);
                    if (target instanceof SquidEntity) {
                        Vector3d mouth = EntityFrilledShark.this.func_213303_ch();
                        float squidSpeed = 0.07f;
                        ((SquidEntity)target).func_175568_b((float)(mouth.field_72450_a - target.func_226277_ct_()) * squidSpeed, (float)(mouth.field_72448_b - target.func_226280_cw_()) * squidSpeed, (float)(mouth.field_72449_c - target.func_226281_cx_()) * squidSpeed);
                        EntityFrilledShark.this.field_70170_p.func_72960_a((Entity)EntityFrilledShark.this, (byte)68);
                    }
                }
            }
            if (target instanceof DrownedEntity || target instanceof PlayerEntity) {
                speed = 1.0;
            }
            EntityFrilledShark.this.func_70661_as().func_75497_a((Entity)target, speed);
        }
    }
}

