/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.renderers.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class RenderItemBase
implements IItemRenderer {
    private static HashMap<Item, RenderItemBase> renderers = new HashMap();

    protected RenderItemBase(Item item) {
        if (!renderers.containsKey(item)) {
            MinecraftForgeClient.registerItemRenderer((Item)item, (IItemRenderer)this);
            renderers.put(item, this);
        }
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glPushMatrix();
        switch (type) {
            case ENTITY: {
                this.renderItemEntity(item, tessellator, (RenderBlocks)data[0], (EntityItem)data[1]);
                break;
            }
            case EQUIPPED: {
                this.renderItemEquipped(item, tessellator, (RenderBlocks)data[0], (EntityPlayer)data[1]);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.renderItemEquippedFirstPerson(item, tessellator, (RenderBlocks)data[0], (EntityPlayer)data[1]);
                break;
            }
            case INVENTORY: {
                this.renderItemInventory(item, tessellator, (RenderBlocks)data[0]);
                break;
            }
            case FIRST_PERSON_MAP: {
                this.renderItemMap(item, tessellator);
            }
        }
        GL11.glPopMatrix();
    }

    protected abstract void renderItemEntity(ItemStack var1, Tessellator var2, RenderBlocks var3, EntityItem var4);

    protected abstract void renderItemEquipped(ItemStack var1, Tessellator var2, RenderBlocks var3, EntityPlayer var4);

    protected abstract void renderItemEquippedFirstPerson(ItemStack var1, Tessellator var2, RenderBlocks var3, EntityPlayer var4);

    protected abstract void renderItemInventory(ItemStack var1, Tessellator var2, RenderBlocks var3);

    protected abstract void renderItemMap(ItemStack var1, Tessellator var2);

    protected void drawAxisSystem(boolean startDrawing) {
        Tessellator tessellator = Tessellator.field_78398_a;
        if (startDrawing) {
            tessellator.func_78382_b();
        }
        tessellator.func_78374_a((double)-0.005f, 2.0, 0.0, 1.0, 0.0);
        tessellator.func_78374_a((double)0.005f, 2.0, 0.0, 0.0, 0.0);
        tessellator.func_78374_a((double)0.005f, -1.0, 0.0, 0.0, 1.0);
        tessellator.func_78374_a((double)-0.005f, -1.0, 0.0, 1.0, 1.0);
        tessellator.func_78374_a(2.0, (double)-0.005f, 0.0, 1.0, 0.0);
        tessellator.func_78374_a(2.0, (double)0.005f, 0.0, 0.0, 0.0);
        tessellator.func_78374_a(-1.0, (double)0.005f, 0.0, 0.0, 1.0);
        tessellator.func_78374_a(-1.0, (double)-0.005f, 0.0, 1.0, 1.0);
        tessellator.func_78374_a(0.0, (double)-0.005f, 2.0, 1.0, 0.0);
        tessellator.func_78374_a(0.0, (double)0.005f, 2.0, 0.0, 0.0);
        tessellator.func_78374_a(0.0, (double)0.005f, -1.0, 0.0, 1.0);
        tessellator.func_78374_a(0.0, (double)-0.005f, -1.0, 1.0, 1.0);
        if (startDrawing) {
            tessellator.func_78381_a();
        }
    }
}

