/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.render.items.journal;

import com.google.common.collect.Maps;
import com.infinityraider.agricraft.handler.JournalViewPointHandler;
import com.infinityraider.agricraft.render.items.journal.PageRenderer;
import com.infinityraider.infinitylib.render.IRenderUtilities;
import com.infinityraider.infinitylib.render.item.InfItemRenderer;
import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class JournalRenderer
implements InfItemRenderer,
IRenderUtilities {
    private static final JournalRenderer INSTANCE = new JournalRenderer();
    private static final Vector3f COLOR_COVER;
    private static final Vector3f COLOR_PAGE;
    private static final Quaternion ROTATION_RIGHT;
    private static final Quaternion ROTATION_LEFT;
    private static final float HEIGHT = 7.0f;
    private static final float WIDTH = 5.0f;
    private static final float T_COVER = 0.5f;
    private static final float T_PAPER = 1.0f;
    private static final float T_TOTAL = 2.0f;
    private static final float OPEN_ANGLE = 75.0f;
    protected static final float SHADE_LEFT = 0.7f;
    protected static final float SHADE_RIGHT = 1.0f;
    private static final PageRenderer RENDERER_LEFT;
    private static final PageRenderer RENDERER_RIGHT;
    private final Map<IRenderTypeBuffer.Impl, ThreadLocal<ITessellator>> tessellators = Maps.newConcurrentMap();

    public static JournalRenderer getInstance() {
        return INSTANCE;
    }

    private JournalRenderer() {
    }

    public void render(ItemStack stack, ItemCameraTransforms.TransformType perspective, MatrixStack transforms, IRenderTypeBuffer buffer, int light, int overlay) {
        if (this.renderFull3D(perspective)) {
            if (buffer instanceof IRenderTypeBuffer.Impl) {
                if (JournalViewPointHandler.getInstance().getJournal() == stack) {
                    this.renderJournalOpen(perspective, transforms, (IRenderTypeBuffer.Impl)buffer, light, overlay);
                } else {
                    this.renderJournalClosed(perspective, transforms, (IRenderTypeBuffer.Impl)buffer, light, overlay);
                }
            } else {
                this.renderFlat(stack, perspective, transforms, buffer, light, overlay);
            }
        } else {
            this.renderFlat(stack, perspective, transforms, buffer, light, overlay);
        }
    }

    protected void renderFlat(ItemStack stack, ItemCameraTransforms.TransformType perspective, MatrixStack transforms, IRenderTypeBuffer buffer, int light, int overlay) {
        this.renderItem(stack, perspective, light, overlay, transforms, buffer);
    }

    protected void renderJournalClosed(ItemCameraTransforms.TransformType perspective, MatrixStack transforms, IRenderTypeBuffer.Impl buffer, int light, int overlay) {
        transforms.func_227860_a_();
        this.applyTransformations(perspective, transforms);
        ITessellator tessellator = this.getTessellator(buffer);
        tessellator.startDrawingQuads();
        tessellator.pushMatrix();
        tessellator.applyTransformation(transforms.func_227866_c_().func_227870_a_());
        tessellator.setBrightness(light).setOverlay(overlay);
        tessellator.setColorRGB(COLOR_COVER).drawScaledPrism(0.0f, -1.0f, -7.0f, 5.0f, -0.5f, 0.0f);
        tessellator.setColorRGB(COLOR_PAGE).drawScaledPrism(0.5f, -0.5f, -6.5f, 4.5f, 0.5f, -0.5f);
        tessellator.setColorRGB(COLOR_COVER).drawScaledPrism(0.0f, -0.5f, -7.0f, 0.5f, 0.5f, 0.0f);
        tessellator.setColorRGB(COLOR_COVER).drawScaledPrism(0.0f, 0.5f, -7.0f, 5.0f, 1.0f, 0.0f);
        tessellator.popMatrix();
        tessellator.draw();
        transforms.func_227865_b_();
    }

    protected void renderJournalOpen(ItemCameraTransforms.TransformType perspective, MatrixStack transforms, IRenderTypeBuffer.Impl buffer, int light, int overlay) {
        float openProgress = JournalViewPointHandler.getInstance().getOpeningProgress(this.getPartialTick());
        float flipProgress = JournalViewPointHandler.getInstance().getFlippingProgress(this.getPartialTick());
        transforms.func_227860_a_();
        this.applyTransformations(perspective, transforms);
        if (!perspective.func_241716_a_()) {
            transforms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f * openProgress));
        }
        ITessellator tessellator = this.getTessellator(buffer);
        this.drawOpenBack(tessellator, transforms, openProgress, light, overlay);
        this.drawOpenRight(tessellator, transforms, openProgress, flipProgress, light, overlay);
        this.drawOpenLeft(tessellator, transforms, openProgress, light, overlay);
        this.drawOpenFlipped(tessellator, transforms, flipProgress, light, overlay);
        transforms.func_227865_b_();
    }

    protected void applyTransformations(ItemCameraTransforms.TransformType perspective, MatrixStack transforms) {
        transforms.func_227861_a_(0.5, (double)0.425f, 0.3125);
        if (!perspective.func_241716_a_()) {
            transforms.func_227861_a_(-0.15625, 0.0625, 0.25);
            transforms.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(-90.0f));
        }
    }

    protected void drawOpenBack(ITessellator tessellator, MatrixStack transforms, float openProgress, int light, int overlay) {
        tessellator.startDrawingQuads().setBrightness(light).setOverlay(overlay).pushMatrix();
        transforms.func_227860_a_();
        transforms.func_227861_a_((double)(-openProgress / 32.0f), 0.0, 0.0);
        tessellator.applyTransformation(transforms.func_227866_c_().func_227870_a_());
        tessellator.setColorRGB(COLOR_COVER).drawScaledPrism(0.0f, -1.0f, -7.0f, 0.5f, 1.0f, 0.0f);
        transforms.func_227865_b_();
        tessellator.popMatrix().draw();
    }

    protected void drawOpenRight(ITessellator tessellator, MatrixStack transforms, float openProgress, float flipProgress, int light, int overlay) {
        tessellator.startDrawingQuads().setBrightness(light).setOverlay(overlay).pushMatrix();
        transforms.func_227860_a_();
        transforms.func_227861_a_(0.03125, 0.0, 0.0);
        transforms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-openProgress * 75.0f));
        transforms.func_227861_a_(-0.03125, 0.0, 0.0);
        tessellator.applyTransformation(transforms.func_227866_c_().func_227870_a_());
        tessellator.setColorRGB(COLOR_COVER).drawScaledPrism(0.0f, -1.0f, -7.0f, 5.0f, -0.5f, 0.0f);
        tessellator.setColorRGB(COLOR_PAGE).drawScaledPrism(0.5f, -0.5f, -6.5f, 4.5f, 0.0f, -0.5f);
        tessellator.popMatrix().draw();
        if (openProgress > 0.0f) {
            transforms.func_227860_a_();
            transforms.func_227861_a_(0.03125, (double)6.25E-7f, -0.40625);
            transforms.func_227863_a_(ROTATION_RIGHT);
            if (flipProgress != 0.0f) {
                JournalViewPointHandler.getInstance().renderFlippedPageRight(RENDERER_RIGHT, transforms);
            } else {
                JournalViewPointHandler.getInstance().renderViewedPageRight(RENDERER_RIGHT, transforms);
            }
            transforms.func_227865_b_();
        }
        transforms.func_227865_b_();
    }

    protected void drawOpenLeft(ITessellator tessellator, MatrixStack transforms, float openProgress, int light, int overlay) {
        tessellator.startDrawingQuads().setBrightness(light).setOverlay(overlay).pushMatrix();
        transforms.func_227860_a_();
        transforms.func_227861_a_(0.03125, 0.0, 0.0);
        transforms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(openProgress * 75.0f));
        transforms.func_227861_a_(-0.03125, 0.0, 0.0);
        tessellator.applyTransformation(transforms.func_227866_c_().func_227870_a_());
        tessellator.setColorRGB(COLOR_COVER).drawScaledPrism(0.0f, 0.5f, -7.0f, 5.0f, 1.0f, 0.0f);
        tessellator.setColorRGB(COLOR_PAGE).drawScaledPrism(0.5f, 0.0f, -6.5f, 4.5f, 0.5f, -0.5f);
        tessellator.popMatrix().draw();
        if (openProgress > 0.0f) {
            transforms.func_227860_a_();
            transforms.func_227861_a_(0.28125, (double)-6.25E-7f, -0.40625);
            transforms.func_227863_a_(ROTATION_LEFT);
            JournalViewPointHandler.getInstance().renderViewedPageLeft(RENDERER_LEFT, transforms);
            transforms.func_227865_b_();
        }
        transforms.func_227865_b_();
    }

    protected void drawOpenFlipped(ITessellator tessellator, MatrixStack transforms, float flipProgress, int light, int overlay) {
        if (flipProgress != 0.0f) {
            tessellator.startDrawingQuads().setBrightness(light).setOverlay(overlay).pushMatrix();
            transforms.func_227860_a_();
            transforms.func_227861_a_(0.03125, 0.0, 0.0);
            if (flipProgress < 0.0f) {
                transforms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(MathHelper.func_219799_g((float)(-flipProgress), (float)-75.0f, (float)75.0f)));
            } else {
                transforms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(MathHelper.func_219799_g((float)flipProgress, (float)75.0f, (float)-75.0f)));
            }
            transforms.func_227861_a_(-0.03125, 0.0, 0.0);
            tessellator.applyTransformation(transforms.func_227866_c_().func_227870_a_());
            tessellator.setColorRGB(COLOR_PAGE).drawScaledFaceDouble(0.5f, -6.5f, 4.5f, -0.5f, Direction.UP, 0.0f);
            tessellator.popMatrix().draw();
            transforms.func_227860_a_();
            transforms.func_227861_a_(0.03125, (double)6.25E-5f, -0.40625);
            transforms.func_227863_a_(ROTATION_RIGHT);
            JournalViewPointHandler.getInstance().renderViewedPageRight(RENDERER_LEFT, transforms);
            transforms.func_227865_b_();
            transforms.func_227860_a_();
            transforms.func_227861_a_(0.28125, (double)-6.25E-5f, -0.40625);
            transforms.func_227863_a_(ROTATION_LEFT);
            JournalViewPointHandler.getInstance().renderFlippedPageLeft(RENDERER_LEFT, transforms);
            transforms.func_227865_b_();
            transforms.func_227865_b_();
        }
    }

    protected boolean renderFull3D(ItemCameraTransforms.TransformType perspective) {
        return perspective == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || perspective == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || perspective == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND || perspective == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
    }

    protected ITessellator getTessellator(IRenderTypeBuffer.Impl buffer) {
        return (ITessellator)this.tessellators.computeIfAbsent(buffer, aBuffer -> ThreadLocal.withInitial(() -> this.getVertexBufferTessellator((IRenderTypeBuffer.Impl)aBuffer, this.getRenderType()))).get();
    }

    protected RenderType getRenderType() {
        return PosColorRenderType.INSTANCE;
    }

    static {
        RENDERER_LEFT = new PageRenderer(5.0f, 7.0f, 0.7f);
        RENDERER_RIGHT = new PageRenderer(5.0f, 7.0f, 1.0f);
        COLOR_COVER = new Vector3f(0.0f, 0.007843138f, 0.64705884f);
        COLOR_PAGE = new Vector3f(0.7411765f, 0.7607843f, 0.6862745f);
        ROTATION_RIGHT = Vector3f.field_229179_b_.func_229187_a_(90.0f);
        ROTATION_LEFT = Vector3f.field_229178_a_.func_229187_a_(90.0f);
        ROTATION_LEFT.func_195890_a(Vector3f.field_229183_f_.func_229187_a_(180.0f));
    }

    private static class PosColorRenderType
    extends RenderType {
        private static final RenderType INSTANCE = PosColorRenderType.func_228632_a_((String)"colored_quads", (VertexFormat)DefaultVertexFormats.field_227850_m_, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228723_a_(field_228520_l_).func_228719_a_(field_228528_t_).func_228728_a_(false));

        public PosColorRenderType(String name, VertexFormat format, int i1, int i2, boolean b1, boolean b2, Runnable runnablePre, Runnable runnablePost) {
            super(name, format, i1, i2, b1, b2, runnablePre, runnablePost);
        }
    }
}

