/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.render.blocks;

import com.google.common.collect.Maps;
import com.infinityraider.agricraft.content.irrigation.TileEntitySprinkler;
import com.infinityraider.infinitylib.render.IRenderUtilities;
import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import com.infinityraider.infinitylib.render.tile.ITileRenderer;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TileEntitySprinklerRenderer
implements ITileRenderer<TileEntitySprinkler>,
IRenderUtilities {
    private static final ResourceLocation TEXTURE = new ResourceLocation("minecraft:block/iron_block");
    private final Map<IRenderTypeBuffer.Impl, ThreadLocal<ITessellator>> tessellators = Maps.newConcurrentMap();
    private TextureAtlasSprite sprite;

    public void render(TileEntitySprinkler tile, float partialTicks, MatrixStack transforms, IRenderTypeBuffer buffer, int light, int overlay) {
        if (buffer instanceof IRenderTypeBuffer.Impl) {
            transforms.func_227860_a_();
            transforms.func_227861_a_(0.5, 0.0, 0.5);
            transforms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(tile.getAngle(partialTicks)));
            transforms.func_227861_a_(-0.5, 0.0, -0.5);
            ITessellator tessellator = this.getTessellator((IRenderTypeBuffer.Impl)buffer);
            tessellator.startDrawingQuads();
            tessellator.pushMatrix();
            tessellator.applyTransformation(transforms.func_227866_c_().func_227870_a_());
            tessellator.setBrightness(light).setOverlay(overlay);
            this.drawGeometry(tessellator);
            tessellator.popMatrix().draw();
            transforms.func_227865_b_();
        }
    }

    protected void drawGeometry(ITessellator tessellator) {
        tessellator.drawScaledPrism(6.5f, 4.0f, 6.5f, 9.5f, 15.0f, 9.5f, this.getSprite());
        tessellator.drawScaledPrism(7.5f, 5.0f, 3.5f, 8.5f, 6.0f, 12.5f, this.getSprite());
        tessellator.drawScaledPrism(3.5f, 5.0f, 7.5f, 12.5f, 6.0f, 8.5f, this.getSprite());
    }

    protected TextureAtlasSprite getSprite() {
        if (this.sprite == null) {
            this.sprite = this.getSprite(TEXTURE);
        }
        return this.sprite;
    }

    protected ITessellator getTessellator(IRenderTypeBuffer.Impl buffer) {
        return (ITessellator)this.tessellators.computeIfAbsent(buffer, aBuffer -> ThreadLocal.withInitial(() -> this.getVertexBufferTessellator((IRenderTypeBuffer.Impl)aBuffer, this.getRenderType()))).get();
    }

    protected RenderType getRenderType() {
        return RenderType.func_228639_c_();
    }
}

