/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.render.blocks;

import com.infinityraider.agricraft.api.v1.genetics.IAgriGenePair;
import com.infinityraider.agricraft.content.core.BlockSeedAnalyzer;
import com.infinityraider.agricraft.content.core.TileEntitySeedAnalyzer;
import com.infinityraider.agricraft.handler.SeedAnalyzerViewPointHandler;
import com.infinityraider.agricraft.render.plant.AgriGenomeRenderer;
import com.infinityraider.infinitylib.render.IRenderUtilities;
import com.infinityraider.infinitylib.render.tile.ITileRenderer;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TileEntitySeedAnalyzerSeedRenderer
implements ITileRenderer<TileEntitySeedAnalyzer>,
IRenderUtilities {
    private static final Quaternion TEXT_ROTATION = new Quaternion(Vector3f.field_229179_b_, 90.0f, true);

    public void render(TileEntitySeedAnalyzer tile, float partialTick, MatrixStack transforms, IRenderTypeBuffer buffer, int light, int overlay) {
        if (this.renderSeed(tile, partialTick, transforms, buffer, light, overlay) && tile.canProvideGenesForObserver()) {
            this.renderGenome(tile, partialTick, transforms, buffer);
        }
    }

    protected boolean renderSeed(TileEntitySeedAnalyzer tile, float partialTick, MatrixStack transforms, IRenderTypeBuffer buffer, int light, int overlay) {
        ItemStack seed = tile.getSeed();
        if (seed.func_190926_b()) {
            return false;
        }
        transforms.func_227860_a_();
        SeedAnalyzerViewPointHandler.getInstance().applySeedAnimation(tile, partialTick, transforms);
        this.renderItem(seed, ItemCameraTransforms.TransformType.GROUND, light, overlay, transforms, buffer);
        transforms.func_227865_b_();
        return true;
    }

    protected void renderGenome(TileEntitySeedAnalyzer tile, float partialTick, MatrixStack transforms, IRenderTypeBuffer buffer) {
        List<IAgriGenePair<?>> genes = tile.getGenesToRender();
        if (genes == null) {
            return;
        }
        transforms.func_227860_a_();
        SeedAnalyzerViewPointHandler viewHandler = SeedAnalyzerViewPointHandler.getInstance();
        AgriGenomeRenderer renderer = AgriGenomeRenderer.getInstance();
        int index = viewHandler.getScrollIndex();
        float partial = viewHandler.getPartialScrollProgress(partialTick);
        BlockState state = tile.func_195044_w();
        Direction dir = (Direction)BlockSeedAnalyzer.ORIENTATION.fetch(state);
        float h = 0.5f;
        float r = h / 10.0f;
        float dx = 0.5f + 0.0625f * (float)dir.func_82601_c();
        float dy = 0.3125f;
        float dz = 0.5f + 0.0625f * (float)dir.func_82599_e();
        transforms.func_227861_a_((double)dx, (double)dy, (double)dz);
        transforms.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, tile.getHorizontalAngle(), true));
        renderer.renderDoubleHelix(genes, transforms, buffer, index, partial, r, h, 1.0f, false);
        if (index >= 0 && index < genes.size()) {
            transforms.func_227860_a_();
            transforms.func_227861_a_(0.0, 0.0, -0.1875);
            transforms.func_227863_a_(TEXT_ROTATION);
            float scale = 2.0f / (float)Math.max(this.getScaledWindowWidth(), this.getScaledWindowHeight());
            transforms.func_227862_a_(scale, scale, 1.0f);
            renderer.renderTextOverlay(transforms, genes.get(index));
            transforms.func_227865_b_();
        }
        transforms.func_227865_b_();
    }

    static {
        TEXT_ROTATION.func_195890_a(new Quaternion(Vector3f.field_229183_f_, 180.0f, true));
        TEXT_ROTATION.func_195890_a(new Quaternion(Vector3f.field_229179_b_, 22.5f, true));
    }
}

