/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.plugins.jei;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.IAgriGrowthStage;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.requirement.AgriSeason;
import com.infinityraider.agricraft.api.v1.requirement.IAgriGrowthRequirement;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoil;
import com.infinityraider.agricraft.content.AgriItemRegistry;
import com.infinityraider.agricraft.plugins.jei.AgriIngredientPlant;
import com.infinityraider.agricraft.plugins.jei.IAgriDrawable;
import com.infinityraider.agricraft.plugins.jei.JeiPlugin;
import com.infinityraider.agricraft.plugins.jei.SeasonRenderer;
import com.infinityraider.agricraft.plugins.jei.SoilPropertyIconRenderer;
import com.infinityraider.agricraft.reference.AgriToolTips;
import com.infinityraider.infinitylib.render.IRenderUtilities;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;

@OnlyIn(value=Dist.CLIENT)
public class AgriRecipeCategoryGrowthRequirements
implements IRecipeCategory<IAgriPlant> {
    public static final ResourceLocation ID = new ResourceLocation(AgriCraft.instance.getModId(), "jei/growth_req");
    private final IDrawable icon;
    private final IAgriDrawable background;
    private final IAgriDrawable background_seasons;
    private final Set<TooltipRegion> tooltips;
    private static final Map<IAgriPlant, IRecipeLayout> cache = new WeakHashMap<IAgriPlant, IRecipeLayout>();

    public static void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes((Collection)AgriApi.getPlantRegistry().stream().filter(IAgriPlant::isPlant).collect(Collectors.toList()), ID);
    }

    public static void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)AgriItemRegistry.getInstance().crop_sticks_wood), new ResourceLocation[]{ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)AgriItemRegistry.getInstance().crop_sticks_iron), new ResourceLocation[]{ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)AgriItemRegistry.getInstance().crop_sticks_obsidian), new ResourceLocation[]{ID});
    }

    public AgriRecipeCategoryGrowthRequirements(IGuiHelper helper) {
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((IItemProvider)Blocks.field_150458_ak));
        this.background = JeiPlugin.createAgriDrawable(new ResourceLocation(AgriCraft.instance.getModId(), "textures/gui/jei/growth_req.png"), 0, 0, 128, 128, 128, 128);
        this.background_seasons = JeiPlugin.createAgriDrawable(new ResourceLocation(AgriCraft.instance.getModId(), "textures/gui/jei/growth_req_seasons.png"), 0, 0, 128, 128, 128, 128);
        this.tooltips = ImmutableSet.of((Object)new TooltipRegion(state -> ImmutableList.of((Object)AgriToolTips.getGrowthTooltip(state.getStage())), 102, 20, 111, 70), (Object)new TooltipRegion(state -> ImmutableList.of((Object)new StringTextComponent("").func_230529_a_((ITextComponent)AgriApi.getStatRegistry().strengthStat().getDescription()).func_230529_a_((ITextComponent)new StringTextComponent(": " + state.getStrength()))), 114, 20, 123, 70), (Object)new TooltipRegion((ITextComponent)AgriSeason.SPRING.getDisplayName(), 17, 24, 29, 36, AgriApi.getSeasonLogic()::isActive), (Object)new TooltipRegion((ITextComponent)AgriSeason.SUMMER.getDisplayName(), 17, 37, 29, 49, AgriApi.getSeasonLogic()::isActive), (Object)new TooltipRegion((ITextComponent)AgriSeason.AUTUMN.getDisplayName(), 17, 50, 29, 62, AgriApi.getSeasonLogic()::isActive), (Object)new TooltipRegion((ITextComponent)AgriSeason.WINTER.getDisplayName(), 17, 63, 29, 74, AgriApi.getSeasonLogic()::isActive), (Object[])new TooltipRegion[0]);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return ID;
    }

    @Nonnull
    public Class<IAgriPlant> getRecipeClass() {
        return IAgriPlant.class;
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)"agricraft.gui.growth_req", (Object[])new Object[0]);
    }

    @Nonnull
    public IDrawable getBackground() {
        return AgriApi.getSeasonLogic().isActive() ? this.background_seasons : this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public PlantRenderState getState(IAgriPlant plant) {
        return PlantRenderState.getState(plant);
    }

    public void setIngredients(@Nonnull IAgriPlant plant, IIngredients ingredients) {
        PlantRenderState state = this.getState(plant);
        int strength = state.getStrength();
        IAgriGrowthStage stage = state.getStage();
        ImmutableList seeds = new ImmutableList.Builder().add((Object)plant.toItemStack()).addAll(plant.getSeedItems()).build();
        List soils = AgriApi.getSoilRegistry().stream().filter(soil -> {
            IAgriGrowthRequirement req = plant.getGrowthRequirement(stage);
            boolean humidity = req.getSoilHumidityResponse(soil.getHumidity(), strength).isFertile();
            boolean acidity = req.getSoilAcidityResponse(soil.getAcidity(), strength).isFertile();
            boolean nutrients = req.getSoilNutrientsResponse(soil.getNutrients(), strength).isFertile();
            return humidity && acidity && nutrients;
        }).map(IAgriSoil::getVariants).flatMap(Collection::stream).map(AbstractBlock.AbstractBlockState::func_177230_c).distinct().map(ItemStack::new).collect(Collectors.toList());
        ingredients.setInputLists(VanillaTypes.ITEM, (List)ImmutableList.of((Object)seeds, soils));
        ingredients.setOutputLists(AgriIngredientPlant.TYPE, (List)ImmutableList.of((Object)ImmutableList.of((Object)plant)));
    }

    public void setRecipe(IRecipeLayout layout, @Nonnull IAgriPlant plant, @Nonnull IIngredients ingredients) {
        layout.getIngredientsGroup(AgriIngredientPlant.TYPE).setOverrideDisplayFocus(null);
        layout.getIngredientsGroup(VanillaTypes.ITEM).setOverrideDisplayFocus(null);
        layout.setShapeless();
        layout.getIngredientsGroup(VanillaTypes.ITEM).init(0, true, 55, 2);
        layout.getIngredientsGroup(VanillaTypes.ITEM).init(1, true, 55, 62);
        layout.getIngredientsGroup(AgriIngredientPlant.TYPE).init(0, false, 56, 43);
        layout.getItemStacks().set(ingredients);
        layout.getIngredientsGroup(AgriIngredientPlant.TYPE).set(ingredients);
        cache.put(plant, layout);
    }

    public void draw(@Nonnull IAgriPlant plant, @Nonnull MatrixStack transforms, double mouseX, double mouseY) {
        PlantRenderState state = this.getState(plant);
        int strength = state.getStrength();
        IAgriGrowthStage stage = state.getStage();
        IAgriGrowthRequirement req = plant.getGrowthRequirement(stage);
        AgriIngredientPlant.RENDERER.useGrowthStageForNextRenderCall(plant, stage);
        IncrementRenderer.getInstance().renderStrengthIncrements(transforms, strength);
        IncrementRenderer.getInstance().renderGrowthStageIncrements(transforms, stage);
        LightLevelRenderer.getInstance().renderLightLevels(transforms, 32, 26, mouseX, mouseY, light -> req.getLightLevelResponse((int)light, strength).isFertile());
        Arrays.stream(IAgriSoil.Humidity.values()).filter(IAgriSoil.Humidity::isValid).filter(humidity -> req.getSoilHumidityResponse((IAgriSoil.Humidity)humidity, strength).isFertile()).forEach(humidity -> SoilPropertyIconRenderer.getInstance().drawHumidityIcon((IAgriSoil.SoilProperty)humidity, transforms, 37, 83, mouseX, mouseY));
        Arrays.stream(IAgriSoil.Acidity.values()).filter(IAgriSoil.Acidity::isValid).filter(acidity -> req.getSoilAcidityResponse((IAgriSoil.Acidity)acidity, strength).isFertile()).forEach(acidity -> SoilPropertyIconRenderer.getInstance().drawAcidityIcon((IAgriSoil.SoilProperty)acidity, transforms, 37, 96, mouseX, mouseY));
        Arrays.stream(IAgriSoil.Nutrients.values()).filter(IAgriSoil.Nutrients::isValid).filter(nutrients -> req.getSoilNutrientsResponse((IAgriSoil.Nutrients)nutrients, strength).isFertile()).forEach(nutrients -> SoilPropertyIconRenderer.getInstance().drawNutrientsIcon((IAgriSoil.SoilProperty)nutrients, transforms, 37, 109, mouseX, mouseY));
        SeasonRenderer.getInstance().renderSeasons(transforms, 17, 24, season -> req.getSeasonResponse((AgriSeason)((Object)season), strength).isFertile());
        state.updateStageButtons(102, 10);
        state.updateStrengthButtons(114, 10);
        state.drawGrowthStageButtons(transforms, mouseX, mouseY);
        state.drawStrengthButtons(transforms, mouseX, mouseY);
        this.tooltips.forEach(tooltip -> tooltip.drawTooltip(transforms, mouseX, mouseY, state));
    }

    public boolean handleClick(@Nonnull IAgriPlant plant, double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            PlantRenderState state = this.getState(plant);
            state.updateStageButtons(102, 10);
            state.updateStrengthButtons(114, 10);
            return state.onClick(mouseX, mouseY);
        }
        return super.handleClick((Object)plant, mouseX, mouseY, mouseButton);
    }

    private static final class IncrementRenderer
    implements IRenderUtilities {
        private static final IncrementRenderer INSTANCE = new IncrementRenderer();
        private final ResourceLocation texture = new ResourceLocation(AgriCraft.instance.getModId(), "textures/gui/jei/growth_req_increments.png");

        public static IncrementRenderer getInstance() {
            return INSTANCE;
        }

        private IncrementRenderer() {
        }

        public void renderStrengthIncrements(MatrixStack transforms, int strength) {
            this.bindTexture(this.texture);
            for (int i = 0; i < strength; ++i) {
                AbstractGui.func_238466_a_((MatrixStack)transforms, (int)115, (int)(66 - i * 5), (int)7, (int)3, (float)0.0f, (float)0.0f, (int)7, (int)3, (int)7, (int)4);
            }
        }

        public void renderGrowthStageIncrements(MatrixStack transforms, IAgriGrowthStage stage) {
            this.bindTexture(this.texture);
            double f = stage.growthPercentage();
            int l = 48;
            int h = (int)((double)l * f);
            int y = 21 + l - h;
            AbstractGui.func_238466_a_((MatrixStack)transforms, (int)103, (int)y, (int)7, (int)h, (float)0.0f, (float)3.0f, (int)7, (int)1, (int)7, (int)4);
        }
    }

    private static final class LightLevelRenderer
    implements IRenderUtilities {
        private static final LightLevelRenderer INSTANCE = new LightLevelRenderer();
        private final ResourceLocation texture = new ResourceLocation(AgriCraft.instance.getModId(), "textures/gui/jei/light_levels.png");

        public static LightLevelRenderer getInstance() {
            return INSTANCE;
        }

        private LightLevelRenderer() {
        }

        public void renderLightLevels(MatrixStack transforms, int x, int y, double mX, double mY, Predicate<Integer> predicate) {
            this.bindTexture(this.texture);
            for (int i = 15; i >= 0; --i) {
                int y_i = y + 3 * (15 - i);
                if (predicate.test(i)) {
                    AbstractGui.func_238466_a_((MatrixStack)transforms, (int)x, (int)y_i, (int)3, (int)3, (float)0.0f, (float)(3 * (15 - i)), (int)3, (int)3, (int)3, (int)48);
                }
                if (!(mX >= (double)x) || !(mX <= (double)(x + 3)) || !(mY >= (double)y_i) || !(mY < (double)(y_i + 3))) continue;
                int w = this.getScaledWindowWidth();
                int h = this.getScaledWindowHeight();
                ImmutableList tooltip = ImmutableList.of((Object)new StringTextComponent("").func_230529_a_(AgriToolTips.LIGHT).func_230529_a_((ITextComponent)new StringTextComponent(": " + i)));
                GuiUtils.drawHoveringText((MatrixStack)transforms, (List)tooltip, (int)((int)mX), (int)((int)mY), (int)w, (int)h, (int)-1, (FontRenderer)this.getFontRenderer());
            }
        }
    }

    private static final class TooltipRegion
    implements IRenderUtilities {
        private final Function<PlantRenderState, List<ITextComponent>> tooltip;
        private final int x1;
        private final int y1;
        private final int x2;
        private final int y2;
        private final BooleanSupplier isActive;

        public TooltipRegion(ITextComponent tooltip, int x1, int y1, int x2, int y2) {
            this((List<ITextComponent>)ImmutableList.of((Object)tooltip), x1, y1, x2, y2);
        }

        public TooltipRegion(Function<PlantRenderState, List<ITextComponent>> tooltip, int x1, int y1, int x2, int y2) {
            this(tooltip, x1, y1, x2, y2, () -> true);
        }

        public TooltipRegion(ITextComponent tooltip, int x1, int y1, int x2, int y2, BooleanSupplier isActive) {
            this((List<ITextComponent>)ImmutableList.of((Object)tooltip), x1, y1, x2, y2, isActive);
        }

        public TooltipRegion(List<ITextComponent> tooltip, int x1, int y1, int x2, int y2) {
            this(tooltip, x1, y1, x2, y2, () -> true);
        }

        public TooltipRegion(List<ITextComponent> tooltip, int x1, int y1, int x2, int y2, BooleanSupplier isActive) {
            this((PlantRenderState state) -> tooltip, x1, y1, x2, y2, isActive);
        }

        public TooltipRegion(Function<PlantRenderState, List<ITextComponent>> tooltip, int x1, int y1, int x2, int y2, BooleanSupplier isActive) {
            this.tooltip = tooltip;
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.isActive = isActive;
        }

        public void drawTooltip(MatrixStack transforms, double mX, double mY, PlantRenderState state) {
            if (this.isActive.getAsBoolean() && mX >= (double)this.x1 && mX <= (double)this.x2 && mY >= (double)this.y1 && mY <= (double)this.y2) {
                int w = this.getScaledWindowWidth();
                int h = this.getScaledWindowHeight();
                GuiUtils.drawHoveringText((MatrixStack)transforms, this.tooltip.apply(state), (int)((int)mX), (int)((int)mY), (int)w, (int)h, (int)-1, (FontRenderer)this.getFontRenderer());
            }
        }
    }

    private static final class Button
    implements IRenderUtilities {
        private final ResourceLocation texture;
        private final BooleanSupplier onPress;
        private int x;
        private int y;

        public Button(ResourceLocation texture, BooleanSupplier onPress) {
            this.texture = texture;
            this.onPress = onPress;
        }

        public void updatePosition(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public boolean isOver(double x, double y) {
            return x >= (double)this.x && x <= (double)(this.x + 9) && y >= (double)this.y && y <= (double)(this.y + 9);
        }

        public void draw(MatrixStack transforms, double mX, double mY) {
            int u = 0;
            boolean v = false;
            if (this.isOver(mX, mY)) {
                u = Minecraft.func_71410_x().field_71417_B.func_198030_b() ? 9 : 18;
            }
            this.bindTexture(this.texture);
            AbstractGui.func_238466_a_((MatrixStack)transforms, (int)this.x, (int)this.y, (int)9, (int)9, (float)u, (float)((float)v), (int)9, (int)9, (int)27, (int)9);
        }

        public boolean onPress() {
            return this.onPress.getAsBoolean();
        }
    }

    public static class PlantRenderState {
        private static final Map<IAgriPlant, PlantRenderState> instances = Maps.newIdentityHashMap();
        private final IAgriPlant plant;
        private final List<IAgriGrowthStage> stages;
        private int stage;
        private int strength;
        private final Button incStrButton;
        private final Button decStrButton;
        private final Button incStageButton;
        private final Button decStageButton;
        private final Set<Button> buttons;

        public static PlantRenderState getState(IAgriPlant plant) {
            return instances.computeIfAbsent(plant, PlantRenderState::new);
        }

        private PlantRenderState(IAgriPlant plant) {
            this.plant = plant;
            this.stages = plant.getGrowthStages().stream().sorted((s1, s2) -> (int)(100.0 * (s1.growthPercentage() - s2.growthPercentage()))).collect(Collectors.toList());
            this.stage = 0;
            this.strength = this.getMinStrength();
            ResourceLocation incTexture = new ResourceLocation(AgriCraft.instance.getModId(), "textures/gui/jei/inc_button.png");
            ResourceLocation decTexture = new ResourceLocation(AgriCraft.instance.getModId(), "textures/gui/jei/dec_button.png");
            this.incStrButton = new Button(incTexture, this::incrementStrength);
            this.decStrButton = new Button(decTexture, this::decrementStrength);
            this.incStageButton = new Button(incTexture, this::incrementStage);
            this.decStageButton = new Button(decTexture, this::decrementStage);
            this.buttons = ImmutableSet.of((Object)this.incStrButton, (Object)this.decStrButton, (Object)this.incStageButton, (Object)this.decStageButton);
        }

        public IAgriPlant getPlant() {
            return this.plant;
        }

        public IAgriGrowthStage getStage() {
            return this.stages.get(this.stage);
        }

        public boolean incrementStage() {
            this.stage = Math.min(this.stages.size() - 1, this.stage + 1);
            return true;
        }

        public boolean decrementStage() {
            this.stage = Math.max(0, this.stage - 1);
            return true;
        }

        public int getStrength() {
            return this.strength;
        }

        public int getMinStrength() {
            return AgriApi.getStatRegistry().strengthStat().getMin();
        }

        public int getMaxStrength() {
            return AgriApi.getStatRegistry().strengthStat().getMax();
        }

        public boolean incrementStrength() {
            this.strength = Math.min(this.getMaxStrength(), this.getStrength() + 1);
            this.updateGuiState();
            return true;
        }

        public boolean decrementStrength() {
            this.strength = Math.max(this.getMinStrength(), this.getStrength() - 1);
            this.updateGuiState();
            return true;
        }

        public void updateStrengthButtons(int x, int y) {
            this.incStrButton.updatePosition(x, y);
            this.decStrButton.updatePosition(x, y + 61);
        }

        public void updateStageButtons(int x, int y) {
            this.incStageButton.updatePosition(x, y);
            this.decStageButton.updatePosition(x, y + 61);
        }

        public void drawStrengthButtons(MatrixStack transforms, double mX, double mY) {
            this.incStrButton.draw(transforms, mX, mY);
            this.decStrButton.draw(transforms, mX, mY);
        }

        public void drawGrowthStageButtons(MatrixStack transforms, double mX, double mY) {
            this.incStageButton.draw(transforms, mX, mY);
            this.decStageButton.draw(transforms, mX, mY);
        }

        public boolean onClick(double mX, double mY) {
            return this.buttons.stream().filter(button -> button.isOver(mX, mY)).findFirst().map(Button::onPress).orElse(false);
        }

        protected void updateGuiState() {
            if (cache.containsKey(this.getPlant())) {
                ((IRecipeLayout)cache.get(this.getPlant())).getItemStacks().set(1, AgriApi.getSoilRegistry().stream().filter(soil -> {
                    IAgriGrowthRequirement req = this.getPlant().getGrowthRequirement(this.getStage());
                    boolean humidity = req.getSoilHumidityResponse(soil.getHumidity(), this.getStrength()).isFertile();
                    boolean acidity = req.getSoilAcidityResponse(soil.getAcidity(), this.getStrength()).isFertile();
                    boolean nutrients = req.getSoilNutrientsResponse(soil.getNutrients(), this.getStrength()).isFertile();
                    return humidity && acidity && nutrients;
                }).map(IAgriSoil::getVariants).flatMap(Collection::stream).map(AbstractBlock.AbstractBlockState::func_177230_c).distinct().map(ItemStack::new).collect(Collectors.toList()));
            }
        }
    }
}

