/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.plugins.botanypots;

import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.CropCapability;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.requirement.IAgriGrowthResponse;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.handler.VanillaSeedConversionHandler;
import com.infinityraider.agricraft.plugins.botanypots.AgriCropInfo;
import com.infinityraider.agricraft.plugins.botanypots.BotanyPotAgriCropInstance;
import com.infinityraider.agricraft.util.CropHelper;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.api.events.BotanyPotHarvestedEvent;
import net.darkhax.botanypots.api.events.CropPlaceEvent;
import net.darkhax.botanypots.api.events.CropRemovedEvent;
import net.darkhax.botanypots.api.events.LookupEvent;
import net.darkhax.botanypots.api.events.PotGrowCropEvent;
import net.darkhax.botanypots.crop.CropInfo;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BotanyPotsHandler {
    private static final BotanyPotsHandler INSTANCE = new BotanyPotsHandler();

    public static BotanyPotsHandler getInstance() {
        return INSTANCE;
    }

    private BotanyPotsHandler() {
    }

    @SubscribeEvent
    public void onLookUp(LookupEvent.Crop event) {
        if (event.getCurrentLookup() instanceof AgriCropInfo) {
            event.setLookup((Object)((AgriCropInfo)((Object)event.getCurrentLookup())).withStats(event.getItemStack()));
        } else {
            if (!((Config)AgriCraft.instance.getConfig()).overrideVanillaFarming()) {
                return;
            }
            if (VanillaSeedConversionHandler.getInstance().isException(event.getItemStack())) {
                return;
            }
            AgriApi.getGenomeAdapterizer().valueOf(event.getItemStack()).ifPresent(genome -> {
                ItemStack seedStack = genome.toSeedStack();
                CropInfo info = BotanyPotHelper.getCropForItem((ItemStack)seedStack);
                if (info instanceof AgriCropInfo) {
                    event.setLookup((Object)((AgriCropInfo)info).withStats(seedStack));
                    AgriCraft.instance.queueTask(() -> event.getBotanyPot().setCrop(info, seedStack));
                }
            });
        }
    }

    @SubscribeEvent
    public void onCropPlaced(CropPlaceEvent.Post event) {
        if (event.getBotanyPot().getCrop() instanceof AgriCropInfo) {
            event.getBotanyPot().getCapability(CropCapability.getCapability()).map(crop -> (BotanyPotAgriCropInstance.Impl)crop).ifPresent(BotanyPotAgriCropInstance.Impl::updateGrowthRequirement);
        }
    }

    @SubscribeEvent
    public void onCropRemoved(CropRemovedEvent.Post event) {
        event.getBotanyPot().getCapability(CropCapability.getCapability()).map(crop -> (BotanyPotAgriCropInstance.Impl)crop).ifPresent(BotanyPotAgriCropInstance.Impl::updateGrowthRequirement);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onCropGrowth(PotGrowCropEvent.Pre event) {
        if (event.getBotanyPot().getCrop() instanceof AgriCropInfo) {
            event.getBotanyPot().getCapability(CropCapability.getCapability()).ifPresent(crop -> {
                boolean cancel;
                if (((Config)AgriCraft.instance.getConfig()).allowBotanyPotsWeeds() && CropHelper.rollForWeedAction(crop)) {
                    BotanyPotAgriCropInstance.Impl cropImpl;
                    cancel = true;
                    if (!crop.hasWeeds()) {
                        CropHelper.spawnWeeds(crop);
                    } else if (crop instanceof BotanyPotAgriCropInstance.Impl && (cropImpl = (BotanyPotAgriCropInstance.Impl)crop).incrementWeedCounter(event.getCurrentAmount()) && ((Config)AgriCraft.instance.getConfig()).allowLethalWeeds()) {
                        event.setAmount(-1);
                        if (event.getBotanyPot().getCurrentGrowthTicks() <= 0) {
                            event.getBotanyPot().setCrop(null, ItemStack.field_190927_a);
                        }
                    }
                } else {
                    cancel = false;
                    IAgriGrowthResponse response = crop.getFertilityResponse();
                    if (response.killInstantly()) {
                        event.getBotanyPot().setCrop(null, ItemStack.field_190927_a);
                        response.onPlantKilled((IAgriCrop)crop);
                        cancel = true;
                    } else if (response.isLethal()) {
                        event.setAmount(-1);
                        if (event.getBotanyPot().getCurrentGrowthTicks() <= 0) {
                            event.getBotanyPot().setCrop(null, ItemStack.field_190927_a);
                            cancel = true;
                        }
                    } else {
                        boolean bl = cancel = !response.isFertile();
                    }
                }
                if (cancel) {
                    event.setAmount(0);
                    event.setCanceled(true);
                    event.setResult(Event.Result.DENY);
                }
            });
        }
    }

    @SubscribeEvent
    public void onHarvestPre(BotanyPotHarvestedEvent.Pre event) {
        if (event.getBotanyPot().getCrop() instanceof AgriCropInfo) {
            event.getBotanyPot().getCapability(CropCapability.getCapability()).ifPresent(crop -> {
                if (!crop.canBeHarvested((LivingEntity)event.getHarvestingPlayer())) {
                    event.setCanceled(true);
                    event.setResult(Event.Result.DENY);
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onHarvestLoot(BotanyPotHarvestedEvent.LootGenerated event) {
        if (event.getBotanyPot().getCrop() instanceof AgriCropInfo) {
            event.getBotanyPot().getCapability(CropCapability.getCapability()).ifPresent(crop -> {
                event.getDrops().clear();
                crop.harvest(event.getDrops()::add, (LivingEntity)event.getHarvestingPlayer());
            });
        }
    }
}

