/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.plugins.botanypots;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.content.items.IAgriRakeItem;
import com.infinityraider.agricraft.api.v1.content.items.IAgriSeedItem;
import com.infinityraider.agricraft.api.v1.crop.CropCapability;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.crop.IAgriGrowthStage;
import com.infinityraider.agricraft.api.v1.event.AgriCropEvent;
import com.infinityraider.agricraft.api.v1.fertilizer.IAgriFertilizer;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenome;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.plant.IAgriWeed;
import com.infinityraider.agricraft.api.v1.requirement.IAgriGrowthResponse;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoil;
import com.infinityraider.agricraft.api.v1.stat.IAgriStatProvider;
import com.infinityraider.agricraft.api.v1.stat.IAgriStatsMap;
import com.infinityraider.agricraft.impl.v1.crop.NoGrowth;
import com.infinityraider.agricraft.impl.v1.plant.NoPlant;
import com.infinityraider.agricraft.impl.v1.plant.NoWeed;
import com.infinityraider.agricraft.impl.v1.requirement.RequirementCache;
import com.infinityraider.agricraft.impl.v1.stats.NoStats;
import com.infinityraider.agricraft.plugins.botanypots.AgriCropInfo;
import com.infinityraider.agricraft.util.CropHelper;
import java.util.Comparator;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.block.BlockBotanyPot;
import net.darkhax.botanypots.block.tileentity.TileEntityBotanyPot;
import net.darkhax.botanypots.crop.CropInfo;
import net.darkhax.botanypots.soil.SoilInfo;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class BotanyPotAgriCropInstance
implements CropCapability.Instance<TileEntityBotanyPot, Impl> {
    private static final BotanyPotAgriCropInstance INSTANCE = new BotanyPotAgriCropInstance();

    public static BotanyPotAgriCropInstance getInstance() {
        return INSTANCE;
    }

    private BotanyPotAgriCropInstance() {
    }

    @Override
    public Class<TileEntityBotanyPot> getCarrierClass() {
        return TileEntityBotanyPot.class;
    }

    @Override
    public Class<Impl> getCropClass() {
        return Impl.class;
    }

    @Override
    public Impl createCropFor(TileEntityBotanyPot tile) {
        return new Impl(tile);
    }

    @Override
    public void writeToNBT(CompoundNBT tag, Impl crop) {
        tag.func_74778_a("agri_growth", crop.stage.getId());
        tag.func_74778_a("agri_plant", crop.nextStage.getId());
        tag.func_74778_a("agri_weed", crop.weed.getId());
        tag.func_74778_a("agri_weed_growth", crop.weedStage.getId());
        tag.func_74778_a("agri_connections", crop.nextWeedStage.getId());
        tag.func_74768_a("agri_level", crop.weedCounter);
    }

    @Override
    public void readFromNBT(CompoundNBT tag, Impl crop) {
        if (tag.func_74764_b("agri_growth") && tag.func_74764_b("agri_plant")) {
            crop.stage = AgriApi.getGrowthStageRegistry().get(tag.func_74779_i("agri_growth")).orElse(NoGrowth.getInstance());
            crop.nextStage = crop.stage.isGrowthStage() ? AgriApi.getGrowthStageRegistry().get(tag.func_74779_i("agri_plant")).orElse(NoGrowth.getInstance()) : crop.stage;
        }
        if (tag.func_74764_b("agri_growth") && tag.func_74764_b("agri_plant")) {
            crop.weed = AgriApi.getWeedRegistry().get(tag.func_74779_i("agri_weed")).orElse(NoWeed.getInstance());
            if (crop.weed.isWeed()) {
                crop.weedStage = AgriApi.getGrowthStageRegistry().get(tag.func_74779_i("agri_weed_growth")).orElse(NoGrowth.getInstance());
                crop.nextWeedStage = crop.weedStage.isGrowthStage() ? AgriApi.getGrowthStageRegistry().get(tag.func_74779_i("agri_connections")).orElse(NoGrowth.getInstance()) : crop.weedStage;
                crop.weedCounter = tag.func_74764_b("agri_level") ? tag.func_74762_e("agri_weed") : 0;
            } else {
                crop.weedStage = NoGrowth.getInstance();
                crop.nextWeedStage = NoGrowth.getInstance();
                crop.weedCounter = 0;
            }
        }
    }

    public static class Impl
    implements IAgriCrop {
        private static final int WEED_GROWTH_TICKS = 1000;
        private final TileEntityBotanyPot pot;
        private IAgriGrowthStage stage;
        private IAgriGrowthStage nextStage;
        private IAgriWeed weed;
        private IAgriGrowthStage weedStage;
        private IAgriGrowthStage nextWeedStage;
        private int weedCounter;
        private RequirementCache requirement;

        private Impl(TileEntityBotanyPot pot) {
            this.pot = pot;
            this.stage = NoGrowth.getInstance();
            this.nextStage = NoGrowth.getInstance();
            this.weed = NoWeed.getInstance();
            this.weedStage = NoGrowth.getInstance();
            this.nextWeedStage = NoGrowth.getInstance();
        }

        protected RequirementCache getRequirement() {
            if (this.requirement == null) {
                this.requirement = RequirementCache.create(this);
            }
            return this.requirement;
        }

        public TileEntityBotanyPot asTile() {
            return this.pot;
        }

        @Override
        public boolean isValid() {
            return !this.asTile().func_145837_r() && this.asTile().getCrop() instanceof AgriCropInfo;
        }

        @Override
        @Nonnull
        public BlockPos getPosition() {
            return this.asTile().func_174877_v();
        }

        @Override
        @Nonnull
        public BlockState getBlockState() {
            return this.asTile().func_195044_w();
        }

        @Override
        @Nonnull
        public FluidState getFluidState() {
            return this.getBlockState().func_204520_s();
        }

        @Override
        @Nonnull
        public IAgriGrowthStage getGrowthStage() {
            World world = this.world();
            if (world == null) {
                return NoGrowth.getInstance();
            }
            if (this.hasPlant()) {
                if (this.stage.isGrowthStage() && this.nextStage.isGrowthStage()) {
                    float progress = this.asTile().getGrowthPercent();
                    if ((double)progress >= this.nextStage.growthPercentage() && !this.stage.isFinal()) {
                        this.stage = this.nextStage;
                        this.nextStage = this.stage.getNextStage(this, world.func_201674_k());
                    }
                } else {
                    float progress = this.asTile().getGrowthPercent();
                    this.stage = this.getPlant().getGrowthStages().stream().sorted(Comparator.comparingDouble(IAgriGrowthStage::growthPercentage)).filter(stage -> stage.growthPercentage() >= (double)progress).findFirst().orElse(this.getPlant().getFinalStage());
                    this.nextStage = this.stage.getNextStage(this, world.func_201674_k());
                }
            } else {
                this.stage = NoGrowth.getInstance();
                this.nextStage = NoGrowth.getInstance();
            }
            return this.stage;
        }

        @Override
        public double getGrowthPercentage() {
            return this.asTile().getGrowthPercent();
        }

        @Override
        public boolean setGrowthStage(@Nonnull IAgriGrowthStage stage) {
            return false;
        }

        @Override
        public boolean hasCropSticks() {
            return false;
        }

        @Override
        public boolean isCrossCrop() {
            return false;
        }

        @Override
        public boolean setCrossCrop(boolean status) {
            return false;
        }

        public void updateGrowthRequirement() {
            this.requirement = RequirementCache.create(this);
        }

        @Override
        public IAgriGrowthResponse getFertilityResponse() {
            if (this.world() == null) {
                return IAgriGrowthResponse.INFERTILE;
            }
            return this.getRequirement().check();
        }

        @Override
        public boolean isMature() {
            return this.asTile().canHarvest();
        }

        @Override
        public boolean isFullyGrown() {
            return this.asTile().canHarvest();
        }

        @Override
        @Nonnull
        public Optional<IAgriSoil> getSoil() {
            SoilInfo soilInfo = this.asTile().getSoil();
            if (soilInfo == null) {
                return Optional.empty();
            }
            Block block = soilInfo.getRenderState().getState().func_177230_c();
            if (block == Blocks.field_150346_d) {
                block = Blocks.field_150458_ak;
            }
            return AgriApi.getSoilRegistry().valueOf(block);
        }

        @Override
        public void breakCrop(@Nullable LivingEntity entity) {
            if (this.hasPlant()) {
                IAgriPlant plant = this.getPlant();
                IAgriWeed weed = this.getWeeds();
                if (!MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Break.Pre(this, entity)) && this.removeGenome()) {
                    plant.onBroken(this, entity);
                    weed.onBroken(this, entity);
                    MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Break.Post(this, entity));
                }
            }
        }

        @Override
        @Nonnull
        public Stream<IAgriCrop> streamNeighbours() {
            return Stream.empty();
        }

        @Override
        public void dropItem(ItemStack item) {
            World world = this.world();
            if (world != null) {
                BlockBotanyPot.dropItem((ItemStack)item, (World)world, (BlockPos)this.getPosition());
            }
        }

        @Override
        public boolean canBeHarvested(@Nullable LivingEntity entity) {
            return this.hasPlant() && this.isMature() && this.getPlant().allowsHarvest(this.getGrowthStage(), entity) && !MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Harvest.Pre(this, entity));
        }

        @Override
        @Nonnull
        public ActionResultType harvest(@Nonnull Consumer<ItemStack> consumer, @Nullable LivingEntity entity) {
            World world = this.world();
            CropInfo crop = this.asTile().getCrop();
            if (world != null && crop instanceof AgriCropInfo && this.canBeHarvested(entity)) {
                CropHelper.executePlantHarvestRolls(this, consumer);
                this.getPlant().onHarvest(this, entity);
                MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Harvest.Post(this, entity));
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }

        @Override
        public boolean canBeRaked(@Nonnull IAgriRakeItem item, @Nonnull ItemStack stack, @Nullable LivingEntity entity) {
            return this.hasWeeds();
        }

        @Override
        public boolean rake(@Nonnull Consumer<ItemStack> consumer, @Nullable LivingEntity entity) {
            World world = this.world();
            if (world == null || world.func_201670_d()) {
                return false;
            }
            IAgriWeed weed = this.getWeeds();
            if (weed.isWeed()) {
                IAgriGrowthStage stage = this.getWeedGrowthStage();
                this.setWeed(NoWeed.getInstance(), NoGrowth.getInstance());
                weed.onRake(stage, consumer, world.func_201674_k(), entity);
                return true;
            }
            return false;
        }

        @Override
        public boolean acceptsFertilizer(@Nonnull IAgriFertilizer fertilizer) {
            return false;
        }

        @Override
        public void onApplyFertilizer(@Nonnull IAgriFertilizer fertilizer, @Nonnull Random rand) {
        }

        @Override
        public void applyGrowthTick() {
        }

        @Override
        public void addDisplayInfo(@Nonnull Consumer<ITextComponent> consumer) {
            CropHelper.addDisplayInfo(this, this.getRequirement(), consumer);
        }

        @Override
        public boolean hasPlant() {
            CropInfo info = this.asTile().getCrop();
            return info instanceof AgriCropInfo && ((AgriCropInfo)info).getPlant().isPlant();
        }

        @Override
        @Nonnull
        public IAgriPlant getPlant() {
            CropInfo info = this.asTile().getCrop();
            return info instanceof AgriCropInfo ? ((AgriCropInfo)info).getPlant() : NoPlant.getInstance();
        }

        @Override
        public boolean hasWeeds() {
            return this.weed.isWeed();
        }

        @Override
        @Nonnull
        public IAgriWeed getWeeds() {
            return this.weed;
        }

        public boolean incrementWeedCounter(int amount) {
            if (this.hasWeeds()) {
                this.weedCounter += amount;
                this.weedCounter = Math.min(1000, Math.max(0, this.weedCounter));
                if (this.weedCounter == 0) {
                    this.removeWeed();
                }
                return this.getWeedGrowthStage().isFinal();
            }
            return false;
        }

        public float getWeedGrowthPercent() {
            return (float)this.weedCounter / 1000.0f;
        }

        @Override
        @Nonnull
        public IAgriGrowthStage getWeedGrowthStage() {
            World world = this.world();
            if (world == null) {
                return NoGrowth.getInstance();
            }
            if (this.hasWeeds()) {
                if (this.weedStage.isGrowthStage() && this.nextWeedStage.isGrowthStage()) {
                    float progress = this.getWeedGrowthPercent();
                    if ((double)progress >= this.nextWeedStage.growthPercentage() && !this.weedStage.isFinal()) {
                        this.weedStage = this.nextWeedStage;
                        this.nextWeedStage = this.weedStage.getNextStage(this, world.func_201674_k());
                    }
                } else {
                    float progress = this.getWeedGrowthPercent();
                    this.weedStage = this.getWeeds().getGrowthStages().stream().sorted(Comparator.comparingDouble(IAgriGrowthStage::growthPercentage)).filter(stage -> stage.growthPercentage() >= (double)progress).findFirst().orElse(this.getWeeds().getFinalStage());
                    this.nextWeedStage = this.weedStage.getNextStage(this, world.func_201674_k());
                }
            } else {
                this.weedStage = NoGrowth.getInstance();
                this.nextWeedStage = NoGrowth.getInstance();
            }
            return this.weedStage;
        }

        @Override
        public double getWeedGrowthPercentage() {
            return ((double)this.weedCounter + 0.0) / 1000.0;
        }

        @Override
        public boolean setWeed(@Nonnull IAgriWeed weed, @Nonnull IAgriGrowthStage stage) {
            World world = this.world();
            if (world == null) {
                return false;
            }
            if (this.getWeeds().equals(weed)) {
                if (this.weedStage.equals(stage)) {
                    return false;
                }
                if (this.getWeeds().getGrowthStages().contains(stage)) {
                    this.weedStage = stage;
                    this.getWeeds().onGrowthTick(this);
                    this.nextWeedStage = this.weedStage.getNextStage(this, world.func_201674_k());
                    this.weedCounter = (int)(1000.0 * stage.growthPercentage());
                    return true;
                }
                return false;
            }
            if (weed.getGrowthStages().contains(stage) && !MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Spawn.Weed.Pre((IAgriCrop)this, weed))) {
                this.weed = weed;
                this.weedStage = stage;
                this.nextWeedStage = this.weedStage.getNextStage(this, world.func_201674_k());
                this.weedCounter = (int)(1000.0 * stage.growthPercentage());
                MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Spawn.Weed.Post((IAgriCrop)this, weed));
                return true;
            }
            return false;
        }

        @Override
        public boolean removeWeed() {
            if (this.hasWeeds()) {
                this.weed = NoWeed.getInstance();
                this.weedStage = NoGrowth.getInstance();
                this.nextWeedStage = NoGrowth.getInstance();
                this.weedCounter = 0;
                return true;
            }
            return false;
        }

        @Override
        public boolean acceptsGenome(@Nonnull IAgriGenome genome) {
            return this.asTile().getCrop() == null && this.asTile().getSoil() != null;
        }

        @Override
        public boolean spawnGenome(@Nonnull IAgriGenome genome) {
            if (this.asTile().getCrop() != null) {
                return false;
            }
            SoilInfo soil = this.asTile().getSoil();
            if (soil == null) {
                return false;
            }
            ItemStack seed = genome.toSeedStack();
            CropInfo crop = BotanyPotHelper.getCropForItem((ItemStack)seed);
            if (BotanyPotHelper.isSoilValidForCrop((SoilInfo)soil, (CropInfo)crop) && this.asTile().canSetCrop(crop) && !MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Spawn.Plant.Pre((IAgriCrop)this, genome))) {
                this.asTile().setCrop(crop, seed);
                this.getPlant().onSpawned(this);
                MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Spawn.Plant.Post((IAgriCrop)this, genome));
                return true;
            }
            return false;
        }

        @Override
        public boolean plantGenome(@Nonnull IAgriGenome genome) {
            return this.plantGenome(genome, null);
        }

        @Override
        public boolean plantGenome(@Nonnull IAgriGenome genome, @Nullable LivingEntity entity) {
            if (this.asTile().getCrop() != null) {
                return false;
            }
            SoilInfo soil = this.asTile().getSoil();
            if (soil == null) {
                return false;
            }
            ItemStack seedStack = genome.toSeedStack();
            CropInfo crop = BotanyPotHelper.getCropForItem((ItemStack)seedStack);
            if (BotanyPotHelper.isSoilValidForCrop((SoilInfo)soil, (CropInfo)crop) && this.asTile().canSetCrop(crop) && !MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Plant.Pre(this, genome, entity))) {
                this.asTile().setCrop(crop, seedStack);
                this.getPlant().onSpawned(this);
                MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Plant.Post(this, genome, entity));
                return true;
            }
            return false;
        }

        @Override
        public boolean removeGenome() {
            ItemStack seedStack;
            if (this.asTile().getCrop() != null && !(seedStack = AgriApi.getGenomeAdapterizer().valueOf(this.asTile().getCropStack()).map(IAgriGenome::toSeedStack).orElse(this.asTile().getCropStack())).func_190926_b() && this.asTile().canSetCrop(null)) {
                this.asTile().setCrop(null, ItemStack.field_190927_a);
                this.dropItem(seedStack);
                return true;
            }
            return false;
        }

        @Override
        public boolean hasGenome() {
            return this.hasPlant();
        }

        @Override
        @Nonnull
        public Optional<IAgriGenome> getGenome() {
            ItemStack stack = this.asTile().getCropStack();
            if (!(stack.func_77973_b() instanceof IAgriSeedItem)) {
                return Optional.empty();
            }
            return ((IAgriSeedItem)stack.func_77973_b()).getGenome(stack);
        }

        @Override
        @Nonnull
        public IAgriStatsMap getStats() {
            return this.getGenome().map(IAgriStatProvider::getStats).orElse(NoStats.getInstance());
        }
    }
}

