/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1.stats;

import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.stat.IAgriStat;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class AgriStat
implements IAgriStat {
    private final String name;
    private final IntSupplier min;
    private final IntSupplier max;
    private final BooleanSupplier hidden;
    private final String key;
    private final TranslationTextComponent tooltip;
    private final Vector3f color;

    protected AgriStat(String name, IntSupplier min, IntSupplier max, BooleanSupplier hidden, Vector3f color) {
        this.name = name;
        this.min = min;
        this.max = max;
        this.hidden = hidden;
        this.key = "stat." + this.name;
        this.tooltip = new TranslationTextComponent(AgriCraft.instance.getModId() + "." + this.key);
        this.color = color;
    }

    @Override
    public int getMin() {
        return this.min.getAsInt();
    }

    @Override
    public int getMax() {
        return this.max.getAsInt();
    }

    @Override
    public boolean isHidden() {
        return this.hidden.getAsBoolean();
    }

    @Override
    public void writeValueToNBT(CompoundNBT tag, byte value) {
        tag.func_74768_a(this.key, (int)value);
    }

    @Override
    public int readValueFromNBT(CompoundNBT tag) {
        return tag.func_74762_e(this.key);
    }

    @Override
    public void addTooltip(@Nonnull Consumer<ITextComponent> consumer, int value) {
        if (!this.isHidden()) {
            consumer.accept((ITextComponent)new StringTextComponent("").func_230529_a_((ITextComponent)this.getDescription()).func_230529_a_((ITextComponent)new StringTextComponent(": " + value)).func_240699_a_(TextFormatting.DARK_GRAY));
        }
    }

    @Nonnull
    public TranslationTextComponent getDescription() {
        return this.tooltip;
    }

    @Override
    @Nonnull
    public Vector3f getColor() {
        return this.color;
    }

    @Override
    @Nonnull
    public String getId() {
        return this.name;
    }
}

