/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1.genetics;

import com.agricraft.agricore.util.MathHelper;
import com.infinityraider.agricraft.api.v1.genetics.IAgriMutation;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class Mutation
implements IAgriMutation {
    private final double chance;
    @Nonnull
    private final String id;
    @Nonnull
    private final IAgriPlant child;
    @Nonnull
    private final List<IAgriPlant> parents;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public double getChance() {
        return this.chance;
    }

    @Override
    public IAgriPlant getChild() {
        return this.child;
    }

    @Override
    public List<IAgriPlant> getParents() {
        return this.parents;
    }

    public boolean equals(Object object) {
        if (object instanceof IAgriMutation) {
            IAgriMutation other = (IAgriMutation)object;
            return other.hasChild(this.child) && other.hasParent(this.parents);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.id).append(": ");
        for (IAgriPlant p : this.parents) {
            sb.append(p.getId()).append(" + ");
        }
        sb.replace(sb.length() - 3, sb.length(), " = ");
        sb.append(this.child.getId());
        return sb.toString();
    }

    public Mutation(@Nonnull String id, double chance, @Nonnull IAgriPlant child, IAgriPlant ... parents) {
        this(id, chance, child, Arrays.asList(parents));
    }

    public Mutation(@Nonnull String id, double chance, @Nonnull IAgriPlant child, @Nonnull List<IAgriPlant> parents) {
        this.id = Objects.requireNonNull(id);
        this.chance = MathHelper.inRange(chance, 0.0, 1.0);
        this.child = Objects.requireNonNull(child);
        this.parents = Objects.requireNonNull(parents);
    }
}

