/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1.genetics;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.event.AgriRegistryEvent;
import com.infinityraider.agricraft.api.v1.genetics.IAgriMutation;
import com.infinityraider.agricraft.api.v1.genetics.IAgriMutationRegistry;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.impl.v1.AgriRegistryAbstract;
import com.infinityraider.agricraft.impl.v1.genetics.Mutation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AgriMutationRegistry
extends AgriRegistryAbstract<IAgriMutation>
implements IAgriMutationRegistry {
    private static final AgriMutationRegistry INSTANCE = new AgriMutationRegistry();
    private final Map<IAgriPlant, Integer> complexities = Maps.newIdentityHashMap();

    public static AgriMutationRegistry getInstance() {
        return INSTANCE;
    }

    private AgriMutationRegistry() {
    }

    @Override
    public boolean add(@Nonnull String id, double chance, @Nonnull String childId, String ... parentIds) {
        return this.add(id, chance, childId, Arrays.asList(parentIds));
    }

    @Override
    public boolean add(@Nonnull String id, double chance, @Nonnull String childId, @Nonnull List<String> parentIds) {
        Objects.requireNonNull(id, "The id of a mutation may not be null!");
        Objects.requireNonNull(childId, "The id of the child plant for a mutation may not be null!");
        Objects.requireNonNull(parentIds, "The supplied list of parents for a mutation may not be null!");
        parentIds.forEach(parentId -> Objects.requireNonNull(parentId, "The id of a parent for a mutation may not be null!"));
        IAgriPlant childPlant = AgriApi.getPlantRegistry().get(id).orElse(null);
        if (childPlant == null) {
            return false;
        }
        ArrayList<IAgriPlant> parentPlants = new ArrayList<IAgriPlant>(parentIds.size());
        for (String parentId2 : parentIds) {
            IAgriPlant parentPlant = AgriApi.getPlantRegistry().get(parentId2).orElse(null);
            if (parentPlant != null) {
                parentPlants.add(parentPlant);
                continue;
            }
            return false;
        }
        Mutation mutation = new Mutation(id, chance, childPlant, parentPlants);
        return this.add(mutation);
    }

    @Override
    public boolean add(@Nullable IAgriMutation mutation) {
        boolean result = super.add(mutation);
        if (result && mutation != null && this.updateComplexity(mutation.getChild())) {
            this.updateComplexityForChildren(mutation.getChild());
        }
        return result;
    }

    @Override
    public boolean remove(@Nullable IAgriMutation mutation) {
        boolean result = super.remove(mutation);
        if (result && mutation != null && this.updateComplexity(mutation.getChild())) {
            this.updateComplexityForChildren(mutation.getChild());
        }
        return result;
    }

    protected boolean updateComplexity(IAgriPlant plant) {
        int oldComplexity;
        int newComplexity = this.calculateComplexity(plant);
        if (newComplexity != (oldComplexity = this.complexity(plant))) {
            if (newComplexity == 0) {
                this.complexities.remove(plant);
            } else {
                this.complexities.put(plant, newComplexity);
            }
            return true;
        }
        return false;
    }

    protected void updateComplexityForChildren(IAgriPlant plant) {
        Set visited = Sets.newIdentityHashSet();
        visited.add(plant);
        this.updateComplexityForChildren(plant, visited);
    }

    protected void updateComplexityForChildren(IAgriPlant plant, Set<IAgriPlant> visited) {
        this.stream().filter(mutation -> mutation.hasParent(plant)).map(mutation -> {
            IAgriPlant child = mutation.getChild();
            if (visited.contains(child)) {
                return null;
            }
            if (this.updateComplexity(child)) {
                visited.add(child);
                return child;
            }
            return null;
        }).filter(Objects::nonNull).forEach(child -> this.updateComplexityForChildren((IAgriPlant)child, visited));
    }

    protected int calculateComplexity(IAgriPlant plant) {
        return this.stream().filter(mutation -> mutation.hasChild(plant)).mapToInt(this::calculateComplexity).min().orElse(0);
    }

    protected int calculateComplexity(IAgriMutation mutation) {
        return mutation.getParents().stream().mapToInt(this::complexity).sum() + 1;
    }

    @Override
    public int complexity(IAgriPlant plant) {
        return this.complexities.getOrDefault(plant, 0);
    }

    @Override
    public Stream<IAgriMutation> getMutationsFromParents(List<IAgriPlant> plants) {
        return this.stream().filter(mutation -> mutation.areParentsIn(plants));
    }

    @Override
    @Nullable
    protected AgriRegistryEvent<IAgriMutation> createEvent(IAgriMutation element) {
        return new AgriRegistryEvent.Mutation(this, element);
    }
}

