/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1;

import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.adapter.IAgriAdapterizer;
import com.infinityraider.agricraft.api.v1.fertilizer.IAgriFertilizer;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGeneRegistry;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenome;
import com.infinityraider.agricraft.api.v1.genetics.IAgriMutationRegistry;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.plant.IAgriWeed;
import com.infinityraider.agricraft.api.v1.plugin.AgriPlugin;
import com.infinityraider.agricraft.api.v1.plugin.IAgriPlugin;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSeasonLogic;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoilRegistry;
import com.infinityraider.agricraft.api.v1.stat.IAgriStatRegistry;
import com.infinityraider.agricraft.api.v1.util.IAgriRegistry;
import java.lang.annotation.Annotation;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public final class PluginHandler {
    private static final Deque<IAgriPlugin> PLUGINS = new ConcurrentLinkedDeque<IAgriPlugin>();

    public static void initPlugins() {
        ModList.get().getAllScanData().forEach(data -> PLUGINS.addAll(PluginHandler.getInstances(data, AgriPlugin.class, IAgriPlugin.class, plugin -> plugin.alwaysLoad() || ModList.get().isLoaded(plugin.modId()))));
    }

    public static void onCommonSetup(FMLCommonSetupEvent event) {
        PLUGINS.forEach(PluginHandler::logPlugin);
        PluginHandler.executeForPlugins(plugin -> plugin.onCommonSetupEvent(event));
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        PluginHandler.executeForPlugins(plugin -> plugin.onClientSetupEvent(event));
    }

    public static void onServerSetup(FMLDedicatedServerSetupEvent event) {
        PluginHandler.executeForPlugins(plugin -> plugin.onServerSetupEvent(event));
    }

    public static void onInterModEnqueueEvent(InterModEnqueueEvent event) {
        PluginHandler.executeForPlugins(plugin -> plugin.onInterModEnqueueEvent(event));
    }

    public static void onInterModProcessEvent(InterModProcessEvent event) {
        PluginHandler.executeForPlugins(plugin -> plugin.onInterModProcessEvent(event));
    }

    private static void executeForPlugins(Consumer<IAgriPlugin> consumer) {
        PLUGINS.stream().filter(IAgriPlugin::isEnabled).forEach(consumer);
    }

    public static void populateRegistries() {
        PluginHandler.registerSoils(AgriApi.getSoilRegistry());
        PluginHandler.registerWeeds(AgriApi.getWeedRegistry());
        PluginHandler.registerPlants(AgriApi.getPlantRegistry());
        PluginHandler.registerMutations(AgriApi.getMutationRegistry());
        PluginHandler.registerStats(AgriApi.getStatRegistry());
        PluginHandler.registerGenes(AgriApi.getGeneRegistry());
        PluginHandler.registerGenomes(AgriApi.getGenomeAdapterizer());
        PluginHandler.registerFertilizers(AgriApi.getFertilizerAdapterizer());
        PluginHandler.registerSeasonLogic(AgriApi.getSeasonLogic());
    }

    public static void registerSoils(IAgriSoilRegistry soilRegistry) {
        PluginHandler.executeForPlugins(plugin -> plugin.registerSoils(soilRegistry));
    }

    public static void registerWeeds(IAgriRegistry<IAgriWeed> weedRegistry) {
        PluginHandler.executeForPlugins(plugin -> plugin.registerWeeds(weedRegistry));
    }

    public static void registerPlants(IAgriRegistry<IAgriPlant> plantRegistry) {
        PluginHandler.executeForPlugins(plugin -> plugin.registerPlants(plantRegistry));
    }

    public static void registerMutations(IAgriMutationRegistry mutationRegistry) {
        PluginHandler.executeForPlugins(plugin -> plugin.registerMutations(mutationRegistry));
    }

    public static void registerStats(IAgriStatRegistry statRegistry) {
        PluginHandler.executeForPlugins(plugin -> plugin.registerStats(statRegistry));
    }

    public static void registerGenes(IAgriGeneRegistry geneRegistry) {
        PluginHandler.executeForPlugins(plugin -> plugin.registerGenes(geneRegistry));
    }

    public static void registerGenomes(IAgriAdapterizer<IAgriGenome> adapterizer) {
        PluginHandler.executeForPlugins(plugin -> plugin.registerGenomes(adapterizer));
    }

    public static void registerFertilizers(IAgriAdapterizer<IAgriFertilizer> adapterizer) {
        PluginHandler.executeForPlugins(plugin -> plugin.registerFertilizers(adapterizer));
    }

    public static void registerSeasonLogic(IAgriSeasonLogic seasonLogic) {
        PluginHandler.executeForPlugins(plugin -> plugin.registerSeasonLogic(seasonLogic));
    }

    @Nonnull
    private static <A extends Annotation, T> List<T> getInstances(ModFileScanData data, Class<A> anno, Class<T> type, Predicate<A> predicate) {
        return data.getAnnotations().stream().filter(annotationData -> Type.getType((Class)anno).equals((Object)annotationData.getAnnotationType())).filter(annotationData -> PluginHandler.checkAnnotationPredicate(anno, predicate, annotationData)).map(annotationData -> {
            try {
                return Class.forName(annotationData.getClassType().getClassName()).asSubclass(type).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoClassDefFoundError e) {
                AgriCore.getLogger("agricraft-plugins").debug("%nFailed to load AgriPlugin%n\tOf class: {0}!%n\tFor annotation: {1}!%n\tAs Instanceof: {2}!", new Object[]{annotationData.getTargetType(), anno.getCanonicalName(), type.getCanonicalName()});
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static <A extends Annotation> boolean checkAnnotationPredicate(Class<A> anno, Predicate<A> predicate, ModFileScanData.AnnotationData data) {
        try {
            return predicate.test(Class.forName(data.getMemberName()).getAnnotation(anno));
        }
        catch (Exception e) {
            AgriCore.getLogger("agricraft-plugins").error("Failed to check plugin " + data.getMemberName(), new Object[0]);
            return false;
        }
    }

    private static void logPlugin(IAgriPlugin plugin) {
        AgriCore.getLogger("agricraft").info("\nFound AgriCraft Plugin:\n\t- Id: {0}\n\t- Description: {1}\n\t- Status: {2}", plugin.getId(), plugin.getDescription(), plugin.isEnabled() ? "Enabled" : "Disabled");
    }
}

