/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1;

import com.agricraft.agricore.log.AgriLogAdapter;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.config.Config;
import org.apache.logging.log4j.Level;

public class AgriLoggerImpl
implements AgriLogAdapter {
    public void log(Level logLevel, Object source, String format, Object ... objects) {
        try {
            AgriCraft.instance.getLogger().log(logLevel, "[" + source + "]" + format, objects);
        }
        catch (IllegalArgumentException ex) {
            AgriCraft.instance.getLogger().log(logLevel, "[" + source + "]" + format, new Object[0]);
        }
    }

    @Override
    public void all(Object source, String format, Object ... objects) {
        this.log(Level.ALL, source, format, objects);
    }

    @Override
    public void debug(Object source, String format, Object ... objects) {
        if (((Config)AgriCraft.instance.getConfig()).debugMode()) {
            this.log(Level.INFO, source, "[DEBUG]: " + format, objects);
        }
    }

    @Override
    public void trace(Object source, Exception e) {
        this.debug(source, e.getLocalizedMessage(), new Object[0]);
    }

    @Override
    public void error(Object source, String format, Object ... objects) {
        this.log(Level.ERROR, source, format, objects);
    }

    @Override
    public void info(Object source, String format, Object ... objects) {
        this.log(Level.INFO, source, format, objects);
    }

    @Override
    public void warn(Object source, String format, Object ... objects) {
        this.log(Level.WARN, source, format, objects);
    }

    @Override
    public void severe(Object source, String format, Object ... objects) {
        this.log(Level.FATAL, source, format, objects);
    }
}

