/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.handler;

import com.google.common.collect.Sets;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.content.items.IAgriSeedItem;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenome;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.content.core.TileEntitySeedAnalyzer;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class VanillaSeedConversionHandler {
    private static final VanillaSeedConversionHandler INSTANCE = new VanillaSeedConversionHandler();
    private final Set<Item> exceptions = Sets.newConcurrentHashSet();

    public static VanillaSeedConversionHandler getInstance() {
        return INSTANCE;
    }

    private VanillaSeedConversionHandler() {
    }

    public void registerException(Item item) {
        this.exceptions.add(item);
    }

    public boolean isException(ItemStack stack) {
        return this.exceptions.contains(stack.func_77973_b());
    }

    public ItemStack attemptConvert(ItemStack stack) {
        if (stack.func_77973_b() instanceof IAgriSeedItem) {
            return stack;
        }
        if (this.isException(stack)) {
            return stack;
        }
        return AgriApi.getGenomeAdapterizer().valueOf(stack).map(genome -> genome.toSeedStack(stack.func_190916_E())).orElse(stack);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void vanillaSeedConversion(PlayerInteractEvent.RightClickBlock event) {
        if (this.failsPreChecks(event.getWorld(), event.getPos(), event.getItemStack())) {
            return;
        }
        if (this.runSeedAnalyzerConversion(event.getWorld(), event.getPos(), event.getItemStack(), event.getEntityLiving(), event.getHand())) {
            return;
        }
        if (this.runPlantingConversion(event.getWorld(), event.getFace() == null ? event.getPos() : event.getPos().func_177972_a(event.getFace()), event.getItemStack(), event.getPlayer(), event.getHand())) {
            event.setUseItem(Event.Result.DENY);
            event.setCanceled(true);
            event.getPlayer().func_184609_a(event.getHand());
        }
    }

    protected boolean failsPreChecks(World world, BlockPos pos, ItemStack stack) {
        if (!((Config)AgriCraft.instance.getConfig()).overrideVanillaFarming()) {
            return true;
        }
        if (this.isException(stack)) {
            return true;
        }
        return AgriApi.getCrop((IBlockReader)world, pos).isPresent();
    }

    protected boolean runSeedAnalyzerConversion(World world, BlockPos pos, ItemStack stack, LivingEntity entity, Hand hand) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntitySeedAnalyzer) {
            if (entity.func_225608_bj_()) {
                TileEntitySeedAnalyzer analyzer;
                if (stack.func_77973_b() instanceof IAgriSeedItem) {
                    return true;
                }
                ItemStack converted = AgriApi.attemptConversionToAgriSeed(stack);
                if (converted.func_77973_b() instanceof IAgriSeedItem && !(analyzer = (TileEntitySeedAnalyzer)tile).hasSeed()) {
                    entity.func_184611_a(hand, converted);
                }
            }
            return true;
        }
        return false;
    }

    protected boolean runPlantingConversion(World world, BlockPos pos, ItemStack stack, PlayerEntity player, Hand hand) {
        return !((Config)AgriCraft.instance.getConfig()).convertSeedsOnlyInAnalyzer() && AgriApi.getGenomeAdapterizer().valueOf(stack).map(seed -> AgriApi.getSoil((IBlockReader)world, pos.func_177977_b()).map(soil -> {
            MutableBoolean consumed = new MutableBoolean(false);
            boolean cropSticks = AgriApi.getCrop((IBlockReader)world, pos).map(crop -> {
                if (!crop.hasPlant() && !crop.isCrossCrop() && crop.plantGenome((IAgriGenome)seed, (LivingEntity)player)) {
                    if (player == null || !player.func_184812_l_()) {
                        stack.func_190918_g(1);
                        consumed.setValue(true);
                    }
                    if (player != null) {
                        player.func_184609_a(hand);
                    }
                }
                return true;
            }).orElse(false);
            if (cropSticks) {
                return consumed.getValue();
            }
            BlockState newState = AgriCraft.instance.getModBlockRegistry().crop_plant.getStateForPlacement(world, pos);
            if (newState != null && world.func_180501_a(pos, newState, 11)) {
                boolean planted = AgriApi.getCrop((IBlockReader)world, pos).map(crop -> crop.plantGenome((IAgriGenome)seed, (LivingEntity)player)).orElse(false);
                if (planted) {
                    if (player == null || !player.func_184812_l_()) {
                        stack.func_190918_g(1);
                    }
                    return true;
                }
                world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            }
            return false;
        }).orElse(false)).orElse(false) != false;
    }
}

