/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.handler;

import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.content.tools.ItemSeedBag;
import com.infinityraider.agricraft.proxy.IProxy;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class SeedBagShakeHandler {
    private static final SeedBagShakeHandler INSTANCE = new SeedBagShakeHandler();
    private static final int DURATION = 60;
    private static final int AMPLITUDE = 30;
    private static final float PERIOD = 20.0f;
    private int counterMain;
    private int prevCounterMain;
    private int counterOff;
    private int prevCounterOff;

    public static SeedBagShakeHandler getInstance() {
        return INSTANCE;
    }

    private SeedBagShakeHandler() {
    }

    public void shake(Hand hand) {
        if (hand == Hand.MAIN_HAND) {
            this.counterMain = 60;
            this.prevCounterMain = 60;
        } else {
            this.counterOff = 60;
            this.prevCounterOff = 60;
        }
    }

    protected PlayerEntity getPlayer() {
        return ((IProxy)AgriCraft.instance.proxy()).getClientPlayer();
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        this.prevCounterMain = this.counterMain;
        if (this.counterMain > 0) {
            --this.counterMain;
        }
        this.prevCounterOff = this.counterOff;
        if (this.counterOff > 0) {
            --this.counterOff;
        }
    }

    @SubscribeEvent
    public void onRenderHand(RenderHandEvent event) {
        if (!(this.getPlayer().func_184586_b(event.getHand()).func_77973_b() instanceof ItemSeedBag)) {
            return;
        }
        if (event.getHand() == Hand.MAIN_HAND) {
            float fraction = 30.0f - MathHelper.func_219799_g((float)event.getPartialTicks(), (float)this.prevCounterMain, (float)this.counterMain);
            float angle = 30.0f * MathHelper.func_76126_a((float)((float)((double)(fraction * 2.0f) * Math.PI / 20.0)));
            event.getMatrixStack().func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(angle));
        } else {
            float fraction = 30.0f - MathHelper.func_219799_g((float)event.getPartialTicks(), (float)this.prevCounterOff, (float)this.counterOff);
            float angle = 30.0f * MathHelper.func_76126_a((float)((float)((double)(fraction * 2.0f) * Math.PI / 20.0)));
            event.getMatrixStack().func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(angle));
        }
    }
}

