/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.handler;

import com.google.common.collect.ImmutableList;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenePair;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenome;
import com.infinityraider.agricraft.content.tools.ItemMagnifyingGlass;
import com.infinityraider.agricraft.network.MessageMagnifyingGlassObserving;
import com.infinityraider.agricraft.render.plant.AgriGenomeRenderer;
import com.infinityraider.agricraft.util.AnimatedScrollPosition;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class MagnifyingGlassViewHandler {
    private static final MagnifyingGlassViewHandler INSTANCE = new MagnifyingGlassViewHandler();
    private static final int ANIMATION_DURATION = 20;
    private static final int SCROLL_DURATION = 10;
    private static final double DX = 0.475;
    private static final double DY = -0.3125;
    private static final double DZ = 0.45;
    private static final double GENOME_OFFSET = 0.1;
    private static final float GENOME_SCALE = 0.075f;
    private static final double TEXT_OFFSET = -0.025;
    private static final float TEXT_SCALE = 0.75f;
    private static final Quaternion TEXT_FLIPPER = Vector3f.field_229183_f_.func_229187_a_(180.0f);
    private static final float ANGLE = 45.0f;
    private static final Quaternion ROTATION_LEFT;
    private static final Quaternion ROTATION_RIGHT;
    private boolean active = false;
    private Hand hand = null;
    private int animationCounter = 0;
    private int animationCounterPrev = 0;
    private final AnimatedScrollPosition scrollPosition = new AnimatedScrollPosition(() -> 10, () -> this.genomeCache == null ? 0 : this.genomeCache.size());
    private BlockPos lastPos;
    private List<IAgriGenePair<?>> genomeCache;

    public static MagnifyingGlassViewHandler getInstance() {
        return INSTANCE;
    }

    private MagnifyingGlassViewHandler() {
    }

    public void toggle(Hand hand) {
        if (this.isHandActive(hand)) {
            this.active = false;
            this.lastPos = null;
            this.genomeCache = null;
        } else {
            this.hand = hand;
            this.active = true;
        }
        this.scrollPosition.reset();
        MessageMagnifyingGlassObserving.sendToServer(this.getPlayer(), this.isActive());
    }

    @Nullable
    public Hand getActiveHand() {
        return this.hand;
    }

    public boolean isHandActive(@Nonnull Hand hand) {
        return this.getActiveHand() == hand;
    }

    public boolean isActive() {
        return this.active;
    }

    protected PlayerEntity getPlayer() {
        return AgriCraft.instance.getClientPlayer();
    }

    public boolean isAnimationComplete() {
        return this.isAnimationComplete(0.0f);
    }

    protected boolean isAnimationComplete(float partialTicks) {
        return this.isActive() ? (double)this.getAnimationProgress(partialTicks) == 1.0 : this.getAnimationProgress(partialTicks) == 0.0f;
    }

    protected float getAnimationProgress(float partialTick) {
        return MathHelper.func_219799_g((float)partialTick, (float)this.animationCounterPrev, (float)this.animationCounter) / 20.0f;
    }

    public int getScrollIndex() {
        return this.scrollPosition.getIndex();
    }

    public float getScrollProgress(float partialTick) {
        return this.scrollPosition.getProgress(partialTick);
    }

    protected void manipulateMatrixStackLeft(MatrixStack stack, float partialTick) {
        if (this.isAnimationComplete(partialTick)) {
            stack.func_227861_a_(0.475, -0.3125, 0.45);
            stack.func_227863_a_(ROTATION_LEFT);
        } else {
            float f = this.getAnimationProgress(partialTick);
            stack.func_227861_a_((double)f * 0.475, (double)f * -0.3125, (double)f * 0.45);
            stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-f * 45.0f));
        }
    }

    protected void manipulateMatrixStackRight(MatrixStack stack, float partialTick) {
        if (this.isAnimationComplete(partialTick)) {
            stack.func_227861_a_(-0.475, -0.3125, 0.45);
            stack.func_227863_a_(ROTATION_RIGHT);
        } else {
            float f = this.getAnimationProgress(partialTick);
            stack.func_227861_a_((double)(-f) * 0.475, (double)f * -0.3125, (double)f * 0.45);
            stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f * 45.0f));
        }
    }

    protected void updateGeneCache() {
        RayTraceResult target = Minecraft.func_71410_x().field_71476_x;
        if (target instanceof BlockRayTraceResult) {
            BlockRayTraceResult blockTarget = (BlockRayTraceResult)target;
            if (!blockTarget.func_216350_a().equals((Object)this.lastPos)) {
                World world = AgriCraft.instance.getClientWorld();
                this.scrollPosition.reset();
                this.lastPos = blockTarget.func_216350_a();
                this.genomeCache = AgriApi.getCrop((IBlockReader)world, this.lastPos).map(crop -> crop.getGenome().map(IAgriGenome::getGeneList).orElse((List)ImmutableList.of())).orElse((List)ImmutableList.of());
            }
        } else {
            this.lastPos = null;
            this.genomeCache = ImmutableList.of();
            this.scrollPosition.reset();
        }
    }

    protected void renderDoubleHelix(List<IAgriGenePair<?>> genome, MatrixStack transforms, float partialTicks) {
        transforms.func_227860_a_();
        float h = 0.5f;
        float r = h / 10.0f;
        transforms.func_227862_a_(0.075f, 0.075f, 0.075f);
        transforms.func_227861_a_(0.0, (double)(-h / 2.0f), 0.0);
        AgriGenomeRenderer.getInstance().renderDoubleHelix(genome, transforms, this.getScrollIndex(), this.getScrollProgress(partialTicks), r, h, 1.0f, false);
        transforms.func_227865_b_();
    }

    protected void renderTextOverlay(List<IAgriGenePair<?>> genome, MatrixStack transforms) {
        transforms.func_227860_a_();
        transforms.func_227861_a_(0.0, -0.025, 0.0);
        transforms.func_227863_a_(TEXT_FLIPPER);
        float width = AgriGenomeRenderer.getInstance().getScaledWindowWidth();
        float height = AgriGenomeRenderer.getInstance().getScaledWindowHeight();
        float scale = 0.75f / Math.max(width, height);
        transforms.func_227862_a_(scale, scale, scale);
        int index = Math.max(0, Math.min(genome.size() - 1, this.getScrollIndex()));
        AgriGenomeRenderer.getInstance().renderTextOverlay(transforms, genome.get(index));
        transforms.func_227865_b_();
    }

    @SubscribeEvent
    public void onRenderHand(RenderHandEvent event) {
        if (!(this.getPlayer().func_184586_b(event.getHand()).func_77973_b() instanceof ItemMagnifyingGlass)) {
            return;
        }
        if (this.isHandActive(event.getHand())) {
            HandSide main = Minecraft.func_71410_x().field_71474_y.field_186715_A;
            if (event.getHand() == Hand.MAIN_HAND) {
                if (main == HandSide.RIGHT) {
                    this.manipulateMatrixStackRight(event.getMatrixStack(), event.getPartialTicks());
                } else {
                    this.manipulateMatrixStackLeft(event.getMatrixStack(), event.getPartialTicks());
                }
            } else if (main == HandSide.LEFT) {
                this.manipulateMatrixStackRight(event.getMatrixStack(), event.getPartialTicks());
            } else {
                this.manipulateMatrixStackLeft(event.getMatrixStack(), event.getPartialTicks());
            }
        }
    }

    @SubscribeEvent
    public void renderGenome(RenderWorldLastEvent event) {
        List<IAgriGenePair<?>> genome = this.genomeCache;
        if (genome == null || genome.size() <= 0) {
            return;
        }
        if (!Minecraft.func_71410_x().field_71474_y.func_243230_g().func_243192_a()) {
            return;
        }
        if (this.lastPos == null) {
            return;
        }
        MatrixStack transforms = event.getMatrixStack();
        transforms.func_227860_a_();
        Vector3d projectedView = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        transforms.func_227861_a_(-projectedView.field_72450_a, -projectedView.field_72448_b, -projectedView.field_72449_c);
        Vector3d eyes = this.getPlayer().func_174824_e(event.getPartialTicks());
        transforms.func_227861_a_(eyes.func_82615_a(), eyes.func_82617_b(), eyes.func_82616_c());
        Vector3d hit = new Vector3d((double)this.lastPos.func_177958_n() + 0.5, (double)this.lastPos.func_177956_o() + 0.5, (double)this.lastPos.func_177952_p() + 0.5);
        Vector3d view = hit.func_178788_d(eyes).func_72432_b();
        transforms.func_227861_a_(0.1 * view.func_82615_a(), 0.1 * view.func_82617_b(), 0.1 * view.func_82616_c());
        float yaw = (float)(Math.PI * (double)this.getPlayer().func_195046_g(event.getPartialTicks())) / 180.0f;
        float pitch = (float)(Math.PI * (double)this.getPlayer().func_195050_f(event.getPartialTicks())) / 180.0f;
        transforms.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(-yaw));
        this.renderDoubleHelix(genome, transforms, event.getPartialTicks());
        this.renderTextOverlay(genome, transforms);
        transforms.func_227865_b_();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerRender(RenderPlayerEvent.Pre event) {
        if (this.isActive()) {
            PlayerRenderer renderer = event.getRenderer();
            PlayerModel model = (PlayerModel)renderer.func_217764_d();
            Hand hand = this.getActiveHand();
            HandSide side = Minecraft.func_71410_x().field_71474_y.field_186715_A;
            if (hand == Hand.MAIN_HAND && side == HandSide.RIGHT || hand == Hand.OFF_HAND && side == HandSide.LEFT) {
                model.field_187076_m = BipedModel.ArmPose.BLOCK;
                model.field_187075_l = BipedModel.ArmPose.EMPTY;
            } else if (hand == Hand.MAIN_HAND && side == HandSide.LEFT || hand == Hand.OFF_HAND && side == HandSide.RIGHT) {
                model.field_187075_l = BipedModel.ArmPose.BLOCK;
                model.field_187076_m = BipedModel.ArmPose.EMPTY;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        this.animationCounterPrev = this.animationCounter;
        if (this.isActive()) {
            if (this.getActiveHand() == null || !(this.getPlayer().func_184586_b(this.getActiveHand()).func_77973_b() instanceof ItemMagnifyingGlass)) {
                this.active = false;
                this.lastPos = null;
                this.genomeCache = null;
                this.scrollPosition.reset();
                MessageMagnifyingGlassObserving.sendToServer(this.getPlayer(), this.isActive());
                return;
            }
            this.animationCounter = this.animationCounter < 20 ? ++this.animationCounter : 20;
            if (this.isAnimationComplete()) {
                this.scrollPosition.tick();
                this.updateGeneCache();
            }
        } else if (this.animationCounter > 0) {
            --this.animationCounter;
        } else {
            this.animationCounter = 0;
            this.hand = null;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onMouseScroll(InputEvent.MouseScrollEvent event) {
        if (this.isActive() && this.isAnimationComplete()) {
            this.scrollPosition.scroll((int)event.getScrollDelta());
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onMouseClick(InputEvent.ClickInputEvent event) {
        if (this.isActive() && event.getKeyBinding() == Minecraft.func_71410_x().field_71474_y.field_74312_F) {
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onMovementInput(InputUpdateEvent event) {
        if (this.isActive()) {
            event.getMovementInput().field_78902_a = 0.0f;
            event.getMovementInput().field_192832_b = 0.0f;
            event.getMovementInput().field_187255_c = false;
            event.getMovementInput().field_187256_d = false;
            event.getMovementInput().field_187257_e = false;
            event.getMovementInput().field_187258_f = false;
            event.getMovementInput().field_78901_c = false;
            event.getMovementInput().field_228350_h_ = true;
        }
    }

    static {
        ROTATION_RIGHT = Vector3f.field_229183_f_.func_229187_a_(45.0f);
        ROTATION_LEFT = Vector3f.field_229183_f_.func_229187_a_(-45.0f);
    }
}

