/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.handler;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlockUpdateHandler {
    private static final BlockUpdateHandler INSTANCE = new BlockUpdateHandler();
    private final Map<RegistryKey<World>, Map<ChunkPos, Map<BlockPos, Set<IListener>>>> listeners = Maps.newHashMap();

    public static BlockUpdateHandler getInstance() {
        return INSTANCE;
    }

    private BlockUpdateHandler() {
    }

    public void addListener(World world, BlockPos pos, IListener listener) {
        if (world instanceof ServerWorld) {
            RegistryKey dimension = world.func_234923_W_();
            this.listeners.computeIfAbsent((RegistryKey<World>)dimension, key -> Maps.newHashMap()).computeIfAbsent(new ChunkPos(pos), chunkPos -> Maps.newHashMap()).computeIfAbsent(pos, aPos -> Sets.newIdentityHashSet()).add(listener);
        }
    }

    public void removeListener(World world, BlockPos pos, IListener listener) {
        if (world instanceof ServerWorld) {
            RegistryKey dimension = world.func_234923_W_();
            this.listeners.computeIfPresent((RegistryKey<World>)dimension, (dim, chunkMap) -> {
                chunkMap.computeIfPresent(new ChunkPos(pos), (chunkPos, posMap) -> {
                    posMap.computeIfPresent(pos, (aPos, set) -> {
                        set.remove(listener);
                        return set;
                    });
                    return posMap;
                });
                return chunkMap;
            });
        }
    }

    @SubscribeEvent
    public void onChunkUnloaded(ChunkEvent.Unload event) {
        ServerWorld world;
        RegistryKey dimension;
        if (event.getWorld() instanceof ServerWorld && this.listeners.containsKey(dimension = (world = (ServerWorld)event.getWorld()).func_234923_W_())) {
            this.listeners.computeIfPresent((RegistryKey<World>)dimension, (dim, chunkMap) -> {
                if (chunkMap.containsKey(event.getChunk().func_76632_l())) {
                    ((Map)chunkMap.remove(event.getChunk().func_76632_l())).forEach((pos, set) -> set.forEach(listener -> listener.onChunkUnloaded(world, (BlockPos)pos)));
                }
                return chunkMap;
            });
            this.listeners.get(dimension).remove(event.getChunk().func_76632_l());
        }
    }

    @SubscribeEvent
    public void onWorldUnloaded(WorldEvent.Unload event) {
        ServerWorld world;
        if (event.getWorld() instanceof ServerWorld && this.listeners.containsKey((world = (ServerWorld)event.getWorld()).func_234923_W_())) {
            this.listeners.remove(world.func_234923_W_()).values().stream().flatMap(map -> map.entrySet().stream()).forEach(entry -> ((Set)entry.getValue()).forEach(listener -> listener.onWorldUnloaded(world, (BlockPos)entry.getKey())));
        }
    }

    @SubscribeEvent
    public void onBlockUpdate(BlockEvent.NeighborNotifyEvent event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld world = (ServerWorld)event.getWorld();
            RegistryKey dimension = world.func_234923_W_();
            this.listeners.computeIfPresent((RegistryKey<World>)dimension, (dim, chunkMap) -> {
                chunkMap.computeIfPresent(new ChunkPos(event.getPos()), (chunkPos, posMap) -> {
                    posMap.computeIfPresent(event.getPos(), (pos, set) -> {
                        set.forEach(listener -> listener.onBlockUpdate(world, (BlockPos)pos));
                        return set;
                    });
                    return posMap;
                });
                return chunkMap;
            });
        }
    }

    public static interface IListener {
        public void onBlockUpdate(ServerWorld var1, BlockPos var2);

        public void onChunkUnloaded(ServerWorld var1, BlockPos var2);

        public void onWorldUnloaded(ServerWorld var1, BlockPos var2);
    }
}

