/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.content.world;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.config.Config;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.mutable.MutableInt;

public class GreenHouse {
    private final Map<ChunkPos, Part> parts;
    private final Properties properties;

    public GreenHouse(Map<BlockPos, BlockType> blocks) {
        BlockPos.Mutable min = new BlockPos.Mutable(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        BlockPos.Mutable max = new BlockPos.Mutable(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        MutableInt interiorCounter = new MutableInt(0);
        MutableInt ceilingCounter = new MutableInt(0);
        MutableInt ceilingGlassCounter = new MutableInt(0);
        this.parts = blocks.entrySet().stream().collect(Collectors.toMap(entry -> new ChunkPos((BlockPos)entry.getKey()), entry -> GreenHouse.handleMapEntry(entry, !blocks.containsKey(((BlockPos)entry.getKey()).func_177984_a()), min, max, interiorCounter, ceilingCounter, ceilingGlassCounter), GreenHouse::mergeMaps)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new Part(this, (ChunkPos)entry.getKey(), (Map)entry.getValue())));
        this.properties = new Properties((BlockPos)min, (BlockPos)max, interiorCounter.getValue(), ceilingCounter.getValue(), ceilingGlassCounter.getValue());
    }

    public boolean isValid() {
        return this.parts.values().stream().noneMatch(Part::hasGaps) && this.getCeilingGlassFraction() >= ((Config)AgriCraft.instance.getConfig()).greenHouseCeilingGlassFraction();
    }

    protected Properties getProperties() {
        return this.properties;
    }

    public BlockPos getMin() {
        return this.getProperties().getMin();
    }

    public BlockPos getMax() {
        return this.getProperties().getMax();
    }

    public double getCeilingGlassFraction() {
        return ((double)this.getProperties().getCeilingGlassCount() + 0.0) / (double)this.getProperties().getCeilingCount();
    }

    public Set<ChunkPos> getChunks() {
        return this.parts.keySet();
    }

    public Part getPart(BlockPos pos) {
        return this.getPart(new ChunkPos(pos));
    }

    public Part getPart(ChunkPos pos) {
        return this.parts.get(pos);
    }

    public BlockType getType(BlockPos pos) {
        if (this.isInRange(pos)) {
            return this.getPart(pos).getType(pos);
        }
        return BlockType.EXTERIOR;
    }

    public boolean isInside(BlockPos pos) {
        return this.getType(pos).isInterior();
    }

    public void convertAirBlocks(World world) {
        this.parts.values().forEach(part -> part.replaceAirBlocks(world));
    }

    protected boolean isInRange(BlockPos pos) {
        return pos.func_177958_n() >= this.getMin().func_177958_n() && pos.func_177958_n() <= this.getMax().func_177958_n() && pos.func_177956_o() >= this.getMin().func_177956_o() && pos.func_177956_o() <= this.getMax().func_177956_o() && pos.func_177952_p() >= this.getMin().func_177952_p() && pos.func_177952_p() <= this.getMax().func_177952_p();
    }

    private static Map<BlockPos, Block> handleMapEntry(Map.Entry<BlockPos, BlockType> entry, boolean ceiling, BlockPos.Mutable min, BlockPos.Mutable max, MutableInt interiorCounter, MutableInt ceilingCounter, MutableInt ceilingGlassCounter) {
        HashMap map = Maps.newHashMap();
        map.put(entry.getKey(), new Block(entry.getKey(), entry.getValue(), ceiling));
        if (entry.getValue().isInterior()) {
            interiorCounter.increment();
        }
        if (ceiling) {
            ceilingCounter.increment();
            if (entry.getValue().isGlass()) {
                ceilingGlassCounter.increment();
            }
        }
        min.func_181079_c(Math.min(entry.getKey().func_177958_n(), min.func_177958_n()), Math.min(entry.getKey().func_177956_o(), min.func_177956_o()), Math.min(entry.getKey().func_177952_p(), min.func_177952_p()));
        max.func_181079_c(Math.max(entry.getKey().func_177958_n(), max.func_177958_n()), Math.max(entry.getKey().func_177956_o(), max.func_177956_o()), Math.max(entry.getKey().func_177952_p(), max.func_177952_p()));
        return map;
    }

    private static Map<BlockPos, Block> mergeMaps(Map<BlockPos, Block> a, Map<BlockPos, Block> b) {
        a.putAll(b);
        return a;
    }

    public static enum BlockType {
        INTERIOR_AIR(true, false),
        INTERIOR_OTHER(true, false),
        BOUNDARY(false, true),
        GLASS(false, true),
        EXTERIOR(false, false);

        private final boolean interior;
        private final boolean boundary;

        private BlockType(boolean interior, boolean boundary) {
            this.interior = interior;
            this.boundary = boundary;
        }

        public boolean isAir() {
            return this == INTERIOR_AIR;
        }

        public boolean isInterior() {
            return this.interior;
        }

        public boolean isBoundary() {
            return this.boundary;
        }

        public boolean isGlass() {
            return this == GLASS;
        }

        public boolean isExterior() {
            return this == EXTERIOR;
        }
    }

    protected static class Properties {
        private BlockPos min;
        private BlockPos max;
        private int interiorCount;
        private int ceilingCount;
        private int ceilingGlassCount;

        public Properties(BlockPos min, BlockPos max, int interiorCount, int ceilingCount, int ceilingGlassCount) {
            this.min = min.func_185334_h();
            this.max = max.func_185334_h();
            this.interiorCount = interiorCount;
            this.ceilingCount = ceilingCount;
            this.ceilingGlassCount = ceilingGlassCount;
        }

        public BlockPos getMin() {
            return this.min;
        }

        public BlockPos getMax() {
            return this.max;
        }

        public int getInteriorCount() {
            return this.interiorCount;
        }

        public int getCeilingCount() {
            return this.ceilingCount;
        }

        public int getCeilingGlassCount() {
            return this.ceilingGlassCount;
        }
    }

    protected static class Block {
        private final BlockPos pos;
        private final BlockType type;
        private final boolean ceiling;

        protected Block(BlockPos pos, BlockType type, boolean ceiling) {
            this.pos = pos;
            this.type = type;
            this.ceiling = ceiling;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public BlockType getType() {
            return this.type;
        }

        public boolean isCeiling() {
            return this.ceiling;
        }
    }

    public static class Part {
        private final GreenHouse greenHouse;
        private final ChunkPos chunk;
        private final Map<BlockPos, Block> blocks;
        private final Set<BlockPos> gaps;

        protected Part(GreenHouse greenHouse, ChunkPos chunk, Map<BlockPos, Block> blocks) {
            this.blocks = blocks;
            this.greenHouse = greenHouse;
            this.chunk = chunk;
            this.gaps = Sets.newHashSet();
        }

        public GreenHouse getGreenHouse() {
            return this.greenHouse;
        }

        public ChunkPos getChunk() {
            return this.chunk;
        }

        public BlockType getType(BlockPos pos) {
            Block block = this.getBlock(pos);
            return block == null ? BlockType.EXTERIOR : block.getType();
        }

        @Nullable
        public Block getBlock(BlockPos pos) {
            return this.blocks.getOrDefault(pos, null);
        }

        public boolean hasGaps() {
            return this.gaps.size() > 0;
        }

        protected void replaceAirBlocks(World world) {
            BlockState air = AgriCraft.instance.getModBlockRegistry().greenhouse_air.func_176223_P();
            this.blocks.values().stream().filter(block -> block.getType().isAir()).map(Block::getPos).forEach(pos -> world.func_175656_a(pos, air));
        }

        public CompoundNBT writeToTag() {
            CompoundNBT tag = new CompoundNBT();
            return tag;
        }
    }
}

