/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.content.irrigation;

import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.content.irrigation.TileEntityIrrigationChannel;
import com.infinityraider.agricraft.proxy.IProxy;
import com.infinityraider.agricraft.render.blocks.TileEntitySprinklerRenderer;
import com.infinityraider.infinitylib.block.tile.InfinityTileEntityType;
import com.infinityraider.infinitylib.block.tile.TileEntityBase;
import com.infinityraider.infinitylib.block.tile.TileEntityDynamicTexture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TileEntitySprinkler
extends TileEntityDynamicTexture
implements ITickableTileEntity {
    private static final int WORK_HEIGHT = 5;
    private static final int WORK_RADIUS = 3;
    private static final int WORK_DIAMETER = 7;
    private static final int WORK_AREA = 49;
    private static final int WORK_COOLDOWN = 20;
    private static final int ROTATION_SPEED = 9;
    private TileEntityIrrigationChannel channel;
    private final TileEntityBase.AutoSyncedField<Boolean> active = this.getAutoSyncedFieldBuilder(false).build();
    private int buffer;
    private int columnCounter;
    private int remainingWater;
    private int remainingTicks;
    private int angle;
    private int prevAngle;
    private int particleCounter;

    public TileEntitySprinkler() {
        super(AgriCraft.instance.getModTileRegistry().sprinkler);
    }

    public boolean isActive() {
        return (Boolean)this.active.get();
    }

    public void func_73660_a() {
        if (this.func_145831_w() == null) {
            return;
        }
        if (!this.func_145831_w().func_201670_d()) {
            this.pullWater();
            this.runSprinklerLogic();
        }
        this.prevAngle = this.angle;
        if (this.isActive()) {
            this.angle = (this.angle + 9) % 360;
            if (this.func_145831_w().func_201670_d()) {
                this.spawnSprinklerParticles();
            }
        }
    }

    public int getAngle() {
        return this.angle;
    }

    public float getAngle(float partialTick) {
        return MathHelper.func_219799_g((float)partialTick, (float)this.prevAngle, (float)this.getAngle());
    }

    @Nullable
    public TileEntityIrrigationChannel getChannel() {
        if (this.channel == null) {
            if (this.func_145831_w() == null) {
                return null;
            }
            TileEntity tile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177984_a());
            if (tile instanceof TileEntityIrrigationChannel) {
                this.channel = (TileEntityIrrigationChannel)tile;
            }
        }
        return this.channel;
    }

    protected void pullWater() {
        TileEntityIrrigationChannel channel = this.getChannel();
        if (channel == null) {
            return;
        }
        this.buffer += channel.drainWater(Math.max(this.getBufferSize() - this.buffer, 0), true);
    }

    protected void runSprinklerLogic() {
        boolean currentActiveness;
        if (this.remainingTicks <= 0 || this.remainingWater < 0) {
            this.remainingWater = Math.abs(((Config)AgriCraft.instance.getConfig()).sprinklerWaterConsumption());
            this.remainingTicks = 20;
        }
        int waterUsageThisTick = this.remainingWater / this.remainingTicks;
        this.remainingWater -= waterUsageThisTick;
        --this.remainingTicks;
        boolean bl = currentActiveness = this.buffer >= waterUsageThisTick && this.buffer > 0;
        if (currentActiveness != this.isActive()) {
            this.active.set((Object)currentActiveness);
        }
        if (!this.isActive()) {
            return;
        }
        this.buffer -= waterUsageThisTick;
        if (this.columnCounter >= 0 && this.columnCounter < 49) {
            this.irrigateCurrentColumn();
        }
        ++this.columnCounter;
        if (this.columnCounter >= 49 && this.columnCounter >= ((Config)AgriCraft.instance.getConfig()).sprinkleInterval() || this.columnCounter < 0) {
            this.columnCounter = 0;
        }
    }

    protected void irrigateCurrentColumn() {
        int targetX = this.field_174879_c.func_177958_n() - 3 + this.columnCounter % 7;
        int targetZ = this.field_174879_c.func_177952_p() - 3 + this.columnCounter / 7;
        int startY = this.field_174879_c.func_177956_o() - 1;
        int stopY = Math.max(this.field_174879_c.func_177956_o() - 5, 0);
        this.irrigateColumn(targetX, targetZ, startY, stopY);
    }

    protected void irrigateColumn(int targetX, int targetZ, int highestY, int lowestY) {
        if (this.func_145831_w() == null || !(this.func_145831_w() instanceof ServerWorld)) {
            return;
        }
        for (int targetY = highestY; targetY >= lowestY; --targetY) {
            BlockPos target = new BlockPos(targetX, targetY, targetZ);
            BlockState state = this.func_145831_w().func_180495_p(target);
            Block block = state.func_177230_c();
            if (block.isAir(state, (IBlockReader)this.func_145831_w(), target)) continue;
            if ((block instanceof IPlantable || block instanceof IGrowable) && targetY != lowestY) {
                if (!(this.getRandom().nextDouble() < ((Config)AgriCraft.instance.getConfig()).sprinkleGrowthChance())) continue;
                block.func_225542_b_(state, (ServerWorld)this.func_145831_w(), target, this.getRandom());
                continue;
            }
            if (!(block instanceof FarmlandBlock) || (Integer)state.func_177229_b((Property)FarmlandBlock.field_176531_a) >= 7) break;
            this.func_145831_w().func_180501_a(target, (BlockState)state.func_206870_a((Property)FarmlandBlock.field_176531_a, (Comparable)Integer.valueOf(7)), 2);
            break;
        }
    }

    protected int getBufferSize() {
        return 2 * ((Config)AgriCraft.instance.getConfig()).sprinklerWaterConsumption();
    }

    protected void spawnSprinklerParticles() {
        if (this.func_145831_w() == null) {
            return;
        }
        boolean vapour = this.func_145831_w().func_230315_m_().func_236040_e_();
        int particleSetting = ((IProxy)AgriCraft.instance.proxy()).getParticleSetting();
        this.particleCounter = (this.particleCounter + 1) % (particleSetting += vapour ? 6 : 2);
        if (this.particleCounter == 0) {
            double x = (double)this.func_174877_v().func_177958_n() + 0.5;
            double y = (double)this.func_174877_v().func_177956_o() + 0.35;
            double z = (double)this.func_174877_v().func_177952_p() + 0.5;
            for (int i = 0; i < 4; ++i) {
                Object particle;
                float alpha = (float)(-(this.angle + 90 * i)) * (float)Math.PI / 180.0f;
                float cosA = MathHelper.func_76134_b((float)alpha);
                float sinA = MathHelper.func_76126_a((float)alpha);
                double xOffset = 0.25f * cosA;
                double zOffset = 0.25f * sinA;
                float radius = 0.35f;
                if (vapour) {
                    particle = ParticleTypes.field_197613_f;
                    this.func_145831_w().func_195594_a((IParticleData)particle, x + xOffset, y, z + zOffset, 0.15 * (double)cosA, 0.25, 0.15 * (double)sinA);
                    continue;
                }
                particle = AgriCraft.instance.getModParticleRegistry().sprinkler.createParticleData((Fluid)Fluids.field_204546_a, 0.2f, 0.7f);
                for (int j = 0; j <= 4; ++j) {
                    float beta = (float)(-j) * (float)Math.PI / 8.0f;
                    this.func_145831_w().func_195594_a((IParticleData)particle, x + xOffset * (double)(4 - j) / 4.0, y, z + zOffset * (double)(4 - j) / 4.0, (double)(radius * cosA), (double)radius * Math.sin(beta), (double)(radius * sinA));
                }
            }
            if (vapour) {
                this.func_145831_w().func_184133_a(AgriCraft.instance.getClientPlayer(), this.func_174877_v(), SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (this.func_145831_w().func_201674_k().nextFloat() - this.func_145831_w().func_201674_k().nextFloat()) * 0.8f);
            }
        }
    }

    protected void writeTileNBT(@Nonnull CompoundNBT tag) {
        tag.func_74768_a("agri_connections", this.buffer);
        tag.func_74768_a("agri_key", this.columnCounter);
        tag.func_74768_a("agri_level", this.remainingWater);
        tag.func_74768_a("agri_entries", this.remainingTicks);
    }

    protected void readTileNBT(@Nonnull BlockState state, @Nonnull CompoundNBT tag) {
        this.buffer = tag.func_74762_e("agri_connections");
        this.columnCounter = tag.func_74762_e("agri_key");
        this.remainingWater = tag.func_74762_e("agri_level");
        this.remainingTicks = tag.func_74762_e("agri_entries");
    }

    public static RenderFactory createRenderFactory() {
        return new RenderFactory();
    }

    private static class RenderFactory
    implements InfinityTileEntityType.IRenderFactory<TileEntitySprinkler> {
        private RenderFactory() {
        }

        @Nullable
        @OnlyIn(value=Dist.CLIENT)
        public TileEntitySprinklerRenderer createRenderer() {
            return new TileEntitySprinklerRenderer();
        }
    }
}

