/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.content.irrigation;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.content.irrigation.BlockIrrigationChannelAbstract;
import com.infinityraider.agricraft.content.irrigation.BlockIrrigationTank;
import com.infinityraider.agricraft.content.irrigation.TileEntityIrrigationChannel;
import com.infinityraider.agricraft.content.irrigation.TileEntityIrrigationComponent;
import com.infinityraider.agricraft.render.blocks.TileEntityIrrigationTankRenderer;
import com.infinityraider.infinitylib.block.tile.InfinityTileEntityType;
import com.infinityraider.infinitylib.block.tile.TileEntityBase;
import com.infinityraider.infinitylib.utility.TileReference;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TileEntityIrrigationTank
extends TileEntityIrrigationComponent
implements IFluidHandler {
    private static final BlockPos DEFAULT = new BlockPos(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    private static final BiFunction<IWorldReader, BlockPos, TileEntityIrrigationTank> TANK_GETTER = (world, pos) -> {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityIrrigationTank) {
            return (TileEntityIrrigationTank)tile;
        }
        return null;
    };
    private static final float MIN_Y = 0.125f;
    private static final float MAX_Y = 1.0f;
    private static final int HEIGHT_INTERVALS = 16;
    private static final float CONTENT_DELTA_FRACTION = 0.05f;
    private TileReference<TileEntityIrrigationTank> origin;
    private final TileEntityBase.AutoSyncedField<BlockPos> min = this.getAutoSyncedFieldBuilder(DEFAULT).build();
    private final TileEntityBase.AutoSyncedField<BlockPos> max = this.getAutoSyncedFieldBuilder(DEFAULT).build();
    private final LazyOptional<IFluidHandler> capability = LazyOptional.of(() -> this);

    public TileEntityIrrigationTank() {
        super(AgriCraft.instance.getModTileRegistry().irrigation_tank, ((Config)AgriCraft.instance.getConfig()).tankCapacity(), 0.125f, 1.0f);
    }

    public BlockIrrigationTank getBlock() {
        return AgriCraft.instance.getModBlockRegistry().tank;
    }

    public BlockPos getMultiBlockMin() {
        return (BlockPos)this.min.get();
    }

    public BlockPos getMultiBlockMax() {
        return (BlockPos)this.max.get();
    }

    public boolean isMultiBlockOrigin() {
        BlockPos origin = this.getMultiBlockMin();
        return DEFAULT.equals((Object)origin) || this.func_174877_v().equals((Object)origin);
    }

    @Override
    protected void tickComponent() {
    }

    @Override
    protected void runNetherLogic() {
        if (this.func_174877_v().func_177956_o() == (int)this.getLevel()) {
            super.runNetherLogic();
        } else if (this.func_174877_v().func_177956_o() == this.getMultiBlockMax().func_177956_o() && this.getContent() == this.getCapacity()) {
            super.runNetherLogic();
        }
    }

    @Override
    protected float getNetherEvaporationRate() {
        return super.getNetherEvaporationRate() * (float)super.getCapacity() / (float)this.getCapacity();
    }

    @Override
    public int getContent() {
        if (this.isMultiBlockOrigin()) {
            return super.getContent();
        }
        TileEntityIrrigationTank origin = this.getMultiBlockOrigin();
        if (origin != null) {
            return origin.getContent();
        }
        return 0;
    }

    @Override
    public float getLevel() {
        if (this.isMultiBlockOrigin()) {
            return super.getLevel();
        }
        TileEntityIrrigationTank origin = this.getMultiBlockOrigin();
        if (origin != null) {
            return origin.getLevel();
        }
        return 0.0f;
    }

    @Override
    public float getRenderLevel(float partialTicks) {
        if (this.isMultiBlockOrigin()) {
            float level = super.getRenderLevel(partialTicks);
            if (level == this.getMaxLevel()) {
                level -= 1.0E-4f;
            }
            return level;
        }
        TileEntityIrrigationTank origin = this.getMultiBlockOrigin();
        if (origin != null) {
            return origin.getRenderLevel(partialTicks);
        }
        return 0.0f;
    }

    @Override
    public int pushWater(int max, boolean execute) {
        if (this.isMultiBlockOrigin()) {
            return super.pushWater(max, execute);
        }
        TileEntityIrrigationTank origin = this.getMultiBlockOrigin();
        if (origin != null) {
            return origin.pushWater(max, execute);
        }
        return 0;
    }

    @Override
    public int drainWater(int max, boolean execute) {
        if (this.isMultiBlockOrigin()) {
            return super.drainWater(max, execute);
        }
        TileEntityIrrigationTank origin = this.getMultiBlockOrigin();
        if (origin != null) {
            return origin.drainWater(max, execute);
        }
        return 0;
    }

    @Override
    protected void setContent(int content) {
        if (this.isMultiBlockOrigin()) {
            float before = this.getLevel();
            super.setContent(content);
            this.updateMultiBlockFluidStates(before, this.getLevel());
        } else {
            TileEntityIrrigationTank origin = this.getMultiBlockOrigin();
            if (origin != null) {
                origin.setContent(content);
            }
        }
    }

    @Override
    protected void setLevel(float level) {
        if (this.isMultiBlockOrigin()) {
            float before = this.getLevel();
            super.setLevel(level);
            this.updateMultiBlockFluidStates(before, this.getLevel());
        } else {
            TileEntityIrrigationTank origin = this.getMultiBlockOrigin();
            if (origin != null) {
                this.getMultiBlockOrigin().setLevel(level);
            }
        }
    }

    @Override
    public int getCapacity() {
        return super.getCapacity() * (this.getMultiBlockMax().func_177958_n() - this.getMultiBlockMin().func_177958_n() + 1) * (this.getMultiBlockMax().func_177956_o() - this.getMultiBlockMin().func_177956_o() + 1) * (this.getMultiBlockMax().func_177952_p() - this.getMultiBlockMin().func_177952_p() + 1);
    }

    @Override
    public float getMinLevel() {
        return 0.125f + (float)this.getMultiBlockMin().func_177956_o();
    }

    @Override
    public float getMaxLevel() {
        return 1.0f + (float)this.getMultiBlockMax().func_177956_o();
    }

    @Override
    protected int calculateContents(float height) {
        return (int)((float)this.getCapacity() * (height + (float)this.getMultiBlockMin().func_177956_o() - this.getMinLevel()) / (this.getMaxLevel() - this.getMinLevel()));
    }

    @Override
    protected float calculateHeight(int contents) {
        return this.getMinLevel() - (float)this.getMultiBlockMin().func_177956_o() + ((float)contents + 0.0f) * (this.getMaxLevel() - this.getMinLevel()) / ((float)this.getCapacity() + 0.0f);
    }

    @Nullable
    public TileEntityIrrigationTank getMultiBlockOrigin() {
        if (this.func_145831_w() == null) {
            return this;
        }
        if (this.isMultiBlockOrigin()) {
            return this;
        }
        if (this.origin == null) {
            this.origin = new TileReference(this.getMultiBlockMin(), TANK_GETTER);
        }
        TileEntityIrrigationTank tank = (TileEntityIrrigationTank)this.origin.getTile((IWorldReader)this.field_145850_b);
        if (this.origin.isRemoved()) {
            this.unFormMultiBlock();
            return this;
        }
        if (this.origin.isUnloaded()) {
            return null;
        }
        return tank;
    }

    public void checkAndFormMultiBlock() {
        if (this.func_145831_w() == null || this.func_145831_w().func_201670_d()) {
            return;
        }
        this.min.set((Object)this.func_174877_v());
        this.max.set((Object)this.func_174877_v());
        new MultiBlockFormer(this).formMultiBlock();
    }

    public void onNeighbourChanged(BlockPos fromPos) {
        if (this.func_145831_w() == null) {
            return;
        }
        if (this.isInMultiBlock(fromPos)) {
            TileEntityIrrigationTank tank;
            TileEntity tile = this.func_145831_w().func_175625_s(fromPos);
            if (tile instanceof TileEntityIrrigationTank && (tank = (TileEntityIrrigationTank)tile).isSameMaterial((TileEntity)this) && tank.getMultiBlockMin().equals((Object)this.getMultiBlockMin()) && tank.getMultiBlockMax().equals((Object)this.getMultiBlockMax())) {
                return;
            }
            this.unFormMultiBlock();
        }
    }

    public boolean isInMultiBlock(BlockPos pos) {
        BlockPos min = this.getMultiBlockMin();
        BlockPos max = this.getMultiBlockMax();
        return pos.func_177958_n() >= min.func_177958_n() && pos.func_177956_o() >= min.func_177956_o() && pos.func_177952_p() >= min.func_177952_p() && pos.func_177958_n() <= max.func_177958_n() && pos.func_177956_o() <= max.func_177956_o() && pos.func_177952_p() <= max.func_177952_p();
    }

    public void unFormMultiBlock() {
        if (this.func_145831_w() == null) {
            return;
        }
        float level = this.getLevel();
        BlockPos min = new BlockPos((Vector3i)this.getMultiBlockMin());
        BlockPos max = new BlockPos((Vector3i)this.getMultiBlockMax());
        BlockPos.Mutable pos = new BlockPos.Mutable(0, 0, 0);
        for (int x = min.func_177958_n(); x <= max.func_177958_n(); ++x) {
            for (int y = min.func_177956_o(); y <= max.func_177956_o(); ++y) {
                for (int z = min.func_177952_p(); z <= max.func_177952_p(); ++z) {
                    pos.func_181079_c(x, y, z);
                    TileEntity tile = this.func_145831_w().func_175625_s((BlockPos)pos);
                    if (!(tile instanceof TileEntityIrrigationTank)) continue;
                    TileEntityIrrigationTank tank = (TileEntityIrrigationTank)tile;
                    tank.origin = null;
                    tank.min.set((Object)tank.func_174877_v());
                    tank.max.set((Object)tank.func_174877_v());
                    this.func_145831_w().func_175656_a(tank.func_174877_v(), AgriCraft.instance.getModBlockRegistry().tank.func_176223_P());
                    tank.setLevel(level);
                }
            }
        }
    }

    protected void updateMultiBlockFluidStates(float before, float after) {
        World world = this.func_145831_w();
        if (world == null || world.func_201670_d()) {
            return;
        }
        float d1 = Math.min(before, after);
        float d2 = Math.max(before, after);
        float delta = d2 - d1;
        if (delta < 1.0f) {
            d1 -= (float)((int)d1);
            d2 -= (float)((int)d2);
            if ((double)d1 >= 0.5 || (double)d2 < 0.5) {
                return;
            }
        }
        BlockPos min = this.getMultiBlockMin();
        BlockPos max = this.getMultiBlockMax();
        int y1 = Math.max((int)d1, min.func_177956_o());
        int y2 = Math.min(1 + (int)d2, max.func_177956_o());
        BlockPos.Mutable pos = new BlockPos.Mutable(0, 0, 0);
        for (int x = min.func_177958_n(); x <= max.func_177958_n(); ++x) {
            for (int y = y1; y <= y2; ++y) {
                for (int z = min.func_177952_p(); z <= max.func_177952_p(); ++z) {
                    pos.func_181079_c(x, y, z);
                    this.getBlock().updateFluidState(this.func_145831_w(), (BlockPos)pos, world.func_180495_p((BlockPos)pos), after);
                }
            }
        }
    }

    @Override
    protected boolean canConnect(TileEntityIrrigationComponent other) {
        return other instanceof TileEntityIrrigationChannel && other.isSameMaterial((TileEntity)this);
    }

    @Override
    protected boolean canTransfer(TileEntityIrrigationComponent other, Direction dir) {
        return this.canConnect(other);
    }

    @Override
    protected int getLevelIntervalCount() {
        return 16;
    }

    @Override
    protected float getContentDeltaFraction() {
        return 0.05f;
    }

    @Override
    protected String description() {
        return "Tank";
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return tank == 0 ? new FluidStack((Fluid)Fluids.field_204546_a, this.getContent()) : FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        return tank == 0 ? this.getCapacity() : 0;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return tank == 0 && stack.getFluid() == Fluids.field_204546_a;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return resource.getFluid() == Fluids.field_204546_a ? this.pushWater(resource.getAmount(), action.execute()) : 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return resource.getFluid() == Fluids.field_204546_a ? this.drain(resource.getAmount(), action) : FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        int drained = this.drainWater(maxDrain, action.execute());
        return drained > 0 ? new FluidStack((Fluid)Fluids.field_204546_a, drained) : FluidStack.EMPTY;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.capability.cast();
        }
        return super.getCapability(cap, side);
    }

    public static RenderFactory createRenderFactory() {
        return new RenderFactory();
    }

    private static class RenderFactory
    implements InfinityTileEntityType.IRenderFactory<TileEntityIrrigationTank> {
        private RenderFactory() {
        }

        @Nullable
        @OnlyIn(value=Dist.CLIENT)
        public TileEntityIrrigationTankRenderer createRenderer() {
            return new TileEntityIrrigationTankRenderer();
        }
    }

    public static class MultiBlockFormer {
        private final World world;
        private final ItemStack material;
        private final BlockPos.Mutable min;
        private final BlockPos.Mutable max;
        private final Set<Unchecked> unchecked;
        private final Map<BlockPos, Checked> checked;

        protected MultiBlockFormer(TileEntityIrrigationTank tank) {
            this.world = Objects.requireNonNull(tank.func_145831_w(), "Invalid state, can not form multi-block with non-world tile entity");
            this.material = tank.getMaterial().func_77946_l();
            this.min = tank.func_174877_v().func_239590_i_();
            this.max = tank.func_174877_v().func_239590_i_();
            this.unchecked = Sets.newConcurrentHashSet();
            this.checked = Maps.newHashMap();
            this.unchecked.add(new Unchecked((TileEntity)tank));
        }

        public final World getWorld() {
            return this.world;
        }

        public final boolean checkMaterial(ItemStack material) {
            return ItemStack.func_179545_c((ItemStack)this.material, (ItemStack)material);
        }

        public void formMultiBlock() {
            if (!this.scanRegion()) {
                return;
            }
            int counter = 0;
            for (int x = this.min.func_177958_n(); x <= this.max.func_177958_n(); ++x) {
                for (int y = this.min.func_177956_o(); y <= this.max.func_177956_o(); ++y) {
                    for (int z = this.min.func_177952_p(); z <= this.max.func_177952_p(); ++z) {
                        TileEntityIrrigationTank tank2 = this.checked.get(new BlockPos(x, y, z)).getTank();
                        tank2.unFormMultiBlock();
                        counter += tank2.getContent();
                        tank2.setContent(0);
                        tank2.min.set((Object)new BlockPos((Vector3i)this.min));
                        tank2.max.set((Object)new BlockPos((Vector3i)this.max));
                        BlockState state = tank2.func_195044_w();
                        state = this.handleDirection(state, tank2, Direction.WEST, x == this.min.func_177958_n());
                        state = this.handleDirection(state, tank2, Direction.EAST, x == this.max.func_177958_n());
                        state = this.handleDirection(state, tank2, Direction.DOWN, y == this.min.func_177956_o());
                        state = this.handleDirection(state, tank2, Direction.NORTH, z == this.min.func_177952_p());
                        state = this.handleDirection(state, tank2, Direction.SOUTH, z == this.max.func_177952_p());
                        this.getWorld().func_175656_a(tank2.func_174877_v(), state);
                    }
                }
            }
            int contents = counter;
            this.checked.values().stream().findAny().map(Checked::getTank).ifPresent(tank -> tank.setContent(contents));
        }

        protected boolean scanRegion() {
            Iterator<Unchecked> iterator = this.unchecked.iterator();
            while (iterator.hasNext()) {
                Unchecked next = iterator.next();
                iterator.remove();
                BlockPos pos = next.getPos();
                boolean stop = next.check(this).map(checked -> {
                    this.checked.put(pos, (Checked)checked);
                    this.expand(checked.getTank());
                    Arrays.stream(Direction.values()).forEach(dir -> this.scanPos(pos.func_177972_a(dir)));
                    return false;
                }).orElse(true);
                if (!stop) continue;
                return false;
            }
            if (this.unchecked.size() > 0) {
                return this.scanRegion();
            }
            return true;
        }

        protected void scanPos(BlockPos pos) {
            if (this.checked.containsKey(pos)) {
                return;
            }
            Unchecked unchecked = new Unchecked(this, pos);
            if (this.unchecked.contains(unchecked)) {
                return;
            }
            if (unchecked.isValid(this)) {
                this.unchecked.add(unchecked);
            }
        }

        protected void expand(TileEntityIrrigationTank tank) {
            this.expand(tank.getMultiBlockMin());
            this.expand(tank.getMultiBlockMax());
        }

        protected void expand(BlockPos pos) {
            if (this.max.func_177958_n() < pos.func_177958_n()) {
                this.addSites(this.max.func_177958_n() + 1, this.min.func_177956_o(), this.min.func_177952_p(), pos.func_177958_n(), this.max.func_177956_o(), this.max.func_177952_p());
                this.max.func_181079_c(pos.func_177958_n(), this.max.func_177956_o(), this.max.func_177952_p());
            }
            if (this.max.func_177956_o() < pos.func_177956_o()) {
                this.addSites(this.min.func_177958_n(), this.max.func_177956_o() + 1, this.min.func_177952_p(), this.max.func_177958_n(), pos.func_177956_o(), this.max.func_177952_p());
                this.max.func_181079_c(this.max.func_177958_n(), pos.func_177956_o(), this.max.func_177952_p());
            }
            if (this.max.func_177952_p() < pos.func_177952_p()) {
                this.addSites(this.min.func_177958_n(), this.min.func_177956_o(), this.max.func_177952_p() + 1, this.max.func_177958_n(), this.max.func_177956_o(), pos.func_177952_p());
                this.max.func_181079_c(this.max.func_177958_n(), this.max.func_177956_o(), pos.func_177952_p());
            }
            if (this.min.func_177958_n() > pos.func_177958_n()) {
                this.addSites(pos.func_177958_n(), this.min.func_177956_o(), this.min.func_177952_p(), this.min.func_177958_n() - 1, this.max.func_177956_o(), this.max.func_177952_p());
                this.min.func_181079_c(pos.func_177958_n(), this.min.func_177956_o(), this.min.func_177952_p());
            }
            if (this.min.func_177956_o() > pos.func_177956_o()) {
                this.addSites(this.min.func_177958_n(), pos.func_177956_o(), this.min.func_177952_p(), this.max.func_177958_n(), this.min.func_177956_o() - 1, this.max.func_177952_p());
                this.min.func_181079_c(this.min.func_177958_n(), pos.func_177956_o(), this.min.func_177952_p());
            }
            if (this.min.func_177952_p() > pos.func_177952_p()) {
                this.addSites(this.min.func_177958_n(), this.min.func_177956_o(), pos.func_177952_p(), this.max.func_177958_n(), this.max.func_177956_o(), this.min.func_177952_p() - 1);
                this.min.func_181079_c(this.min.func_177958_n(), this.min.func_177956_o(), pos.func_177952_p());
            }
        }

        protected void addSites(int x1, int y1, int z1, int x2, int y2, int z2) {
            for (int x = x1; x <= x2; ++x) {
                for (int y = y1; y <= y2; ++y) {
                    for (int z = z1; z <= z2; ++z) {
                        BlockPos pos = new BlockPos(x, y, z);
                        if (this.checked.containsKey(pos)) continue;
                        this.unchecked.add(new Unchecked(this, pos));
                    }
                }
            }
        }

        protected BlockState handleDirection(BlockState state, TileEntityIrrigationTank tank, Direction dir, boolean edge) {
            if (tank.func_145831_w() == null || tank.func_145831_w().func_201670_d()) {
                return state;
            }
            if (dir.func_176740_k().func_200128_b()) {
                return BlockIrrigationTank.DOWN.apply(state, (Comparable)Boolean.valueOf(!edge));
            }
            return BlockIrrigationTank.getConnection(dir).map(connection -> {
                if (edge) {
                    BlockPos offset = tank.func_174877_v().func_177972_a(dir);
                    TileEntity tile = tank.func_145831_w().func_175625_s(offset);
                    if (tile instanceof TileEntityIrrigationChannel && ((TileEntityIrrigationChannel)tile).canConnect(tank)) {
                        BlockIrrigationChannelAbstract.getConnection(dir.func_176734_d()).ifPresent(channelCon -> tank.func_145831_w().func_175656_a(offset, channelCon.apply(tile.func_195044_w(), (Comparable)Boolean.valueOf(true))));
                        return connection.apply(state, (Comparable)((Object)BlockIrrigationTank.Connection.CHANNEL));
                    }
                } else {
                    return connection.apply(state, (Comparable)((Object)BlockIrrigationTank.Connection.TANK));
                }
                return connection.apply(state, (Comparable)((Object)BlockIrrigationTank.Connection.NONE));
            }).orElse(state);
        }

        public static class Checked {
            private final TileEntityIrrigationTank tank;

            private Checked(TileEntityIrrigationTank tank) {
                this.tank = tank;
            }

            public TileEntityIrrigationTank getTank() {
                return this.tank;
            }
        }

        public static class Unchecked {
            private final BlockPos pos;
            private final TileEntity tile;

            public Unchecked(TileEntity tile) {
                this.pos = tile.func_174877_v();
                this.tile = tile;
            }

            public Unchecked(MultiBlockFormer former, BlockPos pos) {
                this.pos = pos;
                this.tile = former.getWorld().func_175625_s(pos);
            }

            public final BlockPos getPos() {
                return this.pos;
            }

            public boolean isValid(MultiBlockFormer former) {
                if (this.tile instanceof TileEntityIrrigationTank) {
                    TileEntityIrrigationTank tank = (TileEntityIrrigationTank)this.tile;
                    return former.checkMaterial(tank.getMaterial());
                }
                return false;
            }

            public Optional<Checked> check(MultiBlockFormer former) {
                return Optional.ofNullable(this.isValid(former) ? new Checked((TileEntityIrrigationTank)this.tile) : null);
            }

            public int hashCode() {
                return this.getPos().hashCode();
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj instanceof Unchecked) {
                    return this.getPos().equals((Object)((Unchecked)obj).getPos());
                }
                return false;
            }
        }
    }
}

