/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.content.irrigation;

import com.google.common.collect.ImmutableList;
import com.infinityraider.agricraft.content.irrigation.BlockIrrigationChannelAbstract;
import com.infinityraider.agricraft.content.irrigation.TileEntityIrrigationChannel;
import com.infinityraider.agricraft.content.irrigation.TileEntitySprinkler;
import com.infinityraider.infinitylib.block.BlockBaseTile;
import com.infinityraider.infinitylib.block.property.InfProperty;
import com.infinityraider.infinitylib.block.property.InfPropertyConfiguration;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlockSprinkler
extends BlockBaseTile<TileEntitySprinkler> {
    public static final InfProperty<Boolean> ACTIVE = InfProperty.Creators.create((String)"active", (boolean)false);
    public static final InfPropertyConfiguration PROPERTIES = InfPropertyConfiguration.builder().add(ACTIVE).build();
    private static final BiFunction<BlockState, IBlockReader, TileEntitySprinkler> TILE_FACTORY = (s, w) -> new TileEntitySprinkler();
    private static final VoxelShape SHAPE = Stream.of(Block.func_208617_a((double)5.0, (double)15.0, (double)5.0, (double)11.0, (double)21.0, (double)11.0), Block.func_208617_a((double)(8.0 - 0.74 * Math.sqrt(2.0)), (double)4.0, (double)(8.0 - 0.74 * Math.sqrt(2.0)), (double)(8.0 + 0.74 * Math.sqrt(2.0)), (double)15.0, (double)(8.0 + 0.74 * Math.sqrt(2.0)))).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();

    public BlockSprinkler() {
        super("sprinkler", AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d));
    }

    protected InfPropertyConfiguration getPropertyConfiguration() {
        return PROPERTIES;
    }

    public BiFunction<BlockState, IBlockReader, TileEntitySprinkler> getTileEntityFactory() {
        return TILE_FACTORY;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos;
        World world = context.func_195991_k();
        BlockState state = world.func_180495_p(pos = context.func_195995_a().func_177984_a());
        if (state.func_177230_c() instanceof BlockIrrigationChannelAbstract) {
            return this.func_176223_P();
        }
        return null;
    }

    public final void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (!world.func_201670_d()) {
            if (tile instanceof TileEntitySprinkler) {
                TileEntitySprinkler sprinkler = (TileEntitySprinkler)tile;
                TileEntity above = world.func_175625_s(pos.func_177984_a());
                if (above instanceof TileEntityIrrigationChannel) {
                    TileEntityIrrigationChannel channel = (TileEntityIrrigationChannel)above;
                    sprinkler.setMaterial(channel.getMaterial());
                    return;
                }
            }
            this.detachSprinkler(state, world, pos);
        }
    }

    @Deprecated
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (fromPos.func_177977_b().equals((Object)pos)) {
            this.detachSprinkler(state, world, pos);
        }
    }

    protected void detachSprinkler(BlockState state, World world, BlockPos pos) {
        world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        BlockSprinkler.func_220059_a((BlockState)state, (IWorld)world, (BlockPos)pos, (TileEntity)world.func_175625_s(pos));
    }

    @Deprecated
    public VoxelShape func_196247_c(BlockState state, IBlockReader world, BlockPos pos) {
        return this.func_220053_a(state, world, pos, ISelectionContext.func_216377_a());
    }

    @Deprecated
    public VoxelShape func_230335_e_(BlockState state, IBlockReader world, BlockPos pos) {
        return this.func_220071_b(state, world, pos, ISelectionContext.func_216377_a());
    }

    @Deprecated
    public VoxelShape func_199600_g(BlockState state, IBlockReader world, BlockPos pos) {
        return this.func_230322_a_(state, world, pos, ISelectionContext.func_216377_a());
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @Deprecated
    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, world, pos, context);
    }

    @Deprecated
    public VoxelShape func_230322_a_(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, world, pos, context);
    }

    @Nonnull
    @Deprecated
    public final List<ItemStack> func_220076_a(BlockState state, LootContext.Builder context) {
        return ImmutableList.of((Object)new ItemStack((IItemProvider)this));
    }
}

