/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.content.core;

import com.google.common.collect.Maps;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.content.core.BlockCropSticks;
import com.infinityraider.agricraft.content.core.TileEntityCropBase;
import com.infinityraider.infinitylib.block.tile.TileEntityBase;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class TileEntityCropSticks
extends TileEntityCropBase {
    private final TileEntityBase.AutoSyncedField<Boolean> crossCrop = this.getAutoSyncedFieldBuilder(false).withCallBack(status -> {
        if (this.func_145831_w() != null) {
            this.func_145831_w().func_175656_a(this.getPosition(), BlockCropSticks.CROSS_CROP.apply(this.func_195044_w(), (Comparable)status));
        }
    }).withRenderUpdate().build();
    private final Map<Direction, Optional<IAgriCrop>> neighbours = Maps.newEnumMap(Direction.class);
    private boolean needsCaching;

    public TileEntityCropSticks() {
        super(AgriCraft.instance.getModTileRegistry().crop_sticks);
        Direction.Plane.HORIZONTAL.func_239636_a_().forEach(dir -> this.neighbours.put((Direction)dir, Optional.empty()));
        this.needsCaching = true;
    }

    @Override
    public boolean hasCropSticks() {
        return true;
    }

    @Override
    public boolean isCrossCrop() {
        return (Boolean)this.crossCrop.get();
    }

    @Override
    public boolean setCrossCrop(boolean status) {
        if (this.hasPlant()) {
            return false;
        }
        if (this.hasWeeds()) {
            return false;
        }
        if (this.isCrossCrop() == status) {
            return false;
        }
        this.crossCrop.set((Object)status);
        return true;
    }

    @Override
    @Nonnull
    public Stream<IAgriCrop> streamNeighbours() {
        if (this.needsCaching) {
            this.readNeighbours();
        }
        return this.neighbours.values().stream().filter(Optional::isPresent).map(Optional::get).filter(IAgriCrop::hasCropSticks);
    }

    protected void readNeighbours() {
        if (this.func_145831_w() != null) {
            Direction.Plane.HORIZONTAL.func_239636_a_().forEach(dir -> this.neighbours.put((Direction)dir, AgriApi.getCrop((IBlockReader)this.func_145831_w(), this.func_174877_v().func_177972_a(dir))));
            this.needsCaching = false;
        }
    }

    protected void onNeighbourChange(Direction direction, BlockPos pos, BlockState newState) {
        if (newState.func_177230_c() instanceof BlockCropSticks) {
            if (this.func_145831_w() != null) {
                this.neighbours.put(direction, AgriApi.getCrop((IBlockReader)this.func_145831_w(), pos));
            }
        } else {
            this.neighbours.put(direction, Optional.empty());
        }
    }

    @Override
    protected void readTileNBT(@Nonnull BlockState state, @Nonnull CompoundNBT tag) {
        this.needsCaching = true;
    }
}

