/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.content.core;

import com.agricraft.agricore.util.TypeHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.content.items.IAgriClipperItem;
import com.infinityraider.agricraft.api.v1.content.items.IAgriRakeItem;
import com.infinityraider.agricraft.api.v1.content.items.IAgriTrowelItem;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.fertilizer.IAgriFertilizer;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenome;
import com.infinityraider.agricraft.api.v1.requirement.IAgriGrowthResponse;
import com.infinityraider.agricraft.content.core.BlockCropBase;
import com.infinityraider.agricraft.content.core.ItemDebugger;
import com.infinityraider.agricraft.content.core.TileEntityCropPlant;
import com.infinityraider.infinitylib.block.property.InfProperty;
import com.infinityraider.infinitylib.block.property.InfPropertyConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlockCropPlant
extends BlockCropBase<TileEntityCropPlant> {
    private static final Class<?>[] ITEM_EXCLUDES = new Class[]{IAgriRakeItem.class, IAgriClipperItem.class, IAgriTrowelItem.class, ItemDebugger.class};
    private static final InfPropertyConfiguration PROPERTIES = InfPropertyConfiguration.builder().add(PLANT).add(LIGHT).fluidloggable().build();
    private static final BiFunction<BlockState, IBlockReader, TileEntityCropPlant> TILE_FACTORY = (s, w) -> new TileEntityCropPlant();
    private static final Map<Integer, VoxelShape> PLANT_SHAPES = Maps.newHashMap();

    public static VoxelShape getPlantShape(int height) {
        return PLANT_SHAPES.computeIfAbsent(height, h -> Optional.of(Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)h.intValue(), (double)13.0)).get());
    }

    public BlockCropPlant() {
        super("crop_plant", AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200944_c().func_226896_b_().func_235838_a_(arg_0 -> ((InfProperty)LIGHT).fetch(arg_0)).func_200947_a(SoundType.field_222472_s));
    }

    public BiFunction<BlockState, IBlockReader, TileEntityCropPlant> getTileEntityFactory() {
        return TILE_FACTORY;
    }

    protected InfPropertyConfiguration getPropertyConfiguration() {
        return PROPERTIES;
    }

    public Item func_199767_j() {
        return AgriCraft.instance.getModItemRegistry().seed;
    }

    @Override
    protected boolean onFluidChanged(World world, BlockPos pos, BlockState state, Fluid oldFluid, Fluid newFluid) {
        return this.getCrop((IBlockReader)world, pos).map(crop -> {
            IAgriGrowthResponse response;
            if (crop.hasPlant() && (response = crop.getPlant().getGrowthRequirement(crop.getGrowthStage()).getFluidResponse(newFluid, crop.getStats().getStrength())).killInstantly()) {
                response.onPlantKilled((IAgriCrop)crop);
                world.func_175656_a(pos, newFluid.func_207188_f().func_206883_i());
                return true;
            }
            return false;
        }).orElse(false);
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return BlockCropPlant.getPlantShape(this.getCrop(world, pos).map(crop -> Math.max(crop.getPlant().getPlantHeight(crop.getGrowthStage()), crop.getWeeds().getPlantHeight(crop.getWeedGrowthStage()))).map(Double::intValue).orElse(0));
    }

    @Deprecated
    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    @Deprecated
    public VoxelShape func_230322_a_(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, world, pos, context);
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (hand == Hand.OFF_HAND) {
            return ActionResultType.PASS;
        }
        Optional<IAgriCrop> optional = this.getCrop((IBlockReader)world, pos);
        if (!optional.isPresent()) {
            return ActionResultType.FAIL;
        }
        IAgriCrop crop = optional.get();
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_190926_b()) {
            return crop.harvest(stack -> this.spawnItem(crop, (ItemStack)stack), (LivingEntity)player);
        }
        if (TypeHelper.isAnyType(heldItem.func_77973_b(), (Class[])ITEM_EXCLUDES)) {
            return ActionResultType.PASS;
        }
        if (AgriApi.getFertilizerAdapterizer().hasAdapter(heldItem)) {
            return AgriApi.getFertilizerAdapterizer().valueOf(heldItem).map(fertilizer -> {
                if (crop.acceptsFertilizer((IAgriFertilizer)fertilizer)) {
                    ActionResultType result = fertilizer.applyFertilizer(world, pos, crop, heldItem, world.func_201674_k(), (LivingEntity)player);
                    if (result.func_226246_a_()) {
                        crop.onApplyFertilizer((IAgriFertilizer)fertilizer, world.func_201674_k());
                    }
                    return result;
                }
                return ActionResultType.CONSUME;
            }).orElse(ActionResultType.PASS);
        }
        return crop.harvest(stack -> this.spawnItem(crop, (ItemStack)stack), (LivingEntity)player);
    }

    @Deprecated
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder context) {
        IAgriCrop crop;
        ArrayList drops = Lists.newArrayList();
        TileEntity tile = (TileEntity)context.func_216019_b(LootParameters.field_216288_h);
        if (tile instanceof IAgriCrop && (crop = (IAgriCrop)tile).hasPlant()) {
            crop.getPlant().getHarvestProducts(drops::add, crop.getGrowthStage(), crop.getStats(), context.func_216018_a().func_201674_k());
            if (crop.getGrowthStage().canDropSeed()) {
                crop.getGenome().map(IAgriGenome::toSeedStack).ifPresent(drops::add);
            }
        }
        return drops;
    }
}

