/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.capability;

import com.google.common.collect.Sets;
import com.infinityraider.agricraft.api.v1.crop.CropCapability;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.infinitylib.capability.IInfCapabilityImplementation;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;

public class CapabilityCrop
implements IInfCapabilityImplementation<TileEntity, IAgriCrop> {
    private static final CapabilityCrop INSTANCE = new CapabilityCrop();
    private static final CropSerializer SERIALIZER = new CropSerializer();
    private final Set<CropCapability.Instance<?, ?>> instances = Sets.newConcurrentHashSet();

    public static CapabilityCrop getInstance() {
        return INSTANCE;
    }

    private CapabilityCrop() {
    }

    public <T extends TileEntity, C extends IAgriCrop> void registerInstance(CropCapability.Instance<T, C> instance) {
        this.instances.add(instance);
    }

    public Class<IAgriCrop> getCapabilityClass() {
        return IAgriCrop.class;
    }

    public IInfCapabilityImplementation.Serializer<IAgriCrop> getSerializer() {
        return SERIALIZER;
    }

    public void copyData(IAgriCrop from, IAgriCrop to) {
        this.getSerializer().readFromNBT((Object)to, this.getSerializer().writeToNBT((Object)from));
    }

    public Capability<IAgriCrop> getCapability() {
        return CropCapability.CAPABILITY;
    }

    public boolean shouldApplyCapability(TileEntity carrier) {
        return this.instances.stream().anyMatch(instance -> instance.getCarrierClass().equals(carrier.getClass()));
    }

    public IAgriCrop createNewValue(TileEntity carrier) {
        return this.instances.stream().filter(instance -> instance.getCarrierClass().equals(carrier.getClass())).findAny().map(instance -> this.createInstance(carrier, (CropCapability.Instance)instance)).orElseThrow(() -> new IllegalArgumentException("Can not attach IAgriCrop capability to an unregistered TileEntity"));
    }

    private <T extends TileEntity, C extends IAgriCrop> C createInstance(TileEntity carrier, CropCapability.Instance<T, C> instance) {
        return instance.createCropFor(carrier);
    }

    public ResourceLocation getCapabilityKey() {
        return CropCapability.KEY;
    }

    public Class<TileEntity> getCarrierClass() {
        return TileEntity.class;
    }

    private static class CropSerializer
    implements IInfCapabilityImplementation.Serializer<IAgriCrop> {
        private CropSerializer() {
        }

        public CompoundNBT writeToNBT(IAgriCrop crop) {
            CompoundNBT tag = new CompoundNBT();
            this.fetchInstance(crop).writeToNBT(tag, crop);
            return tag;
        }

        public void readFromNBT(IAgriCrop crop, CompoundNBT tag) {
            this.fetchInstance(crop).readFromNBT(tag, crop);
        }

        private <T extends TileEntity, C extends IAgriCrop> CropCapability.Instance<T, C> fetchInstance(IAgriCrop crop) {
            return CapabilityCrop.getInstance().instances.stream().filter(instance -> instance.getCropClass().isAssignableFrom(crop.getClass())).findFirst().orElseThrow(() -> new IllegalArgumentException("Can not (de)serialize an unregistered crop capability"));
        }
    }
}

