/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.requirement;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.requirement.AgriSeason;
import com.infinityraider.agricraft.api.v1.requirement.IAgriGrowCondition;
import com.infinityraider.agricraft.api.v1.requirement.IAgriGrowthResponse;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoil;
import com.infinityraider.agricraft.api.v1.requirement.IDefaultGrowConditionFactory;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface IAgriGrowthRequirement {
    @Nonnull
    public Set<IAgriGrowCondition> getGrowConditions();

    public IAgriGrowthResponse getSoilHumidityResponse(IAgriSoil.Humidity var1, int var2);

    public IAgriGrowthResponse getSoilAcidityResponse(IAgriSoil.Acidity var1, int var2);

    public IAgriGrowthResponse getSoilNutrientsResponse(IAgriSoil.Nutrients var1, int var2);

    public IAgriGrowthResponse getLightLevelResponse(int var1, int var2);

    public IAgriGrowthResponse getSeasonResponse(AgriSeason var1, int var2);

    public IAgriGrowthResponse getFluidResponse(Fluid var1, int var2);

    default public IAgriGrowthResponse check(IAgriCrop crop) {
        return this.check(crop, crop.getStats().getStrength());
    }

    default public IAgriGrowthResponse check(IAgriCrop crop, int strength) {
        World world = crop.world();
        if (world == null) {
            return IAgriGrowthResponse.INFERTILE;
        }
        BlockPos pos = crop.getPosition();
        return this.check(world, pos, strength);
    }

    default public IAgriGrowthResponse check(World world, BlockPos pos, int strength) {
        return this.getGrowConditions().stream().map(condition -> condition.check(world, pos, strength)).filter(response -> !response.isFertile()).collect(IAgriGrowthResponse.COLLECTOR);
    }

    public static Builder builder() {
        return AgriApi.getGrowthRequirementBuilder();
    }

    public static interface Builder
    extends IDefaultGrowConditionFactory {
        public IAgriGrowthRequirement build();

        public Builder defineHumidity(BiFunction<Integer, IAgriSoil.Humidity, IAgriGrowthResponse> var1);

        public Builder defineAcidity(BiFunction<Integer, IAgriSoil.Acidity, IAgriGrowthResponse> var1);

        public Builder defineNutrients(BiFunction<Integer, IAgriSoil.Nutrients, IAgriGrowthResponse> var1);

        public Builder defineLightLevel(BiFunction<Integer, Integer, IAgriGrowthResponse> var1);

        public Builder defineFluid(BiFunction<Integer, Fluid, IAgriGrowthResponse> var1);

        public Builder defineSeasonality(BiFunction<Integer, AgriSeason, IAgriGrowthResponse> var1);

        public Builder addCondition(IAgriGrowCondition var1);
    }
}

