/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.requirement;

import com.infinityraider.agricraft.api.v1.AgriApi;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public enum AgriSeason {
    SPRING("spring"),
    SUMMER("summer"),
    AUTUMN("autumn", "fall"),
    WINTER("winter"),
    ANY("any", "all");

    private final List<String> keys;

    private AgriSeason(String ... keys) {
        this.keys = Arrays.asList(keys);
    }

    public boolean matches(AgriSeason other) {
        return other == this || other == ANY || this == ANY;
    }

    public boolean isSeason() {
        return this != ANY;
    }

    public TranslationTextComponent getDisplayName() {
        return new TranslationTextComponent("agricraft.season." + this.name().toLowerCase());
    }

    public static AgriSeason getSeason(World world, BlockPos pos) {
        return AgriApi.getSeasonLogic().getSeason(world, pos);
    }

    public static Optional<AgriSeason> fromString(String string) {
        return Arrays.stream(AgriSeason.values()).filter(season -> season.keys.stream().anyMatch(string::equalsIgnoreCase)).findAny();
    }

    public static Stream<AgriSeason> stream() {
        return Arrays.stream(AgriSeason.values()).filter(season -> season != ANY);
    }
}

