/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.plant;

import com.infinityraider.agricraft.api.v1.client.IAgriGrowableGuiRenderer;
import com.infinityraider.agricraft.api.v1.crop.IAgriGrowthStage;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface IAgriGrowable {
    @Nonnull
    public IAgriGrowthStage getInitialGrowthStage();

    @Nonnull
    public Collection<IAgriGrowthStage> getGrowthStages();

    default public IAgriGrowthStage getFinalStage() {
        return this.getGrowthStages().stream().filter(IAgriGrowthStage::isFinal).findAny().orElseThrow(() -> new IllegalStateException("Plant without final growth stage"));
    }

    public double getPlantHeight(IAgriGrowthStage var1);

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public List<BakedQuad> bakeQuads(@Nullable Direction var1, IAgriGrowthStage var2);

    @Nonnull
    public List<ResourceLocation> getTexturesFor(IAgriGrowthStage var1);

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    default public IAgriGrowableGuiRenderer getGuiRenderer() {
        return IAgriGrowableGuiRenderer.DEFAULT;
    }

    public static interface WithSeed
    extends IAgriGrowable {
        @Nonnull
        public ResourceLocation getSeedTexture();

        @Nonnull
        public ResourceLocation getSeedModel();

        @Override
        @Nonnull
        @OnlyIn(value=Dist.CLIENT)
        default public IAgriGrowableGuiRenderer.WithSeed getGuiRenderer() {
            return IAgriGrowableGuiRenderer.WithSeed.DEFAULT;
        }
    }
}

