/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.client;

import com.infinityraider.agricraft.api.v1.crop.IAgriGrowthStage;
import com.infinityraider.agricraft.api.v1.plant.IAgriGrowable;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public interface IAgriGrowableGuiRenderer {
    public static final IAgriGrowableGuiRenderer DEFAULT = new IAgriGrowableGuiRenderer(){};

    default public void drawGrowthStage(IAgriGrowable plant, IAgriGrowthStage stage, RenderContext context, MatrixStack transforms, float x, float y, float w, float h) {
        plant.getTexturesFor(stage).stream().findFirst().map(context::getSprite).ifPresent(sprite -> context.draw(transforms, (TextureAtlasSprite)sprite, x, y, w, h, 1.0f, 1.0f, 1.0f, 1.0f));
    }

    public static interface RenderContext {
        public void draw(MatrixStack var1, TextureAtlasSprite var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10);

        default public void draw(MatrixStack transforms, TextureAtlasSprite texture, float x, float y, float w, float h, int r, int g, int b, int a) {
            this.draw(transforms, texture, x, y, w, h, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
        }

        public TextureAtlasSprite getSprite(ResourceLocation var1);
    }

    public static interface WithSeed
    extends IAgriGrowableGuiRenderer {
        public static final WithSeed DEFAULT = new WithSeed(){};

        default public void drawSeed(IAgriGrowable.WithSeed plant, RenderContext context, MatrixStack transforms, float x, float y, float w, float h) {
            context.draw(transforms, context.getSprite(plant.getSeedTexture()), x, y, w, h, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

