/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricore.plant.particle;

import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.plant.particle.AgriParticle;
import java.util.Arrays;

public class AgriParticleEffect
extends AgriParticle {
    private final double probability;
    private final int[] stages;

    public AgriParticleEffect() {
        this.probability = 0.0;
        this.stages = new int[0];
    }

    public AgriParticleEffect(String particle, double deltaX, double deltaY, double deltaZ, double probability, int[] stages) {
        super(particle, deltaX, deltaY, deltaZ);
        this.probability = probability;
        this.stages = stages;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nAgriParticleEffect:");
        sb.append("\n\t- Particle: ").append(this.particle);
        sb.append("\n\t- DeltaX: ").append(this.delta_x);
        sb.append("\n\t- DeltaY: ").append(this.delta_y);
        sb.append("\n\t- DeltaZ: ").append(this.delta_z);
        sb.append("\n\t- Probability: ").append(this.probability);
        sb.append("\n\t- Stages: ").append(Arrays.toString(this.stages));
        return sb.toString();
    }

    public double getProbability() {
        return this.probability;
    }

    public boolean allowParticles(int index) {
        return Arrays.stream(this.stages).anyMatch(value -> value == index);
    }

    @Override
    public boolean validate() {
        if (!AgriCore.getValidator().isValidResource(this.particle)) {
            AgriCore.getCoreLogger().info("Invalid AgriParticleEffect! Invalid Particle Resource: \"{0}\"!", this.particle);
            return false;
        }
        return true;
    }
}

