/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricore.json;

import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.json.AgriFileWalker;
import com.agricraft.agricore.json.AgriJsonVersion;
import com.agricraft.agricore.json.AgriSaver;
import com.agricraft.agricore.json.AgriSerializable;
import com.agricraft.agricore.registry.AgriLoadableRegistry;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class AgriLoader {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static boolean doWriteBack() {
        return AgriCore.getConfig().enableJsonWriteback();
    }

    private AgriLoader() {
    }

    public static void loadDirectory(Path dir, AgriLoadableRegistry<?> ... registries) {
        try {
            Files.walkFileTree(dir, new AgriFileWalker(dir, registries));
        }
        catch (IOException e) {
            AgriCore.getCoreLogger().debug("Unable to load directory: \"{0}\"!", dir);
        }
    }

    protected static <T extends AgriSerializable & Comparable<T>> void loadElement(Path root, Path location, AgriLoadableRegistry<T> registry) {
        if (!Files.exists(location, new LinkOption[0])) {
            AgriCore.getCoreLogger().warn("Tried to load non-existant File: \"{0}\"!", location);
            return;
        }
        JsonElement json = AgriLoader.readJson(location);
        if (json == null) {
            return;
        }
        T obj = AgriLoader.parseVersionAware(json, location, registry.getElementVersion());
        if (obj == null) {
            AgriCore.getCoreLogger().warn("Could parse {0}, parser returned null.", location.getFileName());
            return;
        }
        obj.setPath(root.relativize(location).toString().replaceAll("\\\\", "/"));
        if (AgriLoader.doWriteBack()) {
            AgriSaver.saveElement(location, obj);
        }
        if (obj.checkMods()) {
            registry.registerElement(obj);
            AgriCore.getCoreLogger().info("Successfully loaded {0}.", location.getFileName());
        } else {
            AgriCore.getCoreLogger().info("Skipping {0}, Missing required mods.", location.getFileName());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static JsonElement readJson(Path location) {
        try (BufferedReader reader = Files.newBufferedReader(location);){
            JsonElement jsonElement = new JsonParser().parse((Reader)reader);
            return jsonElement;
        }
        catch (JsonParseException | IOException | NullPointerException e) {
            AgriCore.getCoreLogger().warn("Unable to read json: \"{0}\"!", location);
            AgriCore.getCoreLogger().trace((Exception)e);
            return null;
        }
    }

    @Nullable
    private static <T extends AgriSerializable & Comparable<T>> T parseVersionAware(JsonElement json, Path location, AgriJsonVersion<T> version) {
        String jsonVersion = AgriLoader.parseVersion(json, location);
        if (version.descriptor().equals(jsonVersion)) {
            return AgriLoader.parse(json, location, version.getElementClass());
        }
        AgriCore.getCoreLogger().warn("Attempting to parse {0} from an older version ({1}), required version is {2}.", location.getFileName(), jsonVersion, version.descriptor());
        AgriJsonVersion<?> prevVersion = version.previousVersion();
        Function<AgriSerializable, ?> converter = version.versionConverter();
        if (prevVersion != null && converter != null) {
            Object prev = AgriLoader.parseVersionAware(json, location, prevVersion);
            if (prev != null) {
                Path backupPath = Paths.get(location.toString().replaceAll("defaults", "backups/" + prevVersion.descriptor()), new String[0]);
                AgriSaver.saveElement(backupPath, prev);
                AgriSerializable obj = (AgriSerializable)converter.apply((AgriSerializable)prev);
                if (obj == null) {
                    AgriCore.getCoreLogger().warn("Could not convert {0} from {1} to {2}, version converter returned null.", location.getFileName(), jsonVersion, version.descriptor());
                }
                return (T)obj;
            }
            AgriCore.getCoreLogger().warn("Could not convert {0} from {1} to {2}, parsing of version {1} returned null.", location.getFileName(), jsonVersion, version.descriptor());
            return null;
        }
        AgriCore.getCoreLogger().warn("No conversion from version {0} to version {1} exists for this file, parsing with latest version.", location.getFileName(), jsonVersion, version.descriptor());
        return AgriLoader.parse(json, location, version.getElementClass());
    }

    @Nonnull
    private static String parseVersion(JsonElement json, Path location) {
        JsonObject jsonObject = json.getAsJsonObject();
        if (jsonObject.has("version")) {
            return jsonObject.get("version").getAsString();
        }
        AgriCore.getCoreLogger().warn("Could not identify version for {0}, assuming default version ({1}).", location.getFileName(), "1.12.2");
        return "1.12.2";
    }

    @Nullable
    private static <T extends AgriSerializable & Comparable<T>> T parse(JsonElement json, Path location, Class<T> clazz) {
        try {
            return (T)((AgriSerializable)GSON.fromJson(json, clazz));
        }
        catch (JsonParseException | NullPointerException e) {
            AgriCore.getCoreLogger().warn("Unable to parse json: \"{0}\"!", location);
            AgriCore.getCoreLogger().trace((Exception)e);
            return null;
        }
    }
}

