/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.utility;

import com.agricraft.agricore.core.AgriCore;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.infinityraider.agricraft.utility.StackHelper;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public final class OreDictUtil {
    public static final String PREFIX_OREDICT = "oredict";

    public static final boolean isValidOre(@Nullable String element) {
        if (element == null || element.isEmpty()) {
            return false;
        }
        String[] parts = element.split(":");
        if (parts.length == 1) {
            return false;
        }
        if (parts.length == 2) {
            return OreDictUtil.isValidOre(parts[0], parts[1]);
        }
        if (parts.length > 2) {
            AgriCore.getLogger("agricraft").warn("Invalid stack identifier detected!\n\tGiven: \"{0}\"\n\tAssuming: \"{1}:{2}\"", element, parts[0], parts[1]);
            return OreDictUtil.isValidOre(parts[0], parts[1]);
        }
        throw new AssertionError((Object)"String.split() method worked incorrectly. This should be an impossible error.");
    }

    public static final boolean isValidOre(@Nonnull String prefix, @Nonnull String suffix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"A stack identifier must have a non-null prefix!");
        Preconditions.checkNotNull((Object)suffix, (Object)"A stack identifier must have a non-null suffix!");
        if (!PREFIX_OREDICT.equals(prefix)) {
            return false;
        }
        if (!OreDictionary.doesOreNameExist((String)suffix)) {
            AgriCore.getLogger("agricraft").error("Unable to resolve Ore Dictionary Entry: \"{0}:{1}\".", prefix, suffix);
            return false;
        }
        return true;
    }

    @Nonnull
    public static Optional<ItemStack> getFirstOre(@Nonnull String oreName) {
        return OreDictionary.getOres((String)oreName).stream().findFirst();
    }

    @Nonnull
    public static final Optional<ItemStack> makeItemStack(@Nullable String element, int meta, int amount, @Nullable String tags) {
        if (element == null || element.isEmpty()) {
            return Optional.empty();
        }
        String[] parts = element.split(":");
        if (parts.length == 1) {
            return OreDictUtil.makeItemStack("minecraft", parts[0], meta, amount, tags);
        }
        if (parts.length == 2) {
            return OreDictUtil.makeItemStack(parts[0], parts[1], meta, amount, tags);
        }
        if (parts.length > 2) {
            AgriCore.getLogger("agricraft").warn("Invalid stack identifier detected!\n\tGiven: \"{0}\"\n\tAssuming: \"{1}:{2}\"", element, parts[0], parts[1]);
            return OreDictUtil.makeItemStack(parts[0], parts[1], meta, amount, tags);
        }
        throw new AssertionError((Object)"String.split() method worked incorrectly. This should be an impossible error.");
    }

    @Nonnull
    public static final Optional<ItemStack> makeItemStack(@Nonnull String prefix, @Nonnull String suffix, int meta, int amount, @Nullable String tags) {
        Preconditions.checkNotNull((Object)prefix, (Object)"A stack identifier must have a non-null prefix!");
        Preconditions.checkNotNull((Object)suffix, (Object)"A stack identifier must have a non-null suffix!");
        if (PREFIX_OREDICT.equals(prefix)) {
            return OreDictUtil.makeItemStackOreDict(prefix, suffix, meta, amount, tags);
        }
        return OreDictUtil.makeItemStackNormal(prefix, suffix, meta, amount, tags);
    }

    @Nonnull
    private static Optional<ItemStack> makeItemStackNormal(@Nonnull String prefix, @Nonnull String suffix, int meta, int amount, String tags) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(prefix, suffix));
        if (item == null) {
            AgriCore.getLogger("agricraft").error("Unable to resolve item: {0}:{1}.", prefix, suffix);
            return Optional.empty();
        }
        ItemStack stack = new ItemStack(item, amount, meta);
        return OreDictUtil.addNbtData(stack, tags);
    }

    @Nonnull
    private static Optional<ItemStack> makeItemStackOreDict(@Nonnull String prefix, @Nonnull String suffix, int meta, int amount, String tags) {
        return OreDictUtil.getFirstOre(suffix).map(s -> {
            s = s.func_77946_l();
            s.func_190920_e(amount);
            return s;
        }).flatMap(s -> OreDictUtil.addNbtData(s, tags));
    }

    @Nonnull
    private static Optional<ItemStack> addNbtData(@Nonnull ItemStack stack, @Nullable String tags) {
        Preconditions.checkNotNull((Object)stack, (Object)"The itemstack to add NBT data to may not be null");
        if (Strings.isNullOrEmpty((String)tags)) {
            return Optional.of(stack);
        }
        NBTTagCompound tag = StackHelper.getTag(stack);
        try {
            NBTTagCompound added = JsonToNBT.func_180713_a((String)tags);
            tag.func_179237_a(added);
            stack.func_77982_d(tag);
            return Optional.of(stack);
        }
        catch (NBTException e) {
            AgriCore.getLogger("agricraft").error("Unable to parse NBT Data: \"{0}\".\nCause: {1}", new Object[]{tags, e});
            return Optional.empty();
        }
    }

    private OreDictUtil() {
    }
}

