/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.items.modes;

import com.infinityraider.agricraft.api.v1.util.BlockRange;
import com.infinityraider.infinitylib.utility.debug.DebugMode;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockColored;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class DebugModeTestBlockRange
extends DebugMode {
    private static final String NBT_START = "agri_debug_blockrange_startpos";

    public String debugName() {
        return "test BlockRange";
    }

    public void debugActionBlockClicked(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return;
        }
        Optional<BlockPos> startPos = this.getStartPos(stack);
        if (!startPos.isPresent()) {
            this.setStartPos(stack, pos);
            player.func_145747_a((ITextComponent)new TextComponentString("Starting corner set: (" + pos.func_177958_n() + "," + pos.func_177956_o() + "," + pos.func_177952_p() + ")"));
            player.func_145747_a((ITextComponent)new TextComponentString("Next right click will set the opposite/ending corner."));
            player.func_145747_a((ITextComponent)new TextComponentString("WARNING: this mode will destroy blocks, be careful."));
        } else {
            int count = 0;
            IBlockState wool = Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.BLACK);
            BlockRange range = new BlockRange(startPos.get(), pos);
            for (BlockPos target : range) {
                IBlockState old = world.func_180495_p(target);
                world.func_175655_b(target, true);
                world.func_175656_a(target, wool);
                world.func_184138_a(target, old, wool, 2);
                ++count;
            }
            player.func_145747_a((ITextComponent)new TextComponentString("Volume:     " + range.getVolume()));
            player.func_145747_a((ITextComponent)new TextComponentString("Replaced:  " + count));
            player.func_145747_a((ITextComponent)new TextComponentString("Coverage: " + (range.getVolume() == count ? "Complete" : "INCOMPLETE")));
            this.setStartPos(stack, null);
        }
    }

    private Optional<BlockPos> getStartPos(@Nonnull ItemStack stack) {
        int[] raw;
        NBTTagCompound tag;
        if (!stack.func_77942_o()) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        } else {
            tag = stack.func_77978_p();
        }
        Optional<BlockPos> start = Optional.empty();
        assert (tag != null);
        if (tag.func_74764_b(NBT_START) && (raw = tag.func_74759_k(NBT_START)).length == 3) {
            BlockPos p = new BlockPos(raw[0], raw[1], raw[2]);
            start = Optional.of(p);
        }
        return start;
    }

    private void setStartPos(@Nonnull ItemStack stack, BlockPos p) {
        NBTTagCompound tag;
        if (!stack.func_77942_o()) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        } else {
            tag = stack.func_77978_p();
        }
        assert (tag != null);
        if (p == null) {
            tag.func_82580_o(NBT_START);
        } else {
            int[] start = new int[]{p.func_177958_n(), p.func_177956_o(), p.func_177952_p()};
            tag.func_74783_a(NBT_START, start);
        }
    }

    public void debugActionClicked(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
    }

    public void debugActionEntityClicked(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
    }
}

