/*
 * Decompiled with CFR 0.152.
 */
package com.advGenetics.TileEntity;

import cofh.api.energy.IEnergyHandler;
import com.advGenetics.API.Power.IPowerReceiver;
import com.advGenetics.AdvGenetics;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.tile.IEnergySink;
import java.lang.reflect.Constructor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="IC2"), @Optional.Interface(iface="cofh.api.energy.IEnergyHandler", modid="CoFHCore")})
public class TileEntityDNA
extends TileEntity
implements IPowerReceiver,
IEnergySink,
IEnergyHandler {
    public static float FROM_RF = 0.25f;
    public static float FROM_IC2 = 1.0f;
    public static float TO_RF = 1.0f / FROM_RF;
    public static float TO_IC2 = 1.0f / FROM_IC2;
    private int overclocker = 0;
    private boolean hasAutoOutputUpgrade = false;
    public int idle = 0;
    public boolean canExctract = true;
    public int storedEnergy = 0;
    public final int maxStroredEnergy = 8000;
    public static int energyRequiredForWork = AdvGenetics.machineEnergyUsingForWork;
    public int energyReq = 128;
    public final int energyPerEU = 4;
    public int energyReqTick = 0;
    private boolean addOnNextTick;
    private boolean wasAddedToIC2;

    public int getOverclocker() {
        return this.overclocker;
    }

    public boolean hasAutoOutputUpgrade() {
        return this.hasAutoOutputUpgrade;
    }

    public void addOverclocker(int amount) {
        this.overclocker += amount;
    }

    public void setHasAutoOutputUpgrade(boolean par1) {
        this.hasAutoOutputUpgrade = par1;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.overclocker = tag.func_74762_e("overclocker");
        this.hasAutoOutputUpgrade = tag.func_74767_n("autoOutputUpgrade");
        this.storedEnergy = tag.func_74762_e("storedEnergy");
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("overclocker", this.overclocker);
        tag.func_74757_a("autoOutputUpgrade", this.hasAutoOutputUpgrade);
        tag.func_74768_a("storedEnergy", this.storedEnergy);
    }

    public void setOverclocker(int par2) {
        this.overclocker = par2;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.addOnNextTick) {
            if (!this.field_145850_b.field_72995_K) {
                this.onLoaded();
            }
            this.addOnNextTick = false;
        }
        int eReq = Math.min(this.maxStroredEnergy - this.storedEnergy, energyRequiredForWork);
        this.energyReqTick = Math.max(this.energyReqTick + this.energyReqTick, this.energyReq);
    }

    public int getScaledEnergy(int pixel) {
        int i2 = this.storedEnergy > this.maxStroredEnergy ? this.maxStroredEnergy : this.storedEnergy;
        return i2 * pixel / this.maxStroredEnergy;
    }

    public int getMinEnergy(int maxIdle) {
        return this.maxStroredEnergy / 2;
    }

    public int getEnergyRequired() {
        return Math.min(this.maxStroredEnergy - this.storedEnergy, this.energyReqTick);
    }

    public int storeEnergy(int energy, boolean doStore) {
        int energyInjected = Math.max(Math.min(energy, this.getEnergyRequired()), 0);
        if (doStore) {
            this.storedEnergy += energyInjected;
            this.energyReqTick -= energyInjected;
        }
        return energyInjected;
    }

    public void onLoaded() {
        if (!this.wasAddedToIC2 && !FMLCommonHandler.instance().getEffectiveSide().isClient() && Loader.isModLoaded((String)"IC2")) {
            try {
                Constructor<?> contructor = Class.forName("ic2.api.energy.event.EnergyTileLoadEvent").getConstructor(Class.forName("ic2.api.energy.tile.IEnergyTile"));
                Object obj = contructor.newInstance(this);
                if (obj != null && obj instanceof Event) {
                    MinecraftForge.EVENT_BUS.post((Event)obj);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.wasAddedToIC2 = true;
        }
        if (!Loader.isModLoaded((String)"IC2")) {
            this.wasAddedToIC2 = false;
            this.addOnNextTick = false;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.onChunkUnload();
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.wasAddedToIC2) {
            this.addOnNextTick = true;
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.wasAddedToIC2 && Loader.isModLoaded((String)"IC2")) {
            try {
                Constructor<?> contructor = Class.forName("ic2.api.energy.event.EnergyTileUnloadEvent").getConstructor(Class.forName("ic2.api.energy.tile.IEnergyTile"));
                Object obj = contructor.newInstance(this);
                if (obj != null && obj instanceof Event) {
                    MinecraftForge.EVENT_BUS.post((Event)obj);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.wasAddedToIC2 = false;
        }
    }

    public int storeEnergy(int energy) {
        return this.storeEnergy(energy, true);
    }

    @Override
    public int getStoredEnergy() {
        return this.storedEnergy;
    }

    @Override
    public int getMaxStoredEnergy() {
        return this.maxStroredEnergy;
    }

    @Override
    public void setStoredEnergy(double par1) {
        this.storedEnergy = (int)par1;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 4, nbttagcompound);
    }

    @Optional.Method(modid="IC2")
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    @Optional.Method(modid="IC2")
    public double getDemandedEnergy() {
        return Math.max(Math.ceil((double)this.getEnergyRequired() / 4.0), 0.0);
    }

    @Optional.Method(modid="IC2")
    public int getSinkTier() {
        return 4;
    }

    @Optional.Method(modid="IC2")
    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        double euLeftOver = Math.max(amount, 0.0);
        euLeftOver -= (double)this.storeEnergy((int)(euLeftOver * 4.0)) / 4.0;
        return euLeftOver;
    }

    @Optional.Method(modid="CoFHCore")
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Optional.Method(modid="CoFHCore")
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        int energyReceived = (int)Math.min((float)(this.maxStroredEnergy - this.storedEnergy) * TO_RF, (float)maxReceive);
        if (!simulate) {
            this.storedEnergy = (int)((float)this.storedEnergy + (float)energyReceived * FROM_RF);
        }
        return energyReceived;
    }

    @Optional.Method(modid="CoFHCore")
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        int energyExtracted = (int)Math.min((float)this.storedEnergy * TO_RF, (float)maxExtract);
        if (!simulate) {
            this.storedEnergy = (int)((float)this.storedEnergy - (float)energyExtracted * FROM_RF);
        }
        return energyExtracted;
    }

    @Optional.Method(modid="CoFHCore")
    public int getEnergyStored(ForgeDirection from) {
        return (int)((float)this.storedEnergy * TO_RF);
    }

    @Optional.Method(modid="CoFHCore")
    public int getMaxEnergyStored(ForgeDirection from) {
        this.getClass();
        return (int)(8000.0f * TO_RF);
    }
}

