/*
 * Decompiled with CFR 0.152.
 */
package com.advGenetics.GUI.Container.Objects;

import com.advGenetics.API.Ability;
import com.advGenetics.Lib.AdvGenUtil;
import java.util.Random;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

public class BloodParticle {
    public double x;
    public double y;
    public float size = 0.3f;
    public AdvGenUtil.Color3f color;
    public Ability ability;
    public double minX;
    public double minY;
    public double maxX;
    public double maxY;
    public double vx;
    public double vy;
    public float alpha = -0.2f;
    public int analysingState = 0;
    public float progress = 0.0f;
    private Random rand = new Random();
    private boolean isFirtRender = true;
    public boolean isSelected = false;

    public BloodParticle(int minX, int minY, int maxX, int maxY, Ability ability) {
        this.color = new AdvGenUtil.Color3f(0.4f, 0.17f, 0.3f);
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        this.ability = ability;
        this.setRandomPosition();
        this.setRandomVelocity();
    }

    public void render() {
        this.update();
        GL11.glPushMatrix();
        if (!this.isFirtRender) {
            GL11.glColor4f((float)this.color.r, (float)this.color.g, (float)this.color.b, (float)Math.max(this.alpha, 0.0f));
            GL11.glTranslated((double)this.x, (double)this.y, (double)0.0);
            GL11.glScalef((float)this.size, (float)this.size, (float)0.0f);
            this.drawTexturedModalRect(0, 0, 0, 0, 59, 59);
            GL11.glPushMatrix();
            GL11.glColor4f((float)this.color.r, (float)this.color.g, (float)this.color.b, (float)(this.progress / 1.0f / 100.0f));
            this.drawTexturedModalRect(0, 0, 0, 0, 59, 59);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            if (this.isSelected) {
                GL11.glDisable((int)3553);
                this.drawTexturedModalRect(0, 0, 59, 0, 58, 56);
                GL11.glEnable((int)3553);
            }
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        this.isFirtRender = false;
    }

    public void update() {
        this.x += this.vx;
        this.y += this.vy;
        if (this.x - (double)this.size >= this.maxX - (double)((int)(this.size * 50.0f))) {
            this.vx = -this.vx;
        }
        if (this.x <= this.minX + 2.0) {
            this.vx = -this.vx;
        }
        if (this.y - (double)this.size >= this.maxY - (double)((int)(this.size * 50.0f))) {
            this.vy = -this.vy;
        }
        if (this.y <= this.minY + 2.0) {
            this.vy = -this.vy;
        }
        if (this.alpha < 0.8f) {
            this.alpha += 0.032f;
        }
    }

    private void drawTexturedModalRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        float zLevel = 1.0f;
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + par6), (double)zLevel, (double)((float)(par3 + 0) * f), (double)((float)(par4 + par6) * f1));
        tessellator.func_78374_a((double)(par1 + par5), (double)(par2 + par6), (double)zLevel, (double)((float)(par3 + par5) * f), (double)((float)(par4 + par6) * f1));
        tessellator.func_78374_a((double)(par1 + par5), (double)(par2 + 0), (double)zLevel, (double)((float)(par3 + par5) * f), (double)((float)(par4 + 0) * f1));
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + 0), (double)zLevel, (double)((float)(par3 + 0) * f), (double)((float)(par4 + 0) * f1));
        tessellator.func_78381_a();
    }

    private void setRandomPosition() {
        this.x = Math.min(Math.max((double)this.rand.nextInt((int)this.maxX), this.minX + 20.0), (double)((int)this.maxX - (int)(this.size * 50.0f)));
        this.y = Math.min(Math.max((double)this.rand.nextInt((int)this.maxY), this.minY + 20.0), (double)((int)this.maxY - (int)(this.size * 50.0f)));
    }

    private void setRandomVelocity() {
        double d;
        double d2;
        do {
            this.vx = this.rand.nextDouble();
        } while (d2 > 0.018 && this.vx > 0.0);
        do {
            this.vy = this.rand.nextDouble();
        } while (d > 0.018 && this.vy > 0.0);
    }
}

