/*
 * Decompiled with CFR 0.152.
 */
package com.advGenetics.Event;

import com.advGenetics.API.Ability;
import com.advGenetics.API.ILivingJoin;
import com.advGenetics.DNA.AbilityRegistry;
import com.advGenetics.DNA.DNA;
import com.advGenetics.Event.DNAChangeEvent;
import com.advGenetics.Lib.AdvGenUtil;
import com.advGenetics.Lib.GeneHelper;
import com.advGenetics.Lib.PacketWrapper;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

public class JoinEventHandler {
    public static Map<Integer, NBTTagCompound> entityDimBuffer = new HashMap<Integer, NBTTagCompound>();

    @SubscribeEvent
    public void onLivingJoin(EntityJoinWorldEvent event) {
        if (event.entity.getEntityData().func_74764_b("dna_transmutators")) {
            DNA dna = new DNA(event.entity.getEntityData());
            for (Ability ability : AbilityRegistry.ab_event_join) {
                if (!dna.hasGene(ability) || !AdvGenUtil.canDebugEvent(GeneHelper.getAbility(ability.getClass()), event.entity)) continue;
                ((ILivingJoin)((Object)ability)).onLivingJoin(event);
            }
            MinecraftForge.EVENT_BUS.post((Event)new DNAChangeEvent(event.entity));
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.world.field_72995_K && event.entity instanceof EntityPlayer) {
            if (entityDimBuffer.containsKey(event.entity.hashCode())) {
                DNA dna = new DNA(entityDimBuffer.get(event.entity.hashCode()));
                event.entity.getEntityData().func_74778_a("dna_transmutators", dna.getTransmutators());
                AdvGenUtil.updatePlayerCapatilities(dna, event.entity);
                PacketWrapper.sendDNASyncPacket(10, dna.getTransmutators(), event.entity.hashCode());
            } else {
                entityDimBuffer.put(event.entity.hashCode(), event.entity.getEntityData());
            }
        }
    }

    public static void removeEntityFromDimBuffer(Entity entity) {
        if (entityDimBuffer.containsKey(entity.hashCode())) {
            entityDimBuffer.remove(entity.hashCode());
        }
    }

    public static void updateEntityDimBuffer(Entity entity) {
        entityDimBuffer.put(entity.hashCode(), entity.getEntityData());
    }

    @SubscribeEvent
    public void onDNAChange(DNAChangeEvent event) {
        if (event.target.field_70170_p.field_73011_w.field_76574_g == 1) {
            JoinEventHandler.updateEntityDimBuffer(event.target);
        }
    }
}

