/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import xaero.map.WorldMap;
import xaero.map.controls.ControlsRegister;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiPlayerTpCommand;
import xaero.map.gui.GuiSettings;
import xaero.map.gui.GuiTexturedButton;
import xaero.map.gui.MyTinyButton;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.settings.ModOptions;

public class GuiWorldMapSettings
extends GuiSettings {
    private static final int PAGES = 3;
    public Button minimapButton;
    public Button playerTeleportButton;
    private CursorBox playerTeleportButtonTooltip = new CursorBox("gui.xaero_wm_box_pac_player_teleport_command");
    public Button prevButton;
    public Button nextButton;
    private int page;

    public GuiWorldMapSettings() {
        this(null);
    }

    public GuiWorldMapSettings(Screen parent) {
        this(parent, null);
    }

    public GuiWorldMapSettings(Screen parent, Screen escapeScreen) {
        super(parent, escapeScreen, WorldMap.settings, (Component)new TranslatableComponent("gui.xaero_world_map_settings"));
    }

    @Override
    public void m_7856_() {
        if (this.page == 0) {
            this.options = new ModOptions[]{ModOptions.LIGHTING, ModOptions.COLOURS, ModOptions.LOAD, ModOptions.UPDATE, ModOptions.DEPTH, ModOptions.SLOPES, ModOptions.STEPS, ModOptions.COORDINATES, ModOptions.WAYPOINTS, ModOptions.WAYPOINT_BACKGROUNDS, ModOptions.WAYPOINT_SCALE};
            this.minimapButton = new Button(this.f_96543_ / 2 + 5, this.f_96544_ / 7 + 120, 200, 20, (Component)new TextComponent("Minimap Settings"), b -> SupportMods.xaeroMinimap.openSettings(this.f_96541_, this, this.escape));
            this.m_142416_((GuiEventListener)this.minimapButton);
            this.minimapButton.f_93623_ = SupportMods.minimap();
        } else if (this.page == 1) {
            this.options = new ModOptions[]{ModOptions.MIN_ZOOM_LOCAL_WAYPOINTS, ModOptions.BIOMES, ModOptions.ADJUST_HEIGHT_FOR_SHORT_BLOCKS, ModOptions.FLOWERS, ModOptions.ARROW, ModOptions.IGNORE_HEIGHTMAPS, ModOptions.ARROW_COLOUR, ModOptions.OPEN_ANIMATION, ModOptions.DISPLAY_ZOOM, ModOptions.ZOOM_BUTTONS, ModOptions.DETECT_AMBIGUOUS_Y};
            this.playerTeleportButton = new Button(this.f_96543_ / 2 + 5, this.f_96544_ / 7 + 120, 200, 20, (Component)new TranslatableComponent("gui.xaero_wm_pac_player_teleport_command"), b -> this.f_96541_.m_91152_((Screen)new GuiPlayerTpCommand(this, this.escape)));
            this.m_142416_((GuiEventListener)this.playerTeleportButton);
        } else {
            this.options = new ModOptions[]{ModOptions.PAC_CLAIMS, ModOptions.PAC_CLAIMS_OPACITY, ModOptions.UPDATE_NOTIFICATION, ModOptions.RELOAD, ModOptions.DEBUG};
        }
        this.nextButton = new MyTinyButton(this.f_96543_ / 2 + 130, this.f_96544_ / 7 + 144, (Component)new TranslatableComponent("gui.xaero_wm_next", new Object[0]), b -> this.onNextButton());
        this.m_142416_((GuiEventListener)this.nextButton);
        this.nextButton.f_93623_ = this.isNextButtonEnabled();
        this.prevButton = new MyTinyButton(this.f_96543_ / 2 - 205, this.f_96544_ / 7 + 144, (Component)new TranslatableComponent("gui.xaero_wm_previous", new Object[0]), b -> this.onPrevButton());
        this.m_142416_((GuiEventListener)this.prevButton);
        this.prevButton.f_93623_ = this.isPrevButtonEnabled();
        super.m_7856_();
        if (this.parent instanceof GuiMap) {
            this.m_142416_((GuiEventListener)new GuiTexturedButton(0, 0, 30, 30, 113, 0, 20, 20, WorldMap.guiTextures, this::onSettingsButton, new CursorBox(I18n.m_118938_((String)"gui.xaero_box_close_settings", (Object[])new Object[]{Misc.getKeyName(ControlsRegister.keyOpenSettings)}))));
        }
    }

    private void onSettingsButton(AbstractWidget button) {
        this.goBack();
    }

    private void onPrevButton() {
        --this.page;
        if (this.page < 0) {
            this.page = 0;
        }
        this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
    }

    private void onNextButton() {
        ++this.page;
        if (this.page >= 3) {
            this.page = 2;
        }
        this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
    }

    private boolean isPrevButtonEnabled() {
        return this.page > 0;
    }

    private boolean isNextButtonEnabled() {
        return this.page < 2;
    }

    @Override
    public void m_6305_(PoseStack matrixStack, int par1, int par2, float par3) {
        this.renderEscapeScreen(matrixStack, par1, par2, par3);
        super.m_6305_(matrixStack, par1, par2, par3);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, 0.1);
        for (GuiEventListener el : this.m_6702_()) {
            if (!(el instanceof AbstractWidget)) continue;
            AbstractWidget b = (AbstractWidget)el;
            if (par1 < b.f_93620_ || par2 < b.f_93621_ || par1 >= b.f_93620_ + 150 || par2 >= b.f_93621_ + 20 || b != this.playerTeleportButton) continue;
            this.playerTeleportButtonTooltip.drawBox(matrixStack, par1, par2, this.f_96543_, this.f_96544_);
        }
        matrixStack.m_85849_();
    }
}

