/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.mods;

import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.opengl.GL14;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.minimap.region.MinimapTile;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.settings.ModSettings;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiWorldMapSettings;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTileChunk;
import xaero.map.world.MapDimension;
import xaero.map.world.MapWorld;

public class SupportXaeroWorldmap {
    private static final HashMap<MapTileChunk, Long> seedsUsed = new HashMap();
    public static final int black = -16777216;
    public static final int slime = -2142047936;
    private IXaeroMinimap modMain;

    public SupportXaeroWorldmap(IXaeroMinimap modMain) {
        this.modMain = modMain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawMinimap(XaeroMinimapSession minimapSession, MinimapRendererHelper helper, int xFloored, int zFloored, int radius, boolean zooming, double zoom) {
        Gui.func_73734_a((int)-256, (int)-256, (int)256, (int)256, (int)-16777216);
        Object object = MapProcessor.instance.renderThreadPauseSync;
        synchronized (object) {
            if (!MapProcessor.instance.isRenderingPaused()) {
                if (MapProcessor.instance.getCurrentDimension() == null) {
                    return;
                }
                String worldString = MapProcessor.instance.getCurrentWorldString();
                if (worldString == null) {
                    return;
                }
                int mapX = xFloored >> 4;
                int mapZ = zFloored >> 4;
                int chunkX = mapX >> 2;
                int chunkZ = mapZ >> 2;
                int tileX = mapX & 3;
                int tileZ = mapZ & 3;
                int insideX = xFloored & 0xF;
                int insideZ = zFloored & 0xF;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179147_l();
                int minX = (mapX >> 2) - 4;
                int maxX = (mapX >> 2) + 4;
                int minZ = (mapZ >> 2) - 4;
                int maxZ = (mapZ >> 2) + 4;
                int minViewX = (mapX >> 2) - radius;
                int maxViewX = (mapX >> 2) + radius + 1;
                int minViewZ = (mapZ >> 2) - radius;
                int maxViewZ = (mapZ >> 2) + radius + 1;
                for (int i = minX; i < maxX + 1; ++i) {
                    for (int j = minZ; j < maxZ + 1; ++j) {
                        boolean newSeed;
                        MapTileChunk chunk;
                        MapRegion region = MapProcessor.instance.getMapRegion(i >> 3, j >> 3, MapProcessor.instance.regionExists(i >> 3, j >> 3));
                        if (region == null) continue;
                        MapRegion mapRegion = region;
                        synchronized (mapRegion) {
                            if (!region.recacheHasBeenRequested() && !region.reloadHasBeenRequested() && (region.getVersion() != MapProcessor.instance.getGlobalVersion() || region.getLoadState() == 4 && region.shouldCache())) {
                                if (region.isBeingWritten() && region.getLoadState() == 2) {
                                    region.requestRefresh();
                                } else if (region.getLoadState() == 0 || region.getLoadState() == 4) {
                                    MapProcessor.instance.getMapSaveLoad().requestLoad(region, "Minimap");
                                    MapProcessor.instance.getMapSaveLoad().setNextToLoadByViewing(region);
                                }
                            }
                        }
                        if (!MapProcessor.instance.isUploadingPaused()) {
                            List regions = MapProcessor.instance.getMapWorld().getCurrentDimension().getMapRegionsList();
                            regions.remove(region);
                            regions.add(region);
                        }
                        if (i < minViewX || i > maxViewX || j < minViewZ || j > maxViewZ || (chunk = region.getChunk(i & 7, j & 7)) == null || chunk.getGlColorTexture() == -1) continue;
                        GuiMap.bindMapTextureWithLighting((MapTileChunk)chunk, (int)(zooming ? 9729 : 9728), (int)0);
                        int drawX = 64 * (chunk.getX() - chunkX) - 16 * tileX - insideX;
                        int drawZ = 64 * (chunk.getZ() - chunkZ) - 16 * tileZ - insideZ;
                        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
                        GuiMap.renderTexturedModalRectWithLighting((float)drawX, (float)drawZ, (int)0, (int)0, (float)64.0f, (float)64.0f);
                        int r = 0;
                        int g = 0;
                        int b = 0;
                        if (this.modMain.getSettings().chunkGrid > -1) {
                            int grid = ModSettings.COLORS[this.modMain.getSettings().chunkGrid];
                            r = grid >> 16 & 0xFF;
                            g = grid >> 8 & 0xFF;
                            b = grid & 0xFF;
                        }
                        Long seed = this.modMain.getSettings().getSlimeChunksSeed(minimapSession.getWaypointsManager());
                        Long savedSeed = seedsUsed.get(chunk);
                        boolean bl = newSeed = seed == null && savedSeed != null || seed != null && !seed.equals(savedSeed);
                        if (newSeed) {
                            seedsUsed.put(chunk, seed);
                        }
                        GuiMap.restoreTextureStates();
                        for (int t = 0; t < 16; ++t) {
                            if (newSeed || (chunk.getTileGridsCache()[t % 4][t / 4] & 1) == 0) {
                                chunk.getTileGridsCache()[t % 4][t / 4] = (byte)(1 | (MinimapTile.isSlimeChunk(this.modMain.getSettings(), chunk.getX() * 4 + t % 4, chunk.getZ() * 4 + t / 4, seed) ? 2 : 0));
                            }
                            if (!this.modMain.getSettings().getSlimeChunks(minimapSession.getWaypointsManager()) || (chunk.getTileGridsCache()[t % 4][t / 4] & 2) == 0) continue;
                            int slimeDrawX = drawX + 16 * (t % 4);
                            int slimeDrawZ = drawZ + 16 * (t / 4);
                            Gui.func_73734_a((int)slimeDrawX, (int)slimeDrawZ, (int)(slimeDrawX + 16), (int)(slimeDrawZ + 16), (int)-2142047936);
                        }
                        if (this.modMain.getSettings().chunkGrid > -1) {
                            float top;
                            GlStateManager.func_179090_x();
                            GlStateManager.func_179147_l();
                            GlStateManager.func_179094_E();
                            GlStateManager.func_179109_b((float)(drawX + 64), (float)(drawZ + 64), (float)0.0f);
                            GlStateManager.func_179139_a((double)(1.0 / zoom), (double)(1.0 / zoom), (double)1.0);
                            GlStateManager.func_179131_c((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)0.5f);
                            float left = top = (float)(-64.0 * zoom);
                            helper.drawMyColoredRect(left, -1.0f, 0.0f, 0.0f);
                            helper.drawMyColoredRect(left, (float)(-16.0 * zoom) - 1.0f, 0.0f, (float)(-16.0 * zoom));
                            helper.drawMyColoredRect(left, (float)(-32.0 * zoom) - 1.0f, 0.0f, (float)(-32.0 * zoom));
                            helper.drawMyColoredRect(left, (float)(-48.0 * zoom) - 1.0f, 0.0f, (float)(-48.0 * zoom));
                            helper.drawMyColoredRect(-1.0f, top, 0.0f, 0.0f);
                            helper.drawMyColoredRect((float)(-16.0 * zoom) - 1.0f, top, (float)(-16.0 * zoom), 0.0f);
                            helper.drawMyColoredRect((float)(-32.0 * zoom) - 1.0f, top, (float)(-32.0 * zoom), 0.0f);
                            helper.drawMyColoredRect((float)(-48.0 * zoom) - 1.0f, top, (float)(-48.0 * zoom), 0.0f);
                            GlStateManager.func_179121_F();
                            GlStateManager.func_179084_k();
                            GlStateManager.func_179098_w();
                        }
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        GlStateManager.func_179147_l();
                    }
                }
                GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
                GlStateManager.func_179084_k();
            }
        }
    }

    public boolean getWorldMapWaypoints() {
        return WorldMap.settings.waypoints;
    }

    public int getWorldMapColours() {
        return WorldMap.settings.colours;
    }

    public boolean getWorldMapFlowers() {
        return WorldMap.settings.flowers;
    }

    public boolean getWorldMapLighting() {
        return WorldMap.settings.lighting;
    }

    public boolean getWorldMapTerrainDepth() {
        return WorldMap.settings.terrainDepth;
    }

    public boolean getWorldMapTerrainSlopes() {
        return WorldMap.settings.terrainSlopes;
    }

    public boolean getWorldMapBiomeColorsVanillaMode() {
        return WorldMap.settings.biomeColorsVanillaMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMultiworldId(int dimId) {
        Object object = MapProcessor.instance.uiSync;
        synchronized (object) {
            MapWorld mapWorld = MapProcessor.instance.getMapWorld();
            MapDimension mapDim = mapWorld == null ? null : mapWorld.getDimension(dimId);
            return mapDim == null || !mapDim.currentMultiworldWritable ? null : mapDim.getCurrentMultiworld();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMultiworldName(int dimId, String multiworldId) {
        Object object = MapProcessor.instance.uiSync;
        synchronized (object) {
            MapWorld mapWorld = MapProcessor.instance.getMapWorld();
            MapDimension mapDim = mapWorld == null ? null : mapWorld.createDimension(null, dimId);
            return mapDim == null ? null : mapDim.getMultiworldName(multiworldId);
        }
    }

    public void openSettings() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiWorldMapSettings(Minecraft.func_71410_x().field_71462_r));
    }
}

